/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.style;

import java.util.HashMap;
import java.util.Map;

import org.trix.cuery.value.Value;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: SimpleStyle.java,v 1.0 2005/08/10 18:13:00 Teletha Exp $
 */
public class SimpleStyle extends AbstractStyle {

    /** The map of properties. */
    private Map<String, Object[]> properties = new HashMap<String, Object[]>(8);

    /**
     * @see org.trix.cuery.style.Style#getPropertyValue(java.lang.String)
     */
    public Value getPropertyValue(String name) {
        Object[] objects = properties.get(name);

        if (objects == null) {
            return null;
        }
        return (Value) objects[0];
    }

    /**
     * @see org.trix.cuery.style.Style#isImportant(java.lang.String)
     */
    public boolean isImportant(String name) {
        Object[] objects = properties.get(name);

        if (objects == null) {
            return false;
        }
        return (Boolean) objects[1];
    }

    /**
     * Add a property.
     * 
     * @param name A property name.
     * @param value A prperty value.
     * @param important A important priority.
     */
    public void setProperty(String name, Value value, boolean important) {
        properties.put(name, new Object[] {value, important});
    }

}
