/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.sac;

import org.trix.cuery.filter.ChildFilter;
import org.trix.cuery.filter.DescendantFilter;
import org.trix.cuery.filter.DirectAdjacentFilter;
import org.trix.cuery.filter.ElementFilter;
import org.trix.cuery.filter.MultipleFilter;
import org.trix.cuery.util.CSSUtil;

import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CharacterDataSelector;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.NegativeSelector;
import org.w3c.css.sac.ProcessingInstructionSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorFactory;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: SelectorFactoryImpl.java,v 1.0 2005/07/29 10:46:23 Teletha Exp $
 */
public class SelectorFactoryImpl implements SelectorFactory {

    /**
     * @see org.w3c.css.sac.SelectorFactory#createConditionalSelector(org.w3c.css.sac.SimpleSelector,
     *      org.w3c.css.sac.Condition)
     */
    public ConditionalSelector createConditionalSelector(SimpleSelector selector, Condition condition)
            throws CSSException {
        return new MultipleFilter(CSSUtil.converte(selector), CSSUtil.converte(condition));
    }

    /**
     * @see org.w3c.css.sac.SelectorFactory#createAnyNodeSelector()
     */
    public SimpleSelector createAnyNodeSelector() throws CSSException {
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }

    /**
     * @see org.w3c.css.sac.SelectorFactory#createRootNodeSelector()
     */
    public SimpleSelector createRootNodeSelector() throws CSSException {
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }

    /**
     * @see org.w3c.css.sac.SelectorFactory#createNegativeSelector(org.w3c.css.sac.SimpleSelector)
     */
    public NegativeSelector createNegativeSelector(SimpleSelector selector) throws CSSException {
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }

    /**
     * @see org.w3c.css.sac.SelectorFactory#createElementSelector(java.lang.String,
     *      java.lang.String)
     */
    public ElementSelector createElementSelector(String namespaceURI, String localName) throws CSSException {
        if (namespaceURI != null) {
            throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
        } else {
            return new ElementFilter(null, namespaceURI, localName);
        }
    }

    /**
     * @see org.w3c.css.sac.SelectorFactory#createTextNodeSelector(java.lang.String)
     */
    public CharacterDataSelector createTextNodeSelector(String data) throws CSSException {
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }

    /**
     * @see org.w3c.css.sac.SelectorFactory#createCDataSectionSelector(java.lang.String)
     */
    public CharacterDataSelector createCDataSectionSelector(String data) throws CSSException {
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }

    /**
     * @see org.w3c.css.sac.SelectorFactory#createProcessingInstructionSelector(java.lang.String,
     *      java.lang.String)
     */
    public ProcessingInstructionSelector createProcessingInstructionSelector(String target, String data)
            throws CSSException {
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }

    /**
     * @see org.w3c.css.sac.SelectorFactory#createCommentSelector(java.lang.String)
     */
    public CharacterDataSelector createCommentSelector(String data) throws CSSException {
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }

    /**
     * @see org.w3c.css.sac.SelectorFactory#createPseudoElementSelector(java.lang.String,
     *      java.lang.String)
     */
    public ElementSelector createPseudoElementSelector(String namespaceURI, String pseudoName) throws CSSException {
        if (namespaceURI != null) {
            throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
        }
        return (ElementSelector) CSSUtil.createPseudoFilter(pseudoName);
    }

    /**
     * @see org.w3c.css.sac.SelectorFactory#createDescendantSelector(org.w3c.css.sac.Selector,
     *      org.w3c.css.sac.SimpleSelector)
     */
    public DescendantSelector createDescendantSelector(Selector parent, SimpleSelector descendant) throws CSSException {
        return new DescendantFilter(parent, descendant);
    }

    /**
     * @see org.w3c.css.sac.SelectorFactory#createChildSelector(org.w3c.css.sac.Selector,
     *      org.w3c.css.sac.SimpleSelector)
     */
    public DescendantSelector createChildSelector(Selector parent, SimpleSelector child) throws CSSException {
        return new ChildFilter(parent, child);
    }

    /**
     * @see org.w3c.css.sac.SelectorFactory#createDirectAdjacentSelector(short,
     *      org.w3c.css.sac.Selector, org.w3c.css.sac.SimpleSelector)
     */
    public SiblingSelector createDirectAdjacentSelector(short nodeType, Selector parent, SimpleSelector directAdjacent)
            throws CSSException {
        return new DirectAdjacentFilter(nodeType, parent, directAdjacent);
    }

}
