/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.filter;


/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: TokensFilter.java,v 1.0 2005/07/26 17:56:04 Teletha Exp $
 */
public class TokensFilter extends AttributeFilter {

    /**
     * Create TokensFilter instance.
     * 
     * @param name An attribute name.
     * @param value An attribute value.
     */
    public TokensFilter(String name, String value) {
        super(name, value);
    }

    /**
     * @see org.trix.cuery.filter.AttributeFilter#acceptAttribute(java.lang.String)
     */
    protected boolean acceptAttribute(String attributeValue) {
        // check null
        if (attributeValue == null || attributeValue.length() < value.length()) {
            return false;
        }

        String[] tokens = attributeValue.split(" ");

        for (String token : tokens) {
            if (acceptToken(token)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Check whether this token can be acceptable or not.
     * 
     * @param token An attribute token.
     * @return A result.
     */
    protected boolean acceptToken(String token) {
        return token.equals(value);
    }

    /**
     * @see org.w3c.css.sac.Condition#getConditionType()
     */
    public short getConditionType() {
        return SAC_ONE_OF_ATTRIBUTE_CONDITION;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return "[" + name + "~=\"" + value + "\"]";
    }

}
