/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.filter;

import org.trix.cuery.util.CSSUtil;

import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SimpleSelector;
import org.w3c.dom.Element;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: AbstractProcessingFilter.java,v 1.01 2005/08/05 13:34:26 Teletha Exp $
 */
public abstract class AbstractProcessingFilter implements ProcessingFilter {

    /** The parent selector. */
    protected Filter parent;

    /** The current selector. */
    protected Filter current;

    /**
     * Create AbstractProcessingFilter instance.
     * 
     * @param parent A parent selector.
     * @param current A current selector.
     */
    public AbstractProcessingFilter(Selector parent, SimpleSelector current) {
        this.parent = CSSUtil.converte(parent);
        this.current = CSSUtil.converte(current);
    }

    /**
     * @see org.trix.cuery.filter.Filter#getSpecificity()
     */
    public int getSpecificity() {
        return parent.getSpecificity() + current.getSpecificity();
    }

    /**
     * @see org.trix.cuery.filter.ProcessingFilter#getSelector()
     */
    public Selector getSelector() {
        return parent;
    }

    /**
     * @see org.trix.cuery.filter.ProcessingFilter#getSimpleSelector()
     */
    public SimpleSelector getSimpleSelector() {
        return (SimpleSelector) current;
    }

    /**
     * @see org.w3c.css.sac.Selector#getSelectorType()
     */
    public short getSelectorType() {
        return 0;
    }

    /**
     * @see org.trix.cuery.filter.Filter#accept(org.w3c.dom.Element)
     */
    public boolean accept(Element target) {
        return false;
    }

    /**
     * @see org.w3c.css.sac.Condition#getConditionType()
     */
    public short getConditionType() {
        return SAC_AND_CONDITION;
    }
}
