/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.css;

import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: AbstractCSSPipe.java,v 1.0 2005/08/05 19:32:41 Teletha Exp $
 */
public abstract class AbstractCSSPipe implements CSSPipe {

    /** The actual css consumer. */
    protected CSSConsumer consumer;

    /**
     * @see org.w3c.css.sac.DocumentHandler#startDocument(org.w3c.css.sac.InputSource)
     */
    public void startDocument(InputSource source) throws CSSException {
        if (consumer != null) {
            consumer.startDocument(source);
        }
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#endDocument(org.w3c.css.sac.InputSource)
     */
    public void endDocument(InputSource source) throws CSSException {
        if (consumer != null) {
            consumer.endDocument(source);
        }
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#comment(java.lang.String)
     */
    public void comment(String data) throws CSSException {
        if (consumer != null) {
            consumer.comment(data);
        }
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#ignorableAtRule(java.lang.String)
     */
    public void ignorableAtRule(String data) throws CSSException {
        if (consumer != null) {
            consumer.ignorableAtRule(data);
        }
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#namespaceDeclaration(java.lang.String, java.lang.String)
     */
    public void namespaceDeclaration(String prefix, String namespaceURI) throws CSSException {
        if (consumer != null) {
            consumer.namespaceDeclaration(prefix, namespaceURI);
        }
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#importStyle(java.lang.String,
     *      org.w3c.css.sac.SACMediaList, java.lang.String)
     */
    public void importStyle(String uri, SACMediaList mediaList, String defaultNamespaceURI) throws CSSException {
        if (consumer != null) {
            consumer.importStyle(uri, mediaList, defaultNamespaceURI);
        }
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#startMedia(org.w3c.css.sac.SACMediaList)
     */
    public void startMedia(SACMediaList mediaList) throws CSSException {
        if (consumer != null) {
            consumer.startMedia(mediaList);
        }
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#endMedia(org.w3c.css.sac.SACMediaList)
     */
    public void endMedia(SACMediaList mediaList) throws CSSException {
        if (consumer != null) {
            consumer.endMedia(mediaList);
        }
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#startPage(java.lang.String, java.lang.String)
     */
    public void startPage(String name, String page) throws CSSException {
        if (consumer != null) {
            consumer.startPage(name, page);
        }
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#endPage(java.lang.String, java.lang.String)
     */
    public void endPage(String name, String page) throws CSSException {
        if (consumer != null) {
            consumer.endPage(name, page);
        }
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#startFontFace()
     */
    public void startFontFace() throws CSSException {
        if (consumer != null) {
            consumer.startFontFace();
        }
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#endFontFace()
     */
    public void endFontFace() throws CSSException {
        if (consumer != null) {
            consumer.endFontFace();
        }
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#startSelector(org.w3c.css.sac.SelectorList)
     */
    public void startSelector(SelectorList selectorList) throws CSSException {
        if (consumer != null) {
            consumer.startSelector(selectorList);
        }
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#endSelector(org.w3c.css.sac.SelectorList)
     */
    public void endSelector(SelectorList selectorList) throws CSSException {
        if (consumer != null) {
            consumer.endSelector(selectorList);
        }
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#property(java.lang.String, org.w3c.css.sac.LexicalUnit,
     *      boolean)
     */
    public void property(String name, LexicalUnit value, boolean important) throws CSSException {
        if (consumer != null) {
            consumer.property(name, value, important);
        }
    }

    /**
     * @see org.w3c.css.sac.ErrorHandler#error(org.w3c.css.sac.CSSParseException)
     */
    public void error(CSSParseException exception) throws CSSException {
        if (consumer != null) {
            consumer.error(exception);
        }
    }

    /**
     * @see org.w3c.css.sac.ErrorHandler#fatalError(org.w3c.css.sac.CSSParseException)
     */
    public void fatalError(CSSParseException exception) throws CSSException {
        if (consumer != null) {
            consumer.fatalError(exception);
        }
    }

    /**
     * @see org.w3c.css.sac.ErrorHandler#warning(org.w3c.css.sac.CSSParseException)
     */
    public void warning(CSSParseException exception) throws CSSException {
        if (consumer != null) {
            consumer.warning(exception);
        }
    }

    /**
     * @see org.trix.cuery.css.CSSProducer#setConsumer(org.trix.cuery.css.CSSConsumer)
     */
    public void setConsumer(CSSConsumer consumer) {
        this.consumer = consumer;
    }

}
