/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.value;

import org.trix.cuery.value.Value;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

public abstract class AbstractValue
implements Value {
    protected float floatValue;
    protected String stringValue;
    protected Value params;
    private AbstractValue previous;
    private AbstractValue next;
    private int length = 1;
    private int position = 0;

    protected AbstractValue(Value previous) {
        this.previous = (AbstractValue)previous;
        if (previous != null) {
            this.previous.next = this;
            this.length = this.previous.length;
            this.position = this.previous.length;
            this.propagate();
        }
    }

    public LexicalUnit getNextLexicalUnit() {
        return this.next;
    }

    public LexicalUnit getPreviousLexicalUnit() {
        return this.previous;
    }

    public int getIntegerValue() {
        return (int)this.floatValue;
    }

    public String getDimensionUnitText() {
        return "";
    }

    public String getFunctionName() {
        return "";
    }

    public LexicalUnit getParameters() {
        return this.params;
    }

    public LexicalUnit getSubValues() {
        return this.params;
    }

    public float getFloatValue(short unitType) throws DOMException {
        if (unitType < 1 || 18 < unitType) {
            throw new DOMException(unitType, "This type is out of range.");
        }
        return 0.0f;
    }

    public Counter getCounterValue() throws DOMException {
        throw new DOMException(15, "This value is not a CSS Counter.");
    }

    public Rect getRectValue() throws DOMException {
        throw new DOMException(15, "This value is not a CSS Rect.");
    }

    public RGBColor getRGBColorValue() throws DOMException {
        throw new DOMException(15, "This value is not a CSS RGBColor.");
    }

    public String getCssText() {
        return this.stringValue;
    }

    public void setCssText(String text) throws DOMException {
    }

    public short getCssValueType() {
        if (this.length == 1) {
            return 1;
        }
        return 2;
    }

    public void setFloatValue(short unitType, float value) throws DOMException {
        if (unitType < 1 || 18 < unitType) {
            throw new DOMException(unitType, "This type is out of range.");
        }
    }

    public void setStringValue(short unitType, String value) throws DOMException {
        if (unitType < 19 || 22 < unitType) {
            throw new DOMException(unitType, "This type is out of range.");
        }
    }

    public int getLength() {
        return this.length;
    }

    public CSSValue item(int index) {
        if (index < 0 || this.length - 1 < index) {
            return null;
        }
        AbstractValue current = this;
        while (index != current.position) {
            if (index > current.position) {
                current = current.next;
                continue;
            }
            if (index >= current.position) continue;
            current = current.previous;
        }
        return current;
    }

    public final String toString() {
        return this.getCssText();
    }

    private void propagate() {
        ++this.length;
        if (this.previous != null) {
            this.previous.propagate();
        }
    }
}

