/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.trix.cuery.dom.stylesheets.StyleSheetImpl;
import org.trix.cuery.dom.stylesheets.StyleSheetListImpl;
import org.trix.cuery.filter.ClassFilter;
import org.trix.cuery.filter.ElementFilter;
import org.trix.cuery.filter.Filter;
import org.trix.cuery.filter.IDFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.stylesheets.StyleSheetList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DOMUtil {
    public static final Set<Element> EMPTY_SET = Collections.unmodifiableSet(new HashSet(0));

    private DOMUtil() {
    }

    public static Set<Element> getElementsByClassName(Node source, String className) {
        return DOMUtil.retrieveElements(source, new ClassFilter(className), true);
    }

    public static Element getElementById(Node source, String id) {
        Set<Element> result = DOMUtil.retrieveElements(source, new IDFilter(id), true);
        if (result.size() == 1) {
            return result.iterator().next();
        }
        return null;
    }

    public static Set<Element> getElementsByTagName(Node source, String tagName) {
        return DOMUtil.retrieveElements(source, new ElementFilter(tagName), true);
    }

    public static Element getPreviousElement(Node source) {
        if (source == null) {
            return null;
        }
        Node previous = source.getPreviousSibling();
        if (previous == null) {
            return null;
        }
        if (previous.getNodeType() == 1) {
            return (Element)previous;
        }
        return DOMUtil.getPreviousElement(previous);
    }

    public static Element getNextElement(Node source) {
        if (source == null) {
            return null;
        }
        Node next = source.getNextSibling();
        if (next == null) {
            return null;
        }
        if (next.getNodeType() == 1) {
            return (Element)next;
        }
        return DOMUtil.getNextElement(next);
    }

    public static StyleSheetList getStylesheets(Document document) {
        NodeList children = document.getChildNodes();
        StyleSheetListImpl list = new StyleSheetListImpl();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 7) {
                ProcessingInstruction pi = (ProcessingInstruction)child;
                list.addStyleSheet(new StyleSheetImpl(pi));
            }
            ++i;
        }
        return list;
    }

    public static int getPosition(Element element) {
        if (element == null) {
            return -1;
        }
        Node parent = element.getParentNode();
        if (parent == null || parent.getNodeType() != 1) {
            return -1;
        }
        int position = 1;
        NodeList nodeList = parent.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node current = nodeList.item(i);
            if (current.getNodeType() == 1) {
                if (current == element) {
                    return position;
                }
                ++position;
            }
            ++i;
        }
        return -1;
    }

    public static int getTypedPosition(Element element) {
        if (element == null) {
            return -1;
        }
        Node parent = element.getParentNode();
        if (parent == null || parent.getNodeType() != 1) {
            return -1;
        }
        int position = 1;
        String ns = element.getNamespaceURI();
        String name = element.getLocalName();
        NodeList nodeList = parent.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                Element current = (Element)node;
                if ((ns == null || ns.equals(current.getNamespaceURI())) && current.getLocalName().equals(name)) {
                    if (current == element) {
                        return position;
                    }
                    ++position;
                }
            }
            ++i;
        }
        return -1;
    }

    public static boolean hasToken(Element target, String name, String token) {
        String[] values;
        if (target == null || name == null || name.length() == 0 || token == null || token.length() == 0) {
            return false;
        }
        String attribute = target.getAttribute(name);
        if (attribute == null || attribute.length() < token.length()) {
            return false;
        }
        String[] stringArray = values = attribute.split(" ");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String value = stringArray[n];
            if (value.equals(token)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static Set<Element> retrieveElements(Node source, Filter filter, boolean descendant) {
        if (source == null) {
            return EMPTY_SET;
        }
        if (source.getNodeType() == 9 || source.getNodeType() == 1) {
            HashSet<Element> container = new HashSet<Element>();
            DOMUtil.retrieveElements(container, source, filter, descendant);
            return container;
        }
        return EMPTY_SET;
    }

    private static void retrieveElements(Set<Element> container, Node source, Filter filter, boolean descendant) {
        if (!source.hasChildNodes()) {
            return;
        }
        NodeList children = source.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                Element element = (Element)child;
                if (descendant) {
                    DOMUtil.retrieveElements(container, element, filter, descendant);
                }
                if (filter.accept(element)) {
                    container.add(element);
                }
            }
            ++i;
        }
    }
}

