/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.trix.cuery.filter.AbstractPseudoFilter;
import org.trix.cuery.filter.AcceptFilter;
import org.trix.cuery.filter.AttributeFilter;
import org.trix.cuery.filter.ChildFilter;
import org.trix.cuery.filter.ClassFilter;
import org.trix.cuery.filter.DescendantFilter;
import org.trix.cuery.filter.DirectAdjacentFilter;
import org.trix.cuery.filter.ElementFilter;
import org.trix.cuery.filter.EmptyFilter;
import org.trix.cuery.filter.Filter;
import org.trix.cuery.filter.FirstChildFilter;
import org.trix.cuery.filter.FirstTypedFilter;
import org.trix.cuery.filter.HyphenTokensFilter;
import org.trix.cuery.filter.IDFilter;
import org.trix.cuery.filter.LastChildFilter;
import org.trix.cuery.filter.LastTypedFilter;
import org.trix.cuery.filter.MultipleFilter;
import org.trix.cuery.filter.OnlyChildFilter;
import org.trix.cuery.filter.OnlyTypedFilter;
import org.trix.cuery.filter.PseudoElementFilter;
import org.trix.cuery.filter.PseudoFilter;
import org.trix.cuery.filter.RootFilter;
import org.trix.cuery.filter.TokensFilter;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SiblingSelector;

public final class CSSUtil {
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String DEFAULT_ENCODING = System.getProperty("file.encoding");
    private static final int ENCODING_BUFFER_SIZE = 100;
    private static final Pattern ENCODING_PATTERN = Pattern.compile("^@charset\\s[\"']([^\\s]+)[\"']");
    private static final Map<String, Filter> PSEUDO = new HashMap<String, Filter>();
    private static final String[] PSEUDO_ELEMENTS = new String[]{"after", "before", "first-letter", "first-line", "selection"};
    private static final String[] PSEUDO_CLASSES = new String[]{"enabled", "disabled", "checked", "indeterminate", "link", "visited", "active", "hover", "focus", "target"};

    static {
        CSSUtil.addFilter(FirstChildFilter.SINGLETON);
        CSSUtil.addFilter(FirstTypedFilter.SINGLETON);
        CSSUtil.addFilter(LastChildFilter.SINGLETON);
        CSSUtil.addFilter(LastTypedFilter.SINGLETON);
        CSSUtil.addFilter(OnlyChildFilter.SINGLETON);
        CSSUtil.addFilter(OnlyTypedFilter.SINGLETON);
        CSSUtil.addFilter(EmptyFilter.SINGLETON);
        CSSUtil.addFilter(RootFilter.SINGLETON);
        Arrays.sort(PSEUDO_ELEMENTS);
        Arrays.sort(PSEUDO_CLASSES);
    }

    private CSSUtil() {
    }

    public static InputSource getSource(String uri) throws IOException {
        if (uri == null || uri.length() == 0) {
            throw new IOException("This input uri is null.");
        }
        if (uri.startsWith("file:")) {
            uri = uri.substring(5);
        }
        return CSSUtil.getSource(new FileInputStream(uri), uri);
    }

    public static InputSource getSource(File file) throws IOException {
        if (file == null) {
            throw new IOException("This input is null file.");
        }
        String uri = file.getPath();
        if (uri.startsWith("file:")) {
            uri = uri.substring(5);
        }
        return CSSUtil.getSource(new FileInputStream(file), uri);
    }

    public static InputSource getSource(InputStream input) throws IOException {
        return CSSUtil.getSource(input, null);
    }

    public static InputSource getSource(InputStream input, String uri) throws IOException {
        InputStreamReader reader;
        if (input == null) {
            throw new IOException("This input is null input stream.");
        }
        PushbackInputStream pushback = null;
        pushback = input instanceof PushbackInputStream ? (PushbackInputStream)input : new PushbackInputStream(input, 100);
        byte[] buffer = new byte[100];
        int length = pushback.read(buffer, 0, buffer.length);
        pushback.unread(buffer, 0, length);
        InputSource source = new InputSource();
        Matcher matcher = ENCODING_PATTERN.matcher(new String(buffer, 0, length, "ASCII"));
        if (matcher.lookingAt()) {
            reader = new InputStreamReader((InputStream)pushback, matcher.group(1));
            source.setEncoding(matcher.group(1));
        } else {
            reader = new InputStreamReader((InputStream)pushback, DEFAULT_ENCODING);
            source.setEncoding(DEFAULT_ENCODING);
        }
        source.setCharacterStream((Reader)new BufferedReader(reader));
        source.setURI(uri);
        return source;
    }

    public static Filter converte(Condition condition) {
        if (condition instanceof Filter) {
            return (Filter)condition;
        }
        switch (condition.getConditionType()) {
            case 0: {
                CombinatorCondition combo = (CombinatorCondition)condition;
                return new MultipleFilter(CSSUtil.converte(combo.getFirstCondition()), CSSUtil.converte(combo.getSecondCondition()));
            }
            case 4: {
                AttributeCondition attr = (AttributeCondition)condition;
                return new AttributeFilter(attr.getLocalName(), attr.getValue());
            }
            case 9: {
                AttributeCondition clazz = (AttributeCondition)condition;
                return new ClassFilter(clazz.getValue());
            }
            case 5: {
                AttributeCondition id = (AttributeCondition)condition;
                return new IDFilter(id.getValue());
            }
            case 8: {
                AttributeCondition hyphen = (AttributeCondition)condition;
                return new HyphenTokensFilter(hyphen.getLocalName(), hyphen.getValue());
            }
            case 7: {
                AttributeCondition one = (AttributeCondition)condition;
                return new TokensFilter(one.getLocalName(), one.getValue());
            }
            case 6: {
                LangCondition lang = (LangCondition)condition;
                return new HyphenTokensFilter("xml:lang", lang.getLang());
            }
            case 10: {
                AttributeCondition pseudo = (AttributeCondition)condition;
                return CSSUtil.createPseudoFilter(pseudo.getValue());
            }
        }
        return AcceptFilter.SINGLETON;
    }

    public static Filter converte(Selector selector) {
        if (selector instanceof Filter) {
            return (Filter)selector;
        }
        switch (selector.getSelectorType()) {
            case 0: {
                ConditionalSelector conditional = (ConditionalSelector)selector;
                return new MultipleFilter(CSSUtil.converte((Selector)conditional.getSimpleSelector()), CSSUtil.converte(conditional.getCondition()));
            }
            case 4: {
                ElementSelector element = (ElementSelector)selector;
                return new ElementFilter(null, element.getNamespaceURI(), element.getLocalName());
            }
            case 11: {
                DescendantSelector child = (DescendantSelector)selector;
                return new ChildFilter(child.getAncestorSelector(), child.getSimpleSelector());
            }
            case 10: {
                DescendantSelector descendant = (DescendantSelector)selector;
                return new DescendantFilter(descendant.getAncestorSelector(), descendant.getSimpleSelector());
            }
            case 12: {
                SiblingSelector sibling = (SiblingSelector)selector;
                return new DirectAdjacentFilter(sibling.getNodeType(), sibling.getSelector(), sibling.getSiblingSelector());
            }
        }
        return AcceptFilter.SINGLETON;
    }

    public static Filter createPseudoFilter(String name) throws CSSException {
        Filter filter = PSEUDO.get(name);
        if (filter != null) {
            return filter;
        }
        if (ArrayUtils.indexOf((Object[])PSEUDO_CLASSES, (Object)name) != -1) {
            return new PseudoFilter(name);
        }
        if (ArrayUtils.indexOf((Object[])PSEUDO_ELEMENTS, (Object)name) != -1) {
            return new PseudoElementFilter(name);
        }
        throw new CSSException("This pseudo class '" + name + "' is not supported.");
    }

    private static void addFilter(AbstractPseudoFilter filter) {
        PSEUDO.put(filter.getValue(), filter);
    }

    public static String getErrorMessage(CSSParseException exception) {
        StringBuilder builder = new StringBuilder("CSS parsing error is occured in '");
        builder.append(exception.getURI());
        builder.append("' at line ");
        builder.append(exception.getLineNumber());
        builder.append(", column ");
        builder.append(exception.getColumnNumber());
        builder.append(".");
        builder.append(SEPARATOR);
        builder.append("Message : ");
        builder.append(exception.getMessage());
        if (exception.getException() != null) {
            builder.append(SEPARATOR);
            builder.append("Caused by : ");
            builder.append(exception.getException().getMessage());
        }
        return builder.toString();
    }
}

