/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.trix.cuery.CSSQuery;
import org.trix.cuery.css.AbstractCSSConsumer;
import org.trix.cuery.css.CSSConsumer;
import org.trix.cuery.css.CSSPipe;
import org.trix.cuery.parser.CueryParser;
import org.trix.cuery.style.CascadableStyle;
import org.trix.cuery.style.SimpleStyle;
import org.trix.cuery.style.Style;
import org.trix.cuery.util.CSSUtil;
import org.trix.cuery.util.DOMUtil;
import org.trix.cuery.util.URIUtil;
import org.trix.cuery.value.Value;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;
import org.xml.sax.SAXException;

public class CSSWeaver {
    private static CueryParser parser = new CueryParser();
    private StyleProcessor processor = new StyleProcessor();
    private boolean aware = false;

    public void addAgentStylesheet(InputSource source) throws IOException {
        this.parseStylesheet(source, this.processor, 1);
    }

    public void addAgentStylesheet(InputSource source, CSSPipe pipe) throws IOException {
        pipe.setConsumer(this.processor);
        this.parseStylesheet(source, pipe, 1);
    }

    public void addAuthorStylesheet(InputSource source) throws IOException {
        this.parseStylesheet(source, this.processor, 3);
    }

    public void addAuthorStylesheet(InputSource source, CSSPipe pipe) throws IOException {
        pipe.setConsumer(this.processor);
        this.parseStylesheet(source, pipe, 3);
    }

    public void addUserStylesheet(InputSource source) throws IOException {
        this.parseStylesheet(source, this.processor, 2);
    }

    public void addUserStylesheet(InputSource source, CSSPipe pipe) throws IOException {
        pipe.setConsumer(this.processor);
        this.parseStylesheet(source, pipe, 2);
    }

    private synchronized void parseStylesheet(InputSource stylesheet, CSSConsumer consumer, int origin) throws IOException {
        this.processor.origin = origin;
        parser.setDocumentHandler(consumer);
        parser.parseStyleSheet(stylesheet);
    }

    public Document apply(String path) throws IOException {
        return this.apply(new File(path));
    }

    public Document apply(File file) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return this.apply(builder.parse(file));
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
    }

    public Document apply(Document document) {
        CSSQuery query = new CSSQuery(document);
        this.processor.weave(query);
        if (this.aware) {
            StyleProcessor inlineProcessor = new StyleProcessor(this.processor);
            StyleSheetList stylesheets = DOMUtil.getStylesheets(document);
            int i = 0;
            while (i < stylesheets.getLength()) {
                StyleSheet stylesheet = stylesheets.item(i);
                if (stylesheet.getType().equals("text/css")) {
                    try {
                        String uri = URIUtil.getNormalizedURI(document.getDocumentURI(), stylesheet.getHref());
                        this.parseStylesheet(CSSUtil.getSource(uri), inlineProcessor, 3);
                    }
                    catch (IOException e) {
                        System.out.println(e);
                    }
                }
                ++i;
            }
            inlineProcessor.weave(query);
        }
        return document;
    }

    public void awareXmlStylesheet(boolean aware) {
        this.aware = aware;
    }

    public static final Style getStyle(Element target) {
        return (Style)target.getUserData(Style.KEY);
    }

    private final class StyleProcessor
    extends AbstractCSSConsumer {
        private List<Object[]> container = new ArrayList<Object[]>();
        private int origin = 3;
        private int position;
        private SimpleStyle style;

        public StyleProcessor() {
            this.position = -1;
        }

        public StyleProcessor(StyleProcessor parent) {
            this.position = parent.position;
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            this.style.setProperty(name, (Value)value, important);
        }

        public void startSelector(SelectorList selectorList) throws CSSException {
            this.style = new SimpleStyle();
            ++this.position;
        }

        public void endSelector(SelectorList selectorList) throws CSSException {
            this.container.add(new Object[]{selectorList, this.style, this.position, this.origin});
        }

        private void weave(CSSQuery query) {
            if (query == null) {
                return;
            }
            for (Object[] objects : this.container) {
                SelectorList list = (SelectorList)objects[0];
                Style style = (Style)objects[1];
                int position = (Integer)objects[2];
                int origin = (Integer)objects[3];
                int i = 0;
                while (i < list.getLength()) {
                    Set<Element> elements = query.select(list.item(i));
                    for (Element element : elements) {
                        CascadableStyle cascadable = (CascadableStyle)element.getUserData(Style.KEY);
                        if (cascadable == null) {
                            cascadable = new CascadableStyle();
                        }
                        cascadable.addStyle(style, origin, CSSUtil.converte(list.item(i)).getSpecificity(), position);
                        element.setUserData(Style.KEY, cascadable, null);
                    }
                    ++i;
                }
            }
        }
    }
}

