package yukihane.inqubus.cookie;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

/**
 * WindowsのFirefox3 cookie ディレクトリを決め打ちして扱います.
 * @author rankingloid (nicorank)
 * @author hazychill (nicorank)
 * @author orz (saccubus)
 * @author yuki
 * @deprecated ユーザプロファイルを切り替える設定を行っている場合にはおそらくうまく動きません.
 */
@Deprecated
class CookieWinFirefox3 extends Cookie {

    /**
     * Firefox3 から user_session を取得。
     * @return ユーザセッション文字列.
     * @throws IOException 取得失敗.
     */
    @Override
    protected String getNicoUserSession() throws IOException {
        final String appData = System.getenv("APPDATA");
        if (StringUtils.isNotEmpty(appData)) {
            File sqlist_filename = new File(appData + "/Mozilla/Firefox/Profiles/cookies.sqlite");
            if (sqlist_filename.isFile()) {
                final String userSession = getUserSession("US-ASCII", sqlist_filename);
                if (StringUtils.isNotEmpty(userSession)) {
                    return userSession;
                }
            }
        }

        return "";
    }
}
