/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package nicobrowser;

/**
 *
 * @author yuki
 */
public class NamePattern {

    private static final String titlePattern = "{title}";
    private static final String idPattern = "{id}";
    private static final String lowPattern = "{low}";
    private final String pattern;
    private final String replaceFrom;
    private final String replaceTo;
    private final String title;

    /**
     * 保存ファイル名の命名規則.
     * @param pattern 命名パターン.
     * @param replaceFrom 禁則文字を指定する.
     * @param replaceTo 禁則文字をこの文字列に置換する.
     * @param title ファイル名に用いるタイトル文字列.
     */
    public NamePattern(String pattern, String replaceFrom, String replaceTo, String title) {
        this.pattern = pattern;
        this.replaceFrom = replaceFrom;
        this.replaceTo = replaceTo;
        this.title = title;
    }

    String createFileName(String id, boolean isNotLow) {
        String res = pattern;
        res = res.replace(titlePattern, title);
        res = res.replace(idPattern, id);
        String low = isNotLow ? "" : "low";
        res = res.replace(lowPattern, low);
        char[] replaceds = new char[replaceFrom.length()];
        replaceFrom.getChars(0, replaceFrom.length(), replaceds, 0);
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < res.length(); i++) {
            char c = res.charAt(i);
            String moji = new String("" + c);
            for (char replaced : replaceds) {
                if (c == replaced) {
                    moji = replaceTo;
                }
            }
            str.append(moji);
        }
        return str.toString();
    }
}
