/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package saccubus.net;

/**
 *
 * @author yuki
 */
public class VideoInfo {

    private final String videoTitle;
    private final String threadId;
    private final String videoUrl;
    private final String msgUrl;
    private final String userId;
    private final int videoLength;
    private final OfficialOption officialOption;

    /**
     *
     * @param videoTitle
     * @param threadId
     * @param videoUrl
     * @param msgUrl
     * @param userId
     * @param videoLength
     * @param officialOption nullも可.
     */
    public VideoInfo(String videoTitle, String threadId, String videoUrl, String msgUrl, String userId, int videoLength,
            OfficialOption officialOption) {
        if (videoTitle == null || threadId == null || videoUrl == null || msgUrl == null || userId == null) {
            throw new IllegalArgumentException("video informationの情報が不正です。");
        }
        this.videoTitle = videoTitle;
        this.threadId = threadId;
        this.videoUrl = videoUrl;
        this.msgUrl = msgUrl;
        this.userId = userId;
        this.videoLength = videoLength;
        this.officialOption = officialOption;
    }

    public String getMsgUrl() {
        return msgUrl;
    }

    public String getThreadId() {
        return threadId;
    }

    public String getUserId() {
        return userId;
    }

    public int getVideoLength() {
        return videoLength;
    }

    public String getVideoTitle() {
        return videoTitle;
    }

    public String getVideoUrl() {
        return videoUrl;
    }

    public OfficialOption getOfficialOption() {
        return officialOption;
    }

    public int getBackCommentFromLength() {
        final int length = getVideoLength();

        if (length < 60) {
            return 100;
        } else if (length < 300) {
            return 250;
        } else if (length < 600) {
            return 500;
        } else {
            return 1000;
        }
    }

    public static class OfficialOption {

        private final String threadKey;
        private final String force184;

        public OfficialOption(String threadKey, String force184) {
//            if (threadKey == null || force184 == null) {
//                throw new IllegalArgumentException("公式動画用キーが不正です");
//            }
            this.threadKey = threadKey;
            this.force184 = force184;
        }

        public String getThreadKey() {
            return threadKey;
        }

        public String getForce184() {
            return force184;
        }
    }
}
