package saccubus;

import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

/**
 *
 * @author yuki
 */
public class NumberFormattedTextField extends JFormattedTextField {

    private static final long serialVersionUID = 1L;

    public NumberFormattedTextField() {
        super(new DecimalFormat("#"));
        this.setHorizontalAlignment(JTextField.RIGHT);
        this.addFocusListener(new FocusAdapter());
    }

    public class FocusAdapter extends java.awt.event.FocusAdapter {

        @Override
        public void focusGained(FocusEvent e) {
            SwingUtilities.invokeLater(new Runnable() {

                @Override
                public void run() {
                    selectAll();
                }
            });
        }
    }
}
