package saccubus.util;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 *
 * @author yuki
 */
public final class WayBackTimeParser {

    private WayBackTimeParser() {
    }

    public static String parse(String time) throws IOException {
        Date date = null;
        String waybacktime = "0";
        try {
            final DateFormat fmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            date = fmt.parse(time);
        } catch (ParseException ex2) {
            date = null;
        }
        if (date == null) {
            try {
                final DateFormat fmt = new SimpleDateFormat("yyyy/MM/dd HH:mm");
                date = fmt.parse(time);
            } catch (ParseException ex3) {
                date = null;
            }
        }
        if (date != null) {
            waybacktime = Long.toString(date.getTime() / 1000);
            System.out.println("ok.(" + date.toString() + "):" + waybacktime);
        } else {
            try {
                long tmp_time = Long.parseLong(time);
                waybacktime = Long.toString(tmp_time);
                date = new Date(tmp_time * 1000);
                System.out.println("ok.(" + date.toString() + "):"
                        + waybacktime);
            } catch (NumberFormatException ex4) {
                System.out.println("ng.");
                System.out.println("Cannot parse wayback time.");
                throw new IOException("Cannot parse wayback time.", ex4);
            }
        }
        return waybacktime;
    }
}
