/* $Id$ */
package saccubus.converter.profile;

import saccubus.converter.filegetter.LoginInfo;

/**
 * Converterに処理させるための設定.
 * @author yuki
 */
public class Profile {

    private final GeneralSetting generalSetting;
    private final LoginInfo loginInfo;
    private final InputFileSetting videoSetting;
    private final InputFileSetting commentSetting;
    private final CommentGetInfo commentGetInfo;
    private final InputFileSetting tcommentSetting;
    private final OutputFileSetting outputFileSetting;
    private final Ffmpeg ffmpeg;

    public Profile(
            GeneralSetting generalSetting,
            LoginInfo loginInfo,
            InputFileSetting videoSetting,
            InputFileSetting commentSetting,
            CommentGetInfo commentGetInfo,
            InputFileSetting tcommentSetting,
            OutputFileSetting outputFileSetting,
            Ffmpeg ffmpeg) {
        this.generalSetting = generalSetting;
        this.loginInfo = loginInfo;
        this.videoSetting = videoSetting;
        this.commentSetting = commentSetting;
        this.commentGetInfo = commentGetInfo;
        this.tcommentSetting = tcommentSetting;
        this.outputFileSetting = outputFileSetting;
        this.ffmpeg = ffmpeg;
    }

    public LoginInfo getLoginInfo() {
        return loginInfo;
    }

    /** @return 何か実行すべき処理があればtrue. */
    public boolean shouldRun() {
        return getOutputFileSetting().isConvert() || needsDownload();
    }

    /** @return 何かダウンロードするものがあればtrue. */
    public boolean needsDownload() {
        return (videoSetting.isDownload() || commentSetting.isDownload() || tcommentSetting.isDownload());
    }

    public InputFileSetting getVideoSetting() {
        return videoSetting;
    }

    public InputFileSetting getCommentSetting() {
        return commentSetting;
    }

    public InputFileSetting getTcommentSetting() {
        return tcommentSetting;
    }

    public OutputFileSetting getOutputFileSetting() {
        return outputFileSetting;
    }

    public CommentGetInfo getCommentGetInfo() {
        return commentGetInfo;
    }

    public boolean needsConvert() {
        return getOutputFileSetting().isConvert();
    }

    public Ffmpeg getFfmpeg() {
        return ffmpeg;
    }

    public GeneralSetting getGeneralSetting() {
        return generalSetting;
    }
}
