/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package saccubus.converter.filegetter;

import java.io.File;
import java.io.IOException;
import saccubus.net.NicoClient;
import saccubus.net.TextProgressListener;
import saccubus.net.VideoInfo;

/**
 *
 * @author yuki
 */
class TcommFileWebGetter extends FileGetter {

    private final NicoClient client;
    private final VideoInfo videoInfo;

    protected final NicoClient getClient() {
        return client;
    }

    protected final VideoInfo getVideoInfo() {
        return videoInfo;
    }

    TcommFileWebGetter(NicoClient client, VideoInfo vi) {
        this.client = client;
        this.videoInfo = vi;
    }

    @Override
    public File get(File file, TextProgressListener listener) throws IOException {
        File res = getClient().getTcomment(videoInfo, file, listener);
        if (res == null) {
            throw new IOException("投稿者コメントファイルのダウンロードに失敗しました");
        }
        return res;
    }
}
