/* $Id$ */

/*
 * ConfigFrame.java
 *
 * Created on 2009/11/30, 16:35:22
 */
package nicobrowser.gui.config;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import nicobrowser.config.Config;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FilenameUtils;

/**
 *
 * @author yuki
 */
public class ConfigFrame extends javax.swing.JFrame {

    private static final long serialVersionUID = 1L;
    private final Config config;

    /** Creates new form ConfigFrame */
    public ConfigFrame() {
        initComponents();
        configFileField.setText(Config.getConfigfile().getAbsolutePath());
        feedFileField.setText(Config.getFeedUrlFile().getAbsolutePath());
        mylistFileField.setText(Config.getMylistConfigFile().getAbsolutePath());
        config = Config.getInstance();

        // ニコニコ動画アカウント
        idField.setText(config.getNicoMail());
        passField.setText(config.getNicoPassword());

        // 保存先
        String dbPath = FilenameUtils.getFullPathNoEndSeparator(config.getDbFile());
        dbPathField.setText(dbPath);
        flvPathField.setText(config.getSrcSaveDir());

        // ファイル名 命名規則
        String filePattern = config.getFileNamePattern();
        namePatternField.setText(filePattern);
        namePatternArea.setCaretPosition(0);
        String replaceFrom = config.getFileNameReplaceFrom();
        replaceFromField.setText(replaceFrom);
        String replaceTo = config.getFileNameReplaceTo();
        replaceToField.setText(replaceTo);

        // 動作
        waitSpinner.setValue(config.getWaitTime());
        retrySpinner.setValue(config.getMaxRetry());
        lowDownloadCheckBox.setSelected(config.needLowFile());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        configFileField = new javax.swing.JTextField();
        feedFileField = new javax.swing.JTextField();
        configFileLabel = new javax.swing.JLabel();
        feedFileLabel = new javax.swing.JLabel();
        mylistFileLabel = new javax.swing.JLabel();
        mylistFileField = new javax.swing.JTextField();
        feedFileEditButton = new javax.swing.JButton();
        mylistFileEditButton = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        idLabel = new javax.swing.JLabel();
        passLabel = new javax.swing.JLabel();
        idField = new javax.swing.JTextField();
        passField = new javax.swing.JPasswordField();
        jPanel4 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        dbPathField = new javax.swing.JTextField();
        flvPathField = new javax.swing.JTextField();
        dbPathButton = new javax.swing.JButton();
        flvPathButton = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        waitSpinner = new javax.swing.JSpinner();
        retrySpinner = new javax.swing.JSpinner();
        lowDownloadCheckBox = new javax.swing.JCheckBox();
        jPanel5 = new javax.swing.JPanel();
        savaButton = new javax.swing.JButton();
        jPanel6 = new javax.swing.JPanel();
        namePatternField = new javax.swing.JTextField();
        namePatternScroll = new javax.swing.JScrollPane();
        namePatternArea = new javax.swing.JTextArea();
        namePatternLabel = new javax.swing.JLabel();
        replaceFromLabel = new javax.swing.JLabel();
        replaceToLabel = new javax.swing.JLabel();
        replaceFromField = new javax.swing.JTextField();
        replaceToField = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("NicoBrowser - コンフィグ設定");
        setResizable(false);

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("情報"));

        configFileField.setEditable(false);

        feedFileField.setEditable(false);

        configFileLabel.setText("コンフィグ");

        feedFileLabel.setText("フィード(RSS)");

        mylistFileLabel.setText("マイリスト");

        mylistFileField.setEditable(false);

        feedFileEditButton.setText("編集...");
        feedFileEditButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                feedFileEditButtonActionPerformed(evt);
            }
        });

        mylistFileEditButton.setText("編集...");
        mylistFileEditButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mylistFileEditButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, mylistFileLabel, 0, 0, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, configFileLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, feedFileLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel1Layout.createSequentialGroup()
                        .add(mylistFileField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 325, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(mylistFileEditButton))
                    .add(jPanel1Layout.createSequentialGroup()
                        .add(feedFileField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 325, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(feedFileEditButton))
                    .add(configFileField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 395, Short.MAX_VALUE)))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(configFileField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(configFileLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(feedFileField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(feedFileLabel)
                    .add(feedFileEditButton))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(mylistFileLabel)
                    .add(mylistFileField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(mylistFileEditButton))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("ニコニコ動画アカウント"));

        idLabel.setText("ID(メールアドレス)");

        passLabel.setText("パスワード");

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(idLabel)
                    .add(passLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(passField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 377, Short.MAX_VALUE)
                    .add(idField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 377, Short.MAX_VALUE)))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(idLabel)
                    .add(idField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(passLabel)
                    .add(passField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
        );

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder("保存先"));

        jLabel3.setText("履歴DB");

        jLabel4.setText("動画ファイル");

        dbPathButton.setText("...");
        dbPathButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dbPathButtonActionPerformed(evt);
            }
        });

        flvPathButton.setText("...");
        flvPathButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                flvPathButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel4Layout = new org.jdesktop.layout.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel4Layout.createSequentialGroup()
                .add(jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel4)
                    .add(jLabel3))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, dbPathField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 356, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, flvPathField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 356, Short.MAX_VALUE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, flvPathButton)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, dbPathButton)))
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel4Layout.createSequentialGroup()
                .add(jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel3)
                    .add(dbPathButton)
                    .add(dbPathField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel4)
                    .add(flvPathButton)
                    .add(flvPathField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
        );

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("動作"));

        jLabel1.setText("ダウンロード間隔(秒)");

        jLabel2.setText("失敗時リトライ回数");

        lowDownloadCheckBox.setText("エコノミー動画をダウンロードする");

        org.jdesktop.layout.GroupLayout jPanel3Layout = new org.jdesktop.layout.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(jPanel3Layout.createSequentialGroup()
                        .add(jLabel1)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(waitSpinner, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 46, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jPanel3Layout.createSequentialGroup()
                        .add(jLabel2)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                        .add(retrySpinner)))
                .add(18, 18, 18)
                .add(lowDownloadCheckBox)
                .addContainerGap(124, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(waitSpinner, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(lowDownloadCheckBox))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(retrySpinner, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
        );

        jPanel5.setBorder(javax.swing.BorderFactory.createTitledBorder(""));

        savaButton.setText("保存");
        savaButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                savaButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel5Layout = new org.jdesktop.layout.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel5Layout.createSequentialGroup()
                .addContainerGap(407, Short.MAX_VALUE)
                .add(savaButton))
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(savaButton)
        );

        jPanel6.setBorder(javax.swing.BorderFactory.createTitledBorder("ファイル名規則"));

        namePatternArea.setColumns(20);
        namePatternArea.setEditable(false);
        namePatternArea.setRows(5);
        namePatternArea.setText("{title}: 動画タイトル\n{id}: ニコニコ動画ID\n{low}: エコノミー動画であれば\"low\"の文字列、通常動画は空文字列\n【具体例】\n[{id}]{title} (さきゅばす互換)\n{id}{low}_{title} (NicoCache互換)");
        namePatternScroll.setViewportView(namePatternArea);

        namePatternLabel.setText("命名規則");

        replaceFromLabel.setText("置換対象文字");

        replaceToLabel.setText("この文字に置換");

        org.jdesktop.layout.GroupLayout jPanel6Layout = new org.jdesktop.layout.GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(
            jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel6Layout.createSequentialGroup()
                .add(jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(namePatternScroll, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 452, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel6Layout.createSequentialGroup()
                        .add(namePatternLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(namePatternField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 399, Short.MAX_VALUE))
                    .add(jPanel6Layout.createSequentialGroup()
                        .add(jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(replaceToLabel)
                            .add(replaceFromLabel))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(replaceFromField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 371, Short.MAX_VALUE)
                            .add(replaceToField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 371, Short.MAX_VALUE))))
                .addContainerGap())
        );
        jPanel6Layout.setVerticalGroup(
            jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel6Layout.createSequentialGroup()
                .add(jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(namePatternField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(namePatternLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(namePatternScroll, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 71, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(replaceFromLabel)
                    .add(replaceFromField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(replaceToLabel)
                    .add(replaceToField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel5, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel4, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel6, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(jPanel3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 100, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel4, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel6, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel5, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void dbPathButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dbPathButtonActionPerformed
        setPathField(dbPathField);
    }//GEN-LAST:event_dbPathButtonActionPerformed

    private void flvPathButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_flvPathButtonActionPerformed
        setPathField(flvPathField);
    }//GEN-LAST:event_flvPathButtonActionPerformed

    private void savaButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_savaButtonActionPerformed
        PropertiesConfiguration p = new PropertiesConfiguration();

        p.setProperty(Config.P_NICOVIDEO_MAIL, idField.getText());
        p.setProperty(Config.P_NICOVIDEO_PASSWORD, String.valueOf(passField.getPassword()));

        p.setProperty(Config.P_PATH_DB, dbPathField.getText());
        p.setProperty(Config.P_PATH_SAVEFILE, flvPathField.getText());
        p.setProperty(Config.P_SAVEFILE_PATTERN, namePatternField.getText());
        p.setProperty(Config.P_SAVEFILE_REPLACE_FROM, replaceFromField.getText());
        p.setProperty(Config.P_SAVEFILE_REPLACE_TO, replaceToField.getText());

        p.setProperty(Config.P_DOWNLOAD_WAIT, waitSpinner.getValue().toString());
        p.setProperty(Config.P_DOWNLOAD_RETRY, retrySpinner.getValue().toString());
        p.setProperty(Config.P_DOWNLOAD_LOW, Boolean.toString(lowDownloadCheckBox.isSelected()));
        try {
            config.updateConfigFile(p);
            JOptionPane.showMessageDialog(this, Config.getConfigfile().getAbsolutePath() + "\nを更新しました");
        } catch (ConfigurationException ex) {
            Logger.getLogger(ConfigFrame.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this, "保存に失敗しました", "エラー", JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_savaButtonActionPerformed

    private void feedFileEditButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_feedFileEditButtonActionPerformed
        editConfigFile(Config.getFeedUrlFile());
    }//GEN-LAST:event_feedFileEditButtonActionPerformed

    private void mylistFileEditButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mylistFileEditButtonActionPerformed
        editConfigFile(Config.getMylistConfigFile());
    }//GEN-LAST:event_mylistFileEditButtonActionPerformed

    private void editConfigFile(File file) {
        Desktop d = Desktop.getDesktop();
        try {
            d.edit(file);
        } catch (IOException ex) {
            Logger.getLogger(ConfigFrame.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this, ex.getMessage(), "エラー", JOptionPane.ERROR_MESSAGE);
        }
    }

    private void setPathField(JTextField field) {
        String current = field.getText();
        JFileChooser fc = new JFileChooser(current);
        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int ret = fc.showDialog(this, "選択");
        if (ret == JFileChooser.APPROVE_OPTION) {
            String selectPath = fc.getSelectedFile().getAbsolutePath();
            field.setText(selectPath);
        }
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        setLookAndFeel();
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new ConfigFrame().setVisible(true);
            }
        });
    }

    public static void setLookAndFeel() {
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        String lafClassName = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(lafClassName);
        } catch (Exception ex) {
        }
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField configFileField;
    private javax.swing.JLabel configFileLabel;
    private javax.swing.JButton dbPathButton;
    private javax.swing.JTextField dbPathField;
    private javax.swing.JButton feedFileEditButton;
    private javax.swing.JTextField feedFileField;
    private javax.swing.JLabel feedFileLabel;
    private javax.swing.JButton flvPathButton;
    private javax.swing.JTextField flvPathField;
    private javax.swing.JTextField idField;
    private javax.swing.JLabel idLabel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JCheckBox lowDownloadCheckBox;
    private javax.swing.JButton mylistFileEditButton;
    private javax.swing.JTextField mylistFileField;
    private javax.swing.JLabel mylistFileLabel;
    private javax.swing.JTextArea namePatternArea;
    private javax.swing.JTextField namePatternField;
    private javax.swing.JLabel namePatternLabel;
    private javax.swing.JScrollPane namePatternScroll;
    private javax.swing.JPasswordField passField;
    private javax.swing.JLabel passLabel;
    private javax.swing.JTextField replaceFromField;
    private javax.swing.JLabel replaceFromLabel;
    private javax.swing.JTextField replaceToField;
    private javax.swing.JLabel replaceToLabel;
    private javax.swing.JSpinner retrySpinner;
    private javax.swing.JButton savaButton;
    private javax.swing.JSpinner waitSpinner;
    // End of variables declaration//GEN-END:variables
}
