package saccubus.properties;

import java.io.File;
import java.util.Properties;
import java.io.IOException;
import java.io.FileOutputStream;
import java.io.FileInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import saccubus.VideoSaveKind;
import saccubus.converter.filegetter.LoginInfo;
import saccubus.converter.profile.CommentGetInfo;
import saccubus.converter.profile.Ffmpeg;
import saccubus.converter.profile.FfmpegOption;
import saccubus.converter.profile.GeneralSetting;
import saccubus.converter.profile.InputFileSetting;
import saccubus.converter.profile.OutputFileSetting;
import saccubus.converter.profile.Profile;
import saccubus.converter.profile.Proxy;
import saccubus.converter.profile.SFile;

/**
 * <p>
 * タイトル: さきゅばす
 * </p>
 *
 * <p>
 * 説明: ニコニコ動画の動画をコメントつきで保存
 * </p>
 *
 * <p>
 * 著作権: Copyright (c) 2007 PSI
 * </p>
 *
 * <p>
 * 会社名:
 * </p>
 *
 * @author 未入力
 * @version 1.0
 */
public class SProperties {

    private static final String PROP_FILE = "./saccubus.xml";
    public static final String[] ShadowKindArray = {
        "00:なし",
        "01:ニコニコ動画風",
        "02:右下",
        "03:囲い込み"
    };
    private final BasicSetting basicSetting;
    private final InputVideoSetting inputVideoSetting;
    private final InputCommentSetting inputCommentSetting;
    private final InputTcommentSetting inputTcommentSetting;
    private final OutputVideoSetting outputVideoSetting;
    private final MovieSetting movieSetting;
    private final ConvertSetting convertSetting;

    public SProperties(
            BasicSetting basicSetting,
            InputVideoSetting inputVideoSetting,
            InputCommentSetting inputCommentSetting,
            InputTcommentSetting tcommentSetting,
            OutputVideoSetting outputVideoSetting,
            MovieSetting movieSetting,
            ConvertSetting convertSetting //            String videoshownum,
            ) {
//        this.saveVideo = savevideo;
//        if (videofile.lastIndexOf(".") < videofile.lastIndexOf("\\")) {
//            videofile += ".flv";
//        }
//        VideoFile = new File(videofile);

//        if (commentfile.lastIndexOf(".") < commentfile.lastIndexOf("\\")) {
//            commentfile += ".xml";
//        }
//        CommentFile = new File(commentfile);

//        if (convvideofile.lastIndexOf(".") < convvideofile.lastIndexOf("\\")) {
//            convvideofile += ".avi";
//        }

        this.basicSetting = basicSetting;
        this.inputVideoSetting = inputVideoSetting;
        this.inputCommentSetting = inputCommentSetting;
        this.inputTcommentSetting = tcommentSetting;
        this.outputVideoSetting = outputVideoSetting;
        this.movieSetting = movieSetting;
        this.convertSetting = convertSetting;
    }

    public Profile toProfile() throws IOException {
        return new ProfileBuilder().build();
    }

    private class ProfileBuilder {

        private Profile build() throws IOException {
            GeneralSetting generalSetting = buildGeneralSetting();
            LoginInfo loginInfo = buildLoginInfo();
            InputFileSetting videoSetting = buildVideoSetting();
            InputFileSetting commentSetting = buildCommentSetting();
            CommentGetInfo commentGetInfo = buildCommentGetInfo();
            InputFileSetting tcommentSetting = buildTcommentSetting();
            OutputFileSetting outputFileSetting = buildOutputFileSetting();
            Ffmpeg ffmpeg = buildFfmpeg();

            return new Profile(generalSetting, loginInfo, videoSetting, commentSetting, commentGetInfo, tcommentSetting,
                    outputFileSetting, ffmpeg);
        }

        private GeneralSetting buildGeneralSetting() {
            final BasicSetting basic = getBasicSetting();
            return new GeneralSetting(basic.getTempDir());
        }

        private LoginInfo buildLoginInfo() {
            final BasicSetting basic = getBasicSetting();
            Proxy proxy = Proxy.NO_PROXY;
            if (basic.isProxyUse()) {
                proxy = new Proxy(basic.getProxyHost(), basic.getProxyPort());
            }
            final LoginInfo loginInfo = new LoginInfo(basic.getUser().getMail(), basic.getUser().getPassword(), proxy);
            return loginInfo;
        }

        private InputFileSetting buildVideoSetting() {
            final InputVideoSetting setting = getInputVideoSetting();
            // Nicobrowserダウンロードファイルの場合は常にファイル指定.
            final boolean isFile = (!setting.isAutoNaming() || setting.getProcessKind() == VideoSaveKind.NICOBROWSER);
            File video;
            if (setting.getProcessKind() == VideoSaveKind.NICOBROWSER) {
                video = setting.getNicoBrowserFile();
            } else {
                if (setting.isAutoNaming()) {
                    video = setting.getFolder();
                } else {
                    video = setting.getFile();
                }
            }
            final SFile videoFile = new SFile(isFile, video);
            // Nicobrowserダウンロードファイルは削除対象にならない.
            boolean delete = setting.isDeleteAfterConvert() && (setting.getProcessKind() != VideoSaveKind.NICOBROWSER);

            return new InputFileSetting(videoFile, (setting.getProcessKind() == VideoSaveKind.SAVE), delete);
        }

        private InputFileSetting buildCommentSetting() {
            return createCommentSetting(getInputCommentSetting());
        }

        private CommentGetInfo buildCommentGetInfo() {
            final InputCommentSetting setting = getInputCommentSetting();
            return new CommentGetInfo(setting.isSelfAdjustNumOfComment(), setting.getNumOfComment());
        }

        private InputFileSetting buildTcommentSetting() {
            return createCommentSetting(getInputTcommentSetting());
        }

        private InputFileSetting createCommentSetting(saccubus.properties.InputFileSetting<Boolean> setting) {
            SFile file = createSFile(setting);

            return new InputFileSetting(file, setting.getProcessKind().booleanValue(), setting.isDeleteAfterConvert());

        }

        private SFile createSFile(ProcessFileSetting<Boolean> setting) {
            File f;
            if (setting.isAutoNaming()) {
                f = setting.getFolder();
            } else {
                f = setting.getFile();
            }
            final SFile file = new SFile(!setting.isAutoNaming(), f);
            return file;
        }

        private OutputFileSetting buildOutputFileSetting() {
            final OutputVideoSetting setting = getOutputVideoSetting();

            SFile file = createSFile(setting);
            return new OutputFileSetting(file, setting.getProcessKind().booleanValue(), !setting.isCutIdName(), setting.
                    isAddComment(), setting.isAddTcomment());
        }

        private Ffmpeg buildFfmpeg() throws IOException {
            final MovieSetting movie = getMovieSetting();
            final ConvertSetting conv = getConvertSetting();

            FfmpegOption fo = movie.getFfmpegOption();
            if (movie.getOptionFile() != null) {
                try {
                    fo = FfmpegOption.load(movie.getOptionFile());
                } catch (IOException ex) {
                    throw new IOException("オプションファイルの書式が誤っています：" + movie.getOptionFile().getName(), ex);
                }
            }

            return new Ffmpeg(
                    movie.getFfmpeg(),
                    movie.getVhook(),
                    fo,
                    conv.isVhookDisabled(),
                    conv.getMaxNumOfComment(),
                    conv.getFont(),
                    conv.getFontIndex(),
                    conv.getShadowIndex(),
                    conv.isShowConverting(),
                    conv.isSelfAdjustFontSize(),
                    conv.isCommentOpaque(),
                    conv.getNgSetting());
        }
    }

    public static void saveSetting(SProperties setting) {
        final Properties prop = new Properties();
        setting.getBasicSetting().save(prop);
        setting.getInputVideoSetting().save(prop);
        setting.getInputCommentSetting().save(prop);
        setting.getInputTcommentSetting().save(prop);
        setting.getOutputVideoSetting().save(prop);
        setting.getMovieSetting().save(prop);
        setting.getConvertSetting().save(prop);
        try {
            prop.storeToXML(new FileOutputStream(PROP_FILE), "settings");
        } catch (IOException ex) {
            Logger.getLogger(SProperties.class.getName()).log(Level.SEVERE, "コンフィグファイルの保存に失敗", ex);
        }
    }

    public static SProperties loadSetting(String user, String password) {
        Properties prop = new Properties();
        try {
            prop.loadFromXML(new FileInputStream(PROP_FILE));
        } catch (IOException ex) {
            Logger.getLogger(SProperties.class.getName()).log(Level.INFO, "コンフィグファイルが存在しないため自動生成します", ex);
        }

        return new SProperties(
                BasicSetting.load(prop, user, password),
                InputVideoSetting.load(prop),
                InputCommentSetting.load(prop),
                InputTcommentSetting.load(prop),
                OutputVideoSetting.load(prop),
                MovieSetting.load(prop),
                ConvertSetting.load(prop));
    }

    public BasicSetting getBasicSetting() {
        return basicSetting;
    }

    public InputVideoSetting getInputVideoSetting() {
        return inputVideoSetting;
    }

    public InputCommentSetting getInputCommentSetting() {
        return inputCommentSetting;
    }

    public InputTcommentSetting getInputTcommentSetting() {
        return inputTcommentSetting;
    }

    public OutputVideoSetting getOutputVideoSetting() {
        return outputVideoSetting;
    }

    public MovieSetting getMovieSetting() {
        return movieSetting;
    }

    public ConvertSetting getConvertSetting() {
        return convertSetting;
    }
}
