package saccubus.net;

import java.io.File;
import java.io.IOException;

/**
 * いんきゅばすがニコニコ動画にアクセスするためのクラスが実装すべきインタフェース.
 * ログイン処理はコンストラクタ内で実行しておき、各メソッドは同一セッションで実行される必要があります.
 * @author yuki
 */
public interface NicoClient {

    /** @return ログインが正常に完了していればtrue. */
    boolean isLoggedIn();

    VideoInfo getVideoInfo(String videoId) throws IOException;

    /**
     * 過去ログ取得のためのキーを取得する.
     * @param vi {@link #getVideoInfo(java.lang.String) }で取得したビデオ情報.
     */
    String getWayBackKey(VideoInfo vi) throws IOException;

    File getVideo(VideoInfo videoInfo, File file, TextProgressListener listener);

    File getComment(VideoInfo videoInfo, CommentInfo commentInfo, File file, TextProgressListener listener, int com);

    File getTcomment(VideoInfo videoInfo, File file, TextProgressListener listener);
}
