/* $Id$ */
package saccubus;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

/**
 *
 * @author yuki
 */
class VideoSaveInfoPanel extends javax.swing.JPanel {
    private static final long serialVersionUID = 1L;

    /** Creates new form VideoSaveInfoPanel */
    VideoSaveInfoPanel() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        videoSavingGroup = new javax.swing.ButtonGroup();
        videoNamingGroup = new javax.swing.ButtonGroup();
        videoNoSaveButton = new javax.swing.JRadioButton();
        videoSaveButton = new javax.swing.JRadioButton();
        basicSetting = new javax.swing.JPanel();
        delVideoCheckBox = new javax.swing.JCheckBox();
        saveFolderRadioButton = new javax.swing.JRadioButton();
        videoSavedFolderField = new javax.swing.JTextField();
        showSavingVideoFolderDialogButton = new javax.swing.JButton();
        saveFileRadioButton = new javax.swing.JRadioButton();
        videoSavedFileField = new javax.swing.JTextField();
        showSavingVideoFileDialogButton = new javax.swing.JButton();
        videoUseNiBrButton = new javax.swing.JRadioButton();
        nibrExtendSetting = new javax.swing.JPanel();
        nibrFileField = new javax.swing.JTextField();
        nibrFileChooserButton = new javax.swing.JButton();

        setBorder(javax.swing.BorderFactory.createTitledBorder("動画保存設定"));

        videoSavingGroup.add(videoNoSaveButton);
        videoNoSaveButton.setText("動画をダウンロードしない");
        videoNoSaveButton.setName("videoNoSaveButton"); // NOI18N

        videoSavingGroup.add(videoSaveButton);
        videoSaveButton.setText("動画をダウンロードする");
        videoSaveButton.setName("videoSaveButton"); // NOI18N

        delVideoCheckBox.setText("変換後に動画ファイルを削除する");
        delVideoCheckBox.setName("delVideoCheckBox"); // NOI18N

        videoNamingGroup.add(saveFolderRadioButton);
        saveFolderRadioButton.setText("保存するフォルダを指定し、ファイル名は自動で決定する");
        saveFolderRadioButton.setName("saveFolderRadioButton"); // NOI18N

        videoSavedFolderField.setName("videoSavedFolderField"); // NOI18N

        showSavingVideoFolderDialogButton.setText("参照...");
        showSavingVideoFolderDialogButton.setName("showSavingVideoFolderDialogButton"); // NOI18N

        videoNamingGroup.add(saveFileRadioButton);
        saveFileRadioButton.setText("保存するファイル名を指定する");
        saveFileRadioButton.setName("saveFileRadioButton"); // NOI18N

        videoSavedFileField.setName("videoSavedFileField"); // NOI18N

        showSavingVideoFileDialogButton.setText("参照...");
        showSavingVideoFileDialogButton.setName("showSavingVideoFileDialogButton"); // NOI18N

        javax.swing.GroupLayout basicSettingLayout = new javax.swing.GroupLayout(basicSetting);
        basicSetting.setLayout(basicSettingLayout);
        basicSettingLayout.setHorizontalGroup(
            basicSettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(basicSettingLayout.createSequentialGroup()
                .addGroup(basicSettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(delVideoCheckBox)
                    .addComponent(saveFolderRadioButton)
                    .addComponent(saveFileRadioButton)
                    .addGroup(basicSettingLayout.createSequentialGroup()
                        .addGap(21, 21, 21)
                        .addComponent(videoSavedFileField, javax.swing.GroupLayout.DEFAULT_SIZE, 205, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(showSavingVideoFileDialogButton))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, basicSettingLayout.createSequentialGroup()
                        .addGap(21, 21, 21)
                        .addComponent(videoSavedFolderField, javax.swing.GroupLayout.DEFAULT_SIZE, 205, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(showSavingVideoFolderDialogButton)))
                .addContainerGap())
        );
        basicSettingLayout.setVerticalGroup(
            basicSettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(basicSettingLayout.createSequentialGroup()
                .addComponent(delVideoCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(saveFolderRadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(basicSettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(videoSavedFolderField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(showSavingVideoFolderDialogButton))
                .addGap(8, 8, 8)
                .addComponent(saveFileRadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(basicSettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(videoSavedFileField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(showSavingVideoFileDialogButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        videoSavingGroup.add(videoUseNiBrButton);
        videoUseNiBrButton.setText("NicoBrowserダウンロードファイルを用いる");
        videoUseNiBrButton.setName("videoUseNiBrButton"); // NOI18N

        nibrFileField.setName("nibrFileField"); // NOI18N

        nibrFileChooserButton.setText("参照...");

        javax.swing.GroupLayout nibrExtendSettingLayout = new javax.swing.GroupLayout(nibrExtendSetting);
        nibrExtendSetting.setLayout(nibrExtendSettingLayout);
        nibrExtendSettingLayout.setHorizontalGroup(
            nibrExtendSettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, nibrExtendSettingLayout.createSequentialGroup()
                .addComponent(nibrFileField, javax.swing.GroupLayout.DEFAULT_SIZE, 226, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(nibrFileChooserButton)
                .addContainerGap())
        );
        nibrExtendSettingLayout.setVerticalGroup(
            nibrExtendSettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(nibrExtendSettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                .addComponent(nibrFileField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addComponent(nibrFileChooserButton))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(videoNoSaveButton)
                    .addComponent(videoSaveButton))
                .addContainerGap())
            .addGroup(layout.createSequentialGroup()
                .addComponent(videoUseNiBrButton)
                .addContainerGap())
            .addGroup(layout.createSequentialGroup()
                .addGap(21, 21, 21)
                .addComponent(basicSetting, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
            .addGroup(layout.createSequentialGroup()
                .addGap(21, 21, 21)
                .addComponent(nibrExtendSetting, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(videoNoSaveButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(videoSaveButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(basicSetting, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(videoUseNiBrButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(nibrExtendSetting, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel basicSetting;
    private javax.swing.JCheckBox delVideoCheckBox;
    private javax.swing.JPanel nibrExtendSetting;
    private javax.swing.JButton nibrFileChooserButton;
    private javax.swing.JTextField nibrFileField;
    private javax.swing.JRadioButton saveFileRadioButton;
    private javax.swing.JRadioButton saveFolderRadioButton;
    private javax.swing.JButton showSavingVideoFileDialogButton;
    private javax.swing.JButton showSavingVideoFolderDialogButton;
    private javax.swing.ButtonGroup videoNamingGroup;
    private javax.swing.JRadioButton videoNoSaveButton;
    private javax.swing.JRadioButton videoSaveButton;
    private javax.swing.JTextField videoSavedFileField;
    private javax.swing.JTextField videoSavedFolderField;
    private javax.swing.ButtonGroup videoSavingGroup;
    private javax.swing.JRadioButton videoUseNiBrButton;
    // End of variables declaration//GEN-END:variables

    /** @return 「動画をダウンロードしない」ラジオボタン. */
    JRadioButton getVideoNoSaveButton() {
        return videoNoSaveButton;
    }

    /** @return 「動画をダウンロードする」ラジオボタン. */
    JRadioButton getVideoSaveButton() {
        return videoSaveButton;
    }

    /** @return 「NicoBrowserダウンロードファイルを用いる」ラジオボタン. */
    JRadioButton getVideoUseNiBrButton() {
        return videoUseNiBrButton;
    }

    /** @return 「変換後に動画ファイルを削除する」チェックボックス. */
    JCheckBox getDelVideoCheckBox() {
        return delVideoCheckBox;
    }

    /** @return 「保存するフォルダを指定し、ファイル名は自動で決定する」ラジオボタン. */
    JRadioButton getSaveFolderRadioButton() {
        return saveFolderRadioButton;
    }

    /** @return 「保存するファイル名を指定する」ラジオボタン. */
    JRadioButton getSaveFileRadioButton() {
        return saveFileRadioButton;
    }

    /** @return 「保存するフォルダを指定し、ファイル名は自動で決定する」テキストフィールド. */
    JTextField getVideoSavedFolderField() {
        return videoSavedFolderField;
    }

    /** @return 「保存するフォルダを指定し、ファイル名は自動で決定する」ファイルチューザ起動ボタン. */
    JButton getShowSavingVideoFolderDialogButton() {
        return showSavingVideoFolderDialogButton;
    }

    /** @return 「保存するファイル名を指定する」テキストフィールド. */
    JTextField getVideoSavedFileField() {
        return videoSavedFileField;
    }

    /** @return 「保存するファイル名を指定する」ファイルチューザ起動ボタン. */
    JButton getShowSavingVideoFileDialogButton() {
        return showSavingVideoFileDialogButton;
    }

    /** @return 「NicoBrowserダウンロードファイルを用いる」テキストフィールド. */
    JTextField getNibrFileField() {
        return nibrFileField;
    }

    /** @return 「NicoBrowserダウンロードファイルを用いる」ファイルチューザ起動ボタン. */
    JButton getNibrFileChooserButton() {
        return nibrFileChooserButton;
    }

    public static void main(String[] args) {
        setLookAndFeel();
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                frame.setContentPane(new VideoSaveInfoPanel());
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    private static void setLookAndFeel() {
        String lafClassName = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(lafClassName);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
