package jp.crestmuse.cmx.amusaj.commands;
import jp.crestmuse.cmx.commands.*;
import jp.crestmuse.cmx.amusaj.sp.WindowSlider;
import jp.crestmuse.cmx.amusaj.sp.SPExecutor;
//import jp.crestmuse.cmx.amusaj.sp.jAudioFeatureExtractor;
import jp.crestmuse.cmx.amusaj.sp.FeatureExtractionModule;
import jp.crestmuse.cmx.amusaj.sp.ProducerConsumerCompatible;
//import jp.crestmuse.cmx.amusaj.sp.*;
import jp.crestmuse.cmx.amusaj.commands.*;
import jp.crestmuse.cmx.amusaj.filewrappers.*;
import java.io.*;
import java.util.*;
import javax.xml.transform.*;
import javax.xml.parsers.*;
import org.xml.sax.*;
import jAudioFeatureExtractor.AudioFeatures.*;
import jAudioFeatureExtractor.DataModel;

public class jAudioFeatureExtractor extends AbstractWAVAnalyzer {
  
  private DataModel model;
  private String featureXML;

  jp.crestmuse.cmx.amusaj.sp.FeatureExtractor fe;
  ProducerConsumerCompatible femodule;

  protected boolean setOptionsLocal(String option, String value) {
    if (super.setOptionsLocal(option, value)) {
      return true;
    } else if (option.equals("-featurexml")) {
      featureXML = value;
      return true;
    } else {
      return false;
    }
  }
  
  protected void preproc() throws IOException, ParserConfigurationException, 
    TransformerException, SAXException {
    super.preproc();
    model = new DataModel(featureXML, null);
  }

  protected ProducerConsumerCompatible[] getUsedModules() {
    int winsize = getParamInt("fft", "WINDOW_SIZE");
    fe = new jp.crestmuse.cmx.amusaj.sp.jAudioFeatureExtractor
      (winsize, getWindowSlider().getTargetWaveform().sampleRate(), 
       model.features, model.defaults);
    femodule = new FeatureExtractionModule(fe);
    return new ProducerConsumerCompatible[] { femodule };
  }

  protected ModuleConnection[] getModuleConnections() {
    return new ModuleConnection[] {
      new ModuleConnection(getWindowSlider(), 0, femodule, 0)
    };
  }

  protected String getAmusaXMLFormat() {
    return "array";
  }

  protected OutputData[] getOutputData() {
    int nFeats = femodule.getOutputClasses().length;
    OutputData[] outdata = new OutputData[nFeats];
    for (int i = 0; i < outdata.length; i++)
      outdata[i] = new OutputData(femodule, i);
    return outdata;
  }

/*
  protected AmusaDataSetCompatible analyzeWaveform(AudioDataCompatible wav, 
                                 WindowSlider winslider, 
                                 SPExecutor exec)
    throws IOException,
    ParserConfigurationException,SAXException,TransformerException {
    jAudioFeatureExtractor fe ;
    try {
      exec.addSPModule(winslider);
      fe = new jAudioFeatureExtractor(winsize(), wav.sampleRate(), 
                                      model.features, model.defaults);
//                                     FEATURES, FEATURES_TO_SAVE);
    } catch (Exception e) {
      e.printStackTrace();
      throw new IllegalStateException();
    }
      FeatureExtractionModule femodule = new FeatureExtractionModule(fe);
      exec.addSPModule(femodule);
      exec.connect(winslider, 0, femodule, 0);
      exec.start();
      AmusaDataSet dataset = new AmusaDataSet("array");
      int n = femodule.getOutputClasses().length;
      String[] feattypes = femodule.getFeatureTypes();
      for (int i = 0; i < n; i++) {
        if ("MFCC".equals(feattypes[i]))
          dataset.add(exec.getResult(femodule).get(i));
      }

      return dataset;
  }
*/

  public static void main(String[] args) {
    jAudioFeatureExtractor featext = new jAudioFeatureExtractor();
    try {
      featext.start(args);
    } catch (Exception e) {
      featext.showErrorMessage(e);
      System.exit(1);
    }
  }


}