/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.mp3;

import codecLib.mp3.Decoder;
import codecLib.mp3.FrameInfo;
import codecLib.mp3.MPADException;
import com.sun.media.codec.audio.mp3.JS_MP3ConversionProvider;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;

public class JS_MP3FileReader
extends AudioFileReader {
    public static boolean DEBUG = false;
    private static final int MIN_HEADER_SIZE = 1024;
    private static final int MAX_HEADER_SIZE = 16384;
    static final AudioFileFormat.Type MPEG = JS_MP3FileReader.getType("MPEG", "mpeg");
    static final AudioFileFormat.Type MP3 = JS_MP3FileReader.getType("MP3", "mp3");
    private static final String TFILETYPES_CLASS = "org.tritonus.share.sampled.AudioFileTypes";
    private static final String TGETFILETYPE_METHOD = "getType";
    private static Class tAudioFileTypes;
    private static Method tGetType;
    private static boolean triedTritonus;
    private static final int WAVE_FORMAT_MPEG = 80;
    private static final int WAVE_FORMAT_MPEGLAYER3 = 85;
    static /* synthetic */ Class class$java$lang$String;

    public AudioFileFormat getAudioFileFormat(InputStream stream) throws UnsupportedAudioFileException, IOException {
        return this.getAudioFileFormat(stream, true, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        AFF fileFormat = null;
        InputStream urlStream = url.openStream();
        try {
            fileFormat = this.getAudioFileFormat(urlStream, false, 16384);
        }
        finally {
            urlStream.close();
        }
        return fileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        AFF fileFormat = null;
        FileInputStream fis = new FileInputStream(file);
        try {
            fileFormat = this.getAudioFileFormat(fis, false, 16384);
        }
        finally {
            fis.close();
        }
        return fileFormat;
    }

    public AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        return this.getAudioInputStream(stream, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream urlStream = url.openStream();
        AudioInputStream result = null;
        try {
            BufferedInputStream bis = new BufferedInputStream(urlStream, 16384);
            result = this.getAudioInputStream(bis, 16384);
        }
        finally {
            if (result == null) {
                urlStream.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fis = new FileInputStream(file);
        AudioInputStream result = null;
        try {
            BufferedInputStream bis = new BufferedInputStream(fis, 16384);
            result = this.getAudioInputStream(bis, 16384);
        }
        finally {
            if (result == null) {
                fis.close();
            }
        }
        return result;
    }

    private AudioInputStream getAudioInputStream(InputStream stream, int headerSize) throws UnsupportedAudioFileException, IOException {
        AFF fileFormat = this.getAudioFileFormat(stream, true, headerSize);
        AudioFormat format = fileFormat.getFormat();
        return new AudioInputStream(stream, format, fileFormat.getFrameLength());
    }

    private AFF getAudioFileFormat(InputStream stream, boolean doReset, int headerSize) throws UnsupportedAudioFileException, IOException {
        FrameInfo info;
        AudioFileFormat.Type fileType;
        int dataOffset;
        boolean isMP3;
        block23: {
            if (doReset) {
                stream.mark(headerSize);
            }
            isMP3 = true;
            boolean hasID3 = false;
            boolean isWAVE = false;
            dataOffset = 0;
            fileType = null;
            info = new FrameInfo();
            Decoder decoder = new Decoder();
            byte[] data = new byte[headerSize - 1];
            int read = stream.read(data, 0, data.length);
            int maxSyncSearch = 1000;
            int magic = JS_MP3FileReader.readLE32(data, 0);
            switch (magic) {
                case 1297239878: {
                    if (DEBUG) {
                        System.out.println("JS_MP3FileReader: Detected AIFF file");
                    }
                    isMP3 = false;
                    break;
                }
                case 1179011410: {
                    if (DEBUG) {
                        System.out.println("JS_MP3FileReader: Detected RIFF file");
                    }
                    isWAVE = true;
                    dataOffset = JS_MP3FileReader.isWAVE_MP3(data, read);
                    isMP3 = dataOffset >= 0;
                    maxSyncSearch = 100;
                    fileType = AudioFileFormat.Type.WAVE;
                    break;
                }
                case 1684960046: {
                    if (DEBUG) {
                        System.out.println("JS_MP3FileReader: Detected AU file");
                    }
                    isMP3 = false;
                }
            }
            if ((magic & 0xFFFFFF) == 0x334449) {
                if (DEBUG) {
                    System.out.println("JS_MP3FileReader: Detected ID3v2 header");
                }
                hasID3 = true;
                maxSyncSearch = read;
            }
            if (isMP3) {
                try {
                    decoder.getNextFrameInfo(info, data, dataOffset, maxSyncSearch);
                    if (!isWAVE && info.getHeaderOffset() > 0) {
                        int maxLength;
                        int nextOffset = dataOffset + info.getHeaderOffset() + info.getFrameLength();
                        int n2 = maxLength = nextOffset + 100 > read ? read - nextOffset : 100;
                        if (maxLength > 0) {
                            FrameInfo nextInfo = new FrameInfo();
                            if (DEBUG) {
                                System.out.println("JS_MP3FileReader: trying to find consecutive frame from offset " + nextOffset + " on. maxLength=" + maxLength);
                            }
                            decoder.getNextFrameInfo(nextInfo, data, nextOffset, maxLength);
                            if (nextInfo.getHeaderOffset() != 0) {
                                isMP3 = false;
                                if (DEBUG) {
                                    System.out.println("JS_MP3FileReader: unable to find next consecutive frame. Probably not an mp3 file.");
                                }
                            }
                        }
                    }
                }
                catch (MPADException e2) {
                    isMP3 = false;
                    if (!DEBUG) break block23;
                    System.out.println("JS_MP3FileReader: getNextFrameInfo threw Exception. state=" + e2.getState());
                }
            }
        }
        if (!isMP3) {
            if (doReset) {
                stream.reset();
            }
            throw new UnsupportedAudioFileException("not an MP3 file");
        }
        AFF fileFormat = new AFF(fileType, info);
        if (doReset) {
            stream.reset();
            if (info.getHeaderOffset() + dataOffset > 0) {
                stream.skip(info.getHeaderOffset() + dataOffset);
            }
        }
        return fileFormat;
    }

    private static AudioFileFormat.Type getFileTypeByInfo(FrameInfo info) {
        AudioFileFormat.Type type = MPEG;
        if (info.getMpegId() == 1 && info.getLayerId() == 3) {
            type = MP3;
        }
        return type;
    }

    private static AudioFormat.Encoding getEncByInfo(FrameInfo info) {
        if (info.getMpegId() == 1) {
            switch (info.getLayerId()) {
                case 1: {
                    return JS_MP3ConversionProvider.MPEG1L1;
                }
                case 2: {
                    return JS_MP3ConversionProvider.MPEG1L2;
                }
                case 3: {
                    return JS_MP3ConversionProvider.MPEG1L3;
                }
            }
        } else if (info.getMpegId() == 2) {
            switch (info.getLayerId()) {
                case 1: {
                    return JS_MP3ConversionProvider.MPEG2L1;
                }
                case 2: {
                    return JS_MP3ConversionProvider.MPEG2L2;
                }
                case 3: {
                    return JS_MP3ConversionProvider.MPEG2L3;
                }
            }
        }
        throw new IllegalArgumentException("invalid frame: MPEG " + info.getMpegId() + ", layer " + info.getMpegId());
    }

    private static AudioFileFormat.Type getType(String name, String ext) {
        AudioFileFormat.Type ret = null;
        if (!triedTritonus || tGetType != null) {
            try {
                boolean firstTime;
                boolean bl = firstTime = !triedTritonus;
                if (!triedTritonus) {
                    triedTritonus = true;
                    tAudioFileTypes = Class.forName(TFILETYPES_CLASS);
                    tGetType = tAudioFileTypes.getMethod(TGETFILETYPE_METHOD, class$java$lang$String == null ? (class$java$lang$String = JS_MP3FileReader.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = JS_MP3FileReader.class$("java.lang.String")) : class$java$lang$String);
                }
                Object[] args = new Object[]{name, ext};
                ret = (AudioFileFormat.Type)tGetType.invoke(null, args);
                if (DEBUG && firstTime) {
                    System.out.println("JS_MP3FileReader: Using Tritonus' AudioFileTypes class");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ret == null) {
            ret = new AFFT(name, ext);
        }
        return ret;
    }

    private static int isWAVE_MP3(byte[] data, int len) {
        if (len < 40) {
            return -1;
        }
        int offset = 8;
        int waveMagic = JS_MP3FileReader.readBE32(data, offset);
        offset += 4;
        if (waveMagic != 1463899717) {
            if (DEBUG) {
                System.out.println("JS_MP3FileReader: RIFF, but not WAVE");
            }
            return -1;
        }
        boolean found = false;
        int chunklen = 0;
        while (offset + 8 < len) {
            int fmt = JS_MP3FileReader.readBE32(data, offset);
            chunklen = JS_MP3FileReader.readLE32(data, offset += 4);
            offset += 4;
            if (chunklen % 2 > 0) {
                ++chunklen;
            }
            if (fmt == 1718449184) {
                found = true;
                break;
            }
            offset += chunklen;
        }
        if (!found) {
            if (DEBUG) {
                System.out.println("JS_MP3FileReader: FMF_ chunk not found --> corrupt wave file");
            }
            return -1;
        }
        int chunkStartOffset = offset;
        int wav_type = JS_MP3FileReader.readLE16(data, offset);
        offset += 2;
        if (wav_type != 80 && wav_type != 85) {
            if (DEBUG) {
                System.out.println("JS_MP3FileReader: WAVE, but not MP3 encoding");
            }
            return -1;
        }
        offset += chunklen - (offset - chunkStartOffset);
        found = false;
        while (offset + 8 < len) {
            int datahdr = JS_MP3FileReader.readBE32(data, offset);
            chunklen = JS_MP3FileReader.readLE32(data, offset += 4);
            offset += 4;
            if (chunklen % 2 > 0) {
                ++chunklen;
            }
            if (datahdr == 1684108385) {
                found = true;
                break;
            }
            offset += chunklen;
        }
        if (!found) {
            if (DEBUG) {
                System.out.println("JS_MP3FileReader: data chunk not found in WAVE file.");
            }
            return -1;
        }
        if (DEBUG) {
            System.out.println("JS_MP3FileReader: Correctly parsed WAVE file. MP3 data starts at offset " + offset);
        }
        return offset;
    }

    private static int readLE32(byte[] data, int offset) {
        return data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8 | (data[offset + 2] & 0xFF) << 16 | (data[offset + 3] & 0xFF) << 24;
    }

    private static int readBE32(byte[] data, int offset) {
        return data[offset + 3] & 0xFF | (data[offset + 2] & 0xFF) << 8 | (data[offset + 1] & 0xFF) << 16 | (data[offset] & 0xFF) << 24;
    }

    private static int readLE16(byte[] data, int offset) {
        return data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (DEBUG) {
            System.out.println("JS_MP3FileReader: DEBUG enabled");
        }
        tAudioFileTypes = null;
        tGetType = null;
        triedTritonus = false;
    }

    private static class AFF
    extends AudioFileFormat {
        private FrameInfo frameInfo;

        public AFF(AudioFileFormat.Type afft, FrameInfo info) {
            super(afft != null ? afft : JS_MP3FileReader.getFileTypeByInfo(info), new AudioFormat(JS_MP3FileReader.getEncByInfo(info), info.getSamplingRate(), -1, info.getNumberOfChannels(), -1, -1.0f, false), -1);
            this.frameInfo = info;
        }
    }

    private static class AFFT
    extends AudioFileFormat.Type {
        public AFFT(String name, String ext) {
            super(name, ext);
        }
    }
}

