/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.jAudioTools;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.Aggregators.AggregatorContainer;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.Cancel;
import jAudioFeatureExtractor.ExplicitCancel;
import jAudioFeatureExtractor.GeneralTools.Statistics;
import jAudioFeatureExtractor.GeneralTools.StringMethods;
import jAudioFeatureExtractor.Updater;
import jAudioFeatureExtractor.jAudioTools.AudioSamples;
import java.io.DataOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.LinkedList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class FeatureProcessor {
    private int window_size;
    private int window_overlap_offset;
    private double sampling_rate;
    private boolean normalise;
    protected FeatureExtractor[] feature_extractors;
    private int[][] feature_extractor_dependencies;
    private int[] max_feature_offsets;
    private boolean[] features_to_save;
    private boolean save_features_for_each_window;
    private boolean save_overall_recording_features;
    private DataOutputStream values_writer;
    private DataOutputStream definitions_writer;
    private boolean definitions_written;
    private int outputType;
    private boolean isARFFOverallHeaderWritten = false;
    private Updater updater;
    private Cancel cancel;
    private AggregatorContainer aggregator;

    public FeatureProcessor(int n, double d, double d2, boolean bl, FeatureExtractor[] featureExtractorArray, boolean[] blArray, boolean bl2, boolean bl3, OutputStream outputStream, OutputStream outputStream2, int n2, Cancel cancel, AggregatorContainer aggregatorContainer) throws Exception {
        this.cancel = cancel;
        this.aggregator = aggregatorContainer;
        if (!bl2 && !bl3) {
            throw new Exception("You must save at least one of the windows-based\nfeatures and the overall file-based features.");
        }
        if (d < 0.0 || d >= 1.0) {
            throw new Exception("Window overlap fraction is " + d + ".\n" + "This value must be 0.0 or above and less than 1.0.");
        }
        if (n < 3) {
            throw new Exception("Window size is " + n + ".\n" + "This value must be above 2.");
        }
        boolean bl4 = false;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            bl4 = true;
        }
        if (!bl4) {
            throw new Exception("No features have been set to be saved.");
        }
        if (n2 != 0 && n2 != 1) {
            throw new Exception("INTERNAL ERROR - only ARFF and ACE output files are supported");
        }
        this.outputType = n2;
        this.values_writer = new DataOutputStream(outputStream);
        this.definitions_writer = new DataOutputStream(outputStream2);
        this.definitions_written = false;
        this.window_size = n;
        this.sampling_rate = d2;
        this.normalise = bl;
        this.save_features_for_each_window = bl2;
        this.save_overall_recording_features = bl3;
        this.window_overlap_offset = (int)(d * (double)n);
        this.findAndOrderFeaturesToExtract(featureExtractorArray, blArray);
        if (n2 == 0) {
            this.writeValuesXMLHeader();
        } else if (n2 == 1) {
            this.writeValuesARFFHeader();
        }
    }

    protected FeatureProcessor(int n, double d, FeatureExtractor[] featureExtractorArray, boolean[] blArray) {
        this.window_size = n;
        this.sampling_rate = d;
        this.window_overlap_offset = 0;
        this.normalise = true;
        this.findAndOrderFeaturesToExtract(featureExtractorArray, blArray);
    }

    public void extractFeatures(File file, Updater updater) throws Exception {
        this.updater = updater;
        double[] dArray = this.preProcessRecording(file);
        if (this.cancel.isCancel()) {
            throw new ExplicitCancel("Killed after loading data");
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (int i = 0; i < dArray.length; i += this.window_size - this.window_overlap_offset) {
            linkedList.add(new Integer(i));
        }
        Integer[] integerArray = linkedList.toArray(new Integer[1]);
        int[] nArray = new int[integerArray.length];
        if (updater != null) {
            updater.setFileLength(nArray.length);
        }
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        double[][][] dArray2 = this.getFeatures(dArray, nArray);
        if (this.save_overall_recording_features) {
            this.aggregator.add(this.feature_extractors, this.features_to_save);
            this.aggregator.aggregate(dArray2);
        }
        if (this.outputType == 0) {
            this.saveACEFeatureVectorsForARecording(dArray2, nArray, file.getPath(), this.aggregator);
        } else if (this.outputType == 1) {
            this.saveARFFFeatureVectorsForARecording(dArray2, nArray, file.getPath(), this.aggregator);
        }
        if (!this.definitions_written && this.outputType == 0) {
            this.saveFeatureDefinitions(dArray2, this.aggregator);
        }
    }

    public void finalize() throws Exception {
        if (this.outputType == 0) {
            this.values_writer.writeBytes("</feature_vector_file>");
        }
        this.values_writer.close();
    }

    private void findAndOrderFeaturesToExtract(FeatureExtractor[] featureExtractorArray, boolean[] blArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        String[] stringArray = new String[featureExtractorArray.length];
        for (int i = 0; i < featureExtractorArray.length; ++i) {
            stringArray[i] = featureExtractorArray[i].getFeatureDefinition().name;
        }
        String[][] stringArrayArray = new String[featureExtractorArray.length][];
        for (n9 = 0; n9 < featureExtractorArray.length; ++n9) {
            stringArrayArray[n9] = blArray[n9] ? featureExtractorArray[n9].getDepenedencies() : null;
        }
        n9 = 0;
        boolean[] blArray2 = new boolean[stringArrayArray.length];
        for (n8 = 0; n8 < blArray2.length; ++n8) {
            blArray2[n8] = blArray[n8];
        }
        while (n9 == 0) {
            n9 = 1;
            for (n8 = 0; n8 < stringArrayArray.length; ++n8) {
                if (stringArrayArray[n8] == null) continue;
                for (n7 = 0; n7 < stringArrayArray[n8].length; ++n7) {
                    String string = stringArrayArray[n8][n7];
                    for (n6 = 0; n6 < stringArray.length; ++n6) {
                        if (!string.equals(stringArray[n6])) continue;
                        if (!blArray2[n6]) {
                            blArray2[n6] = true;
                            stringArrayArray[n6] = featureExtractorArray[n6].getDepenedencies();
                            if (stringArrayArray[n6] != null) {
                                n9 = 0;
                            }
                        }
                        n6 = stringArray.length;
                    }
                }
            }
        }
        n8 = 0;
        for (n7 = 0; n7 < blArray2.length; ++n7) {
            if (!blArray2[n7]) continue;
            ++n8;
        }
        this.feature_extractors = new FeatureExtractor[n8];
        this.features_to_save = new boolean[n8];
        for (n7 = 0; n7 < this.features_to_save.length; ++n7) {
            this.features_to_save[n7] = false;
        }
        boolean[] blArray3 = new boolean[stringArrayArray.length];
        for (n5 = 0; n5 < blArray3.length; ++n5) {
            blArray3[n5] = false;
        }
        n5 = 0;
        n9 = 0;
        while (n9 == 0) {
            n9 = 1;
            for (n6 = 0; n6 < stringArrayArray.length; ++n6) {
                if (!blArray2[n6] || blArray3[n6] || stringArrayArray[n6] != null) continue;
                blArray3[n6] = true;
                this.feature_extractors[n5] = featureExtractorArray[n6];
                this.features_to_save[n5] = blArray[n6];
                ++n5;
                n9 = 0;
                for (n4 = 0; n4 < stringArrayArray.length; ++n4) {
                    if (!blArray2[n4] || stringArrayArray[n4] == null) continue;
                    n3 = stringArrayArray[n4].length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        if (!stringArrayArray[n4][n2].equals(stringArray[n6])) continue;
                        if (stringArrayArray[n4].length == 1) {
                            stringArrayArray[n4] = null;
                            n2 = n3;
                            continue;
                        }
                        String[] stringArray2 = new String[stringArrayArray[n4].length - 1];
                        n = 0;
                        for (int i = 0; i < stringArrayArray[n4].length; ++i) {
                            if (i == n2) continue;
                            stringArray2[n] = stringArrayArray[n4][i];
                            ++n;
                        }
                        stringArrayArray[n4] = stringArray2;
                        --n2;
                        --n3;
                    }
                }
            }
        }
        this.feature_extractor_dependencies = new int[this.feature_extractors.length][];
        String[] stringArray3 = new String[this.feature_extractors.length];
        for (n4 = 0; n4 < stringArray3.length; ++n4) {
            stringArray3[n4] = this.feature_extractors[n4].getFeatureDefinition().name;
        }
        String[][] stringArrayArray2 = new String[this.feature_extractors.length][];
        for (n3 = 0; n3 < stringArrayArray2.length; ++n3) {
            stringArrayArray2[n3] = this.feature_extractors[n3].getDepenedencies();
        }
        for (n3 = 0; n3 < stringArrayArray2.length; ++n3) {
            if (stringArrayArray2[n3] == null) continue;
            this.feature_extractor_dependencies[n3] = new int[stringArrayArray2[n3].length];
            for (n2 = 0; n2 < stringArrayArray2[n3].length; ++n2) {
                for (int i = 0; i < stringArray3.length; ++i) {
                    if (!stringArrayArray2[n3][n2].equals(stringArray3[i])) continue;
                    this.feature_extractor_dependencies[n3][n2] = i;
                }
            }
        }
        this.max_feature_offsets = new int[this.feature_extractors.length];
        for (n3 = 0; n3 < this.max_feature_offsets.length; ++n3) {
            if (this.feature_extractors[n3].getDepenedencyOffsets() == null) {
                this.max_feature_offsets[n3] = 0;
                continue;
            }
            int[] nArray = this.feature_extractors[n3].getDepenedencyOffsets();
            this.max_feature_offsets[n3] = Math.abs(nArray[0] + this.max_feature_offsets[this.feature_extractor_dependencies[n3][0]]);
            for (int i = 0; i < nArray.length; ++i) {
                n = Math.abs(nArray[i]) + this.max_feature_offsets[this.feature_extractor_dependencies[n3][i]];
                if (n <= this.max_feature_offsets[n3]) continue;
                this.max_feature_offsets[n3] = n;
            }
        }
    }

    private double[] preProcessRecording(File file) throws Exception {
        Object object;
        Object object2;
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file);
        AudioFormat audioFormat = audioInputStream.getFormat();
        int n = audioFormat.getSampleSizeInBits();
        if (n != 8 && n != 16) {
            n = 16;
        }
        AudioInputStream audioInputStream2 = audioInputStream;
        if (audioFormat.getEncoding() != AudioFormat.Encoding.PCM_SIGNED || !audioFormat.isBigEndian()) {
            object2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), n, audioFormat.getChannels(), audioFormat.getChannels() * (n / 8), audioFormat.getSampleRate(), true);
            audioInputStream2 = AudioSystem.getAudioInputStream((AudioFormat)object2, audioInputStream);
        }
        object2 = audioInputStream2;
        if (audioFormat.getSampleRate() != (float)this.sampling_rate || n != audioFormat.getSampleSizeInBits()) {
            object = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, (float)this.sampling_rate, n, audioFormat.getChannels(), audioFormat.getChannels() * (n / 8), audioFormat.getSampleRate(), true);
            object2 = AudioSystem.getAudioInputStream((AudioFormat)object, audioInputStream2);
        }
        object = new AudioSamples((AudioInputStream)object2, file.getPath(), false);
        if (this.normalise) {
            ((AudioSamples)object).normalizeMixedDownSamples();
        }
        return ((AudioSamples)object).getSamplesMixedDown();
    }

    protected double[][][] getFeatures(double[] dArray, int[] nArray) throws Exception {
        double[][][] dArray2 = new double[nArray.length][this.feature_extractors.length][];
        int n = 1;
        if (nArray.length > 100) {
            n = nArray.length / 100;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n2;
            if (this.updater != null && i % n == 0) {
                this.updater.announceUpdate(i);
                if (this.cancel.isCancel()) {
                    throw new ExplicitCancel("Killed while processing features");
                }
            }
            double[] dArray3 = new double[this.window_size];
            int n3 = nArray[i];
            int n4 = n3 + this.window_size - 1;
            if (n4 < dArray.length) {
                for (n2 = n3; n2 <= n4; ++n2) {
                    dArray3[n2 - n3] = dArray[n2];
                }
            } else {
                for (n2 = n3; n2 <= n4; ++n2) {
                    dArray3[n2 - n3] = n2 < dArray.length ? dArray[n2] : 0.0;
                }
            }
            for (n2 = 0; n2 < this.feature_extractors.length; ++n2) {
                if (i >= this.max_feature_offsets[n2]) {
                    FeatureExtractor featureExtractor = this.feature_extractors[n2];
                    Object object = null;
                    if (this.feature_extractor_dependencies[n2] != null) {
                        object = new double[this.feature_extractor_dependencies[n2].length][];
                        for (int j = 0; j < this.feature_extractor_dependencies[n2].length; ++j) {
                            int n5 = this.feature_extractor_dependencies[n2][j];
                            int n6 = featureExtractor.getDepenedencyOffsets()[j];
                            object[j] = dArray2[i + n6][n5];
                        }
                    }
                    dArray2[i][n2] = featureExtractor.extractFeature(dArray3, this.sampling_rate, (double[][])object);
                    continue;
                }
                dArray2[i][n2] = null;
            }
        }
        return dArray2;
    }

    private double[][] getOverallRecordingFeatures(double[][][] dArray, FeatureDefinition[][] featureDefinitionArray) {
        LinkedList<double[]> linkedList = new LinkedList<double[]>();
        LinkedList<FeatureDefinition> linkedList2 = new LinkedList<FeatureDefinition>();
        for (int i = 0; i < this.feature_extractors.length; ++i) {
            if (dArray[dArray.length - 1][i] == null || !this.features_to_save[i]) continue;
            FeatureDefinition featureDefinition = this.feature_extractors[i].getFeatureDefinition();
            FeatureDefinition featureDefinition2 = new FeatureDefinition(featureDefinition.name + " Overall Average", featureDefinition.description + "\nThis is the overall average over all windows.", featureDefinition.is_sequential, dArray[dArray.length - 1][i].length);
            FeatureDefinition featureDefinition3 = new FeatureDefinition(featureDefinition.name + " Overall Standard Deviation", featureDefinition.description + "\nThis is the overall standard deviation over all windows.", featureDefinition.is_sequential, dArray[dArray.length - 1][i].length);
            double[] dArray2 = new double[dArray[dArray.length - 1][i].length];
            double[] dArray3 = new double[dArray[dArray.length - 1][i].length];
            for (int j = 0; j < dArray[dArray.length - 1][i].length; ++j) {
                int n = 0;
                for (int k = 0; k < dArray.length; ++k) {
                    if (dArray[k][i] == null) continue;
                    ++n;
                }
                double[] dArray4 = new double[n];
                int n2 = 0;
                for (int k = 0; k < dArray.length; ++k) {
                    if (dArray[k][i] == null) continue;
                    dArray4[n2] = dArray[k][i][j];
                    ++n2;
                }
                dArray2[j] = Statistics.getAverage(dArray4);
                dArray3[j] = Statistics.getStandardDeviation(dArray4);
            }
            linkedList.add(dArray2);
            linkedList2.add(featureDefinition2);
            linkedList.add(dArray3);
            linkedList2.add(featureDefinition3);
        }
        featureDefinitionArray[0] = linkedList2.toArray(new FeatureDefinition[1]);
        return (double[][])linkedList.toArray((T[])new double[1][]);
    }

    private void writeValuesXMLHeader() throws Exception {
        String string = new String("<?xml version=\"1.0\"?>\n<!DOCTYPE feature_vector_file [\n   <!ELEMENT feature_vector_file (comments, data_set+)>\n   <!ELEMENT comments (#PCDATA)>\n   <!ELEMENT data_set (data_set_id, section*, feature*)>\n   <!ELEMENT data_set_id (#PCDATA)>\n   <!ELEMENT section (feature+)>\n   <!ATTLIST section start CDATA \"\"\n                     stop CDATA \"\">\n   <!ELEMENT feature (name, v+)>\n   <!ELEMENT name (#PCDATA)>\n   <!ELEMENT v (#PCDATA)>\n]>\n\n<feature_vector_file>\n\n   <comments></comments>\n\n");
        this.values_writer.writeBytes(string);
    }

    private void writeValuesARFFHeader() throws Exception {
        String string = System.getProperty("line.separator");
        String string2 = "@relation jAudio" + string;
        this.values_writer.writeBytes(string2);
        if (this.save_features_for_each_window && !this.save_overall_recording_features) {
            for (int i = 0; i < this.feature_extractors.length; ++i) {
                if (!this.features_to_save[i]) continue;
                String string3 = this.feature_extractors[i].getFeatureDefinition().name;
                int n = this.feature_extractors[i].getFeatureDefinition().dimensions;
                for (int j = 0; j < n; ++j) {
                    this.values_writer.writeBytes("@ATTRIBUTE \"" + string3 + j + "\" NUMERIC" + string);
                }
            }
            this.values_writer.writeBytes(string);
            this.values_writer.writeBytes("@DATA" + string);
        }
    }

    private void saveARFFFeatureVectorsForARecording(double[][][] dArray, int[] nArray, String string, AggregatorContainer aggregatorContainer) throws Exception {
        if (this.save_overall_recording_features) {
            if (!this.isARFFOverallHeaderWritten) {
                aggregatorContainer.outputARFFHeaderEntries(this.values_writer);
                this.isARFFOverallHeaderWritten = true;
            }
            aggregatorContainer.outputARFFValueEntries(this.values_writer);
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray[i].length; ++j) {
                    int n;
                    if (!this.features_to_save[j]) continue;
                    if (dArray[i][j] == null) {
                        n = this.feature_extractors[j].getFeatureDefinition().dimensions;
                        for (int k = 0; k < n; ++k) {
                            this.values_writer.writeBytes("?");
                            if (k >= n - 1) continue;
                            this.values_writer.writeBytes(",");
                        }
                    } else {
                        for (n = 0; n < dArray[i][j].length; ++n) {
                            String string2 = StringMethods.getDoubleInScientificNotation(dArray[i][j][n], 4);
                            this.values_writer.writeBytes(string2);
                            if (n >= dArray[i][j].length - 1) continue;
                            this.values_writer.writeBytes(",");
                        }
                    }
                    if (j >= dArray[i].length - 1) continue;
                    this.values_writer.writeBytes(",");
                }
                this.values_writer.writeBytes(System.getProperty("line.separator"));
            }
        }
    }

    private void saveACEFeatureVectorsForARecording(double[][][] dArray, int[] nArray, String string, AggregatorContainer aggregatorContainer) throws Exception {
        this.values_writer.writeBytes("\t<data_set>\n");
        this.values_writer.writeBytes("\t\t<data_set_id>" + string + "</data_set_id>\n");
        if (this.save_features_for_each_window) {
            for (int i = 0; i < dArray.length; ++i) {
                double d = (double)nArray[i] / this.sampling_rate;
                double d2 = (double)(nArray[i] + this.window_size - 1) / this.sampling_rate;
                this.values_writer.writeBytes("\t\t<section start=\"" + d + "\" stop=\"" + d2 + "\">\n");
                for (int j = 0; j < dArray[i].length; ++j) {
                    if (!this.features_to_save[j] || dArray[i][j] == null) continue;
                    String string2 = this.feature_extractors[j].getFeatureDefinition().name;
                    this.values_writer.writeBytes("\t\t\t<feature>\n");
                    this.values_writer.writeBytes("\t\t\t\t<name>" + string2 + "</name>\n");
                    for (int k = 0; k < dArray[i][j].length; ++k) {
                        String string3 = StringMethods.getDoubleInScientificNotation(dArray[i][j][k], 4);
                        this.values_writer.writeBytes("\t\t\t\t<v>" + string3 + "</v>\n");
                    }
                    this.values_writer.writeBytes("\t\t\t</feature>\n");
                }
                this.values_writer.writeBytes("\t\t</section>\n");
            }
        }
        if (this.save_overall_recording_features) {
            aggregatorContainer.outputACEValueEntries(this.values_writer);
        }
        this.values_writer.writeBytes("\t</data_set>\n\n");
    }

    private void saveFeatureDefinitions(double[][][] dArray, AggregatorContainer aggregatorContainer) throws Exception {
        String string = new String("<?xml version=\"1.0\"?>\n<!DOCTYPE feature_key_file [\n   <!ELEMENT feature_key_file (comments, feature+)>\n   <!ELEMENT comments (#PCDATA)>\n   <!ELEMENT feature (name, description?, is_sequential, parallel_dimensions)>\n   <!ELEMENT name (#PCDATA)>\n   <!ELEMENT description (#PCDATA)>\n   <!ELEMENT is_sequential (#PCDATA)>\n   <!ELEMENT parallel_dimensions (#PCDATA)>\n]>\n\n<feature_key_file>\n\n   <comments></comments>\n\n");
        this.definitions_writer.writeBytes(string);
        double[][] dArray2 = dArray[dArray.length - 1];
        if (this.save_features_for_each_window) {
            for (int i = 0; i < this.feature_extractors.length; ++i) {
                if (!this.features_to_save[i] || dArray2[i] == null) continue;
                FeatureDefinition featureDefinition = this.feature_extractors[i].getFeatureDefinition();
                this.definitions_writer.writeBytes("   <feature>\n");
                this.definitions_writer.writeBytes("      <name>" + featureDefinition.name + "</name>\n");
                this.definitions_writer.writeBytes("      <description>" + featureDefinition.description + "</description>\n");
                this.definitions_writer.writeBytes("      <is_sequential>" + featureDefinition.is_sequential + "</is_sequential>\n");
                this.definitions_writer.writeBytes("      <parallel_dimensions>" + dArray2[i].length + "</parallel_dimensions>\n");
                this.definitions_writer.writeBytes("   </feature>\n\n");
            }
        }
        if (this.save_overall_recording_features) {
            aggregatorContainer.outputACEFeatureKeyEntries(this.definitions_writer);
        }
        this.definitions_writer.writeBytes("</feature_key_file>");
        this.definitions_writer.close();
        this.definitions_written = true;
    }
}

