/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.jAudioTools;

public class DSPMethods {
    public static double[][] applyGain(double[][] dArray, double d) {
        double[][] dArrayArray = new double[dArray.length][];
        for (int i = 0; i < dArrayArray.length; ++i) {
            dArrayArray[i] = new double[dArray[i].length];
            for (int j = 0; j < dArrayArray[i].length; ++j) {
                dArrayArray[i][j] = dArray[i][j] * d;
            }
        }
        return dArrayArray;
    }

    public static double[] getSamplesMixedDownIntoOneChannel(double[][] dArray) {
        if (dArray.length == 1) {
            return dArray[0];
        }
        double d = dArray.length;
        int n = dArray[0].length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            double d2 = 0.0;
            int n2 = 0;
            while ((double)n2 < d) {
                d2 += dArray[n2][i];
                ++n2;
            }
            dArray2[i] = d2 / d;
        }
        return dArray2;
    }

    public static double[] normalizeSamples(double[] dArray) {
        int n;
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[i];
        }
        double d = 0.0;
        for (n = 0; n < dArray2.length; ++n) {
            if (!(Math.abs(dArray2[n]) > d)) continue;
            d = Math.abs(dArray2[n]);
        }
        if (d != 0.0) {
            n = 0;
            while (n < dArray2.length) {
                int n2 = n++;
                dArray2[n2] = dArray2[n2] / d;
            }
        }
        return dArray2;
    }

    public static double[][] normalizeSamples(double[][] dArray) {
        int n;
        int n2;
        double[][] dArray2 = new double[dArray.length][dArray[0].length];
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < dArray2[i].length; ++j) {
                dArray2[i][j] = dArray[i][j];
            }
        }
        double d = 0.0;
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            for (n = 0; n < dArray2[n2].length; ++n) {
                if (!(Math.abs(dArray2[n2][n]) > d)) continue;
                d = Math.abs(dArray2[n2][n]);
            }
        }
        if (d != 0.0) {
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                n = 0;
                while (n < dArray2[n2].length) {
                    double[] dArray3 = dArray2[n2];
                    int n3 = n++;
                    dArray3[n3] = dArray3[n3] / d;
                }
            }
        }
        return dArray2;
    }

    public static double[][] getCopyOfSamples(double[][] dArray) {
        double[][] dArrayArray = new double[dArray.length][];
        for (int i = 0; i < dArrayArray.length; ++i) {
            dArrayArray[i] = new double[dArray[i].length];
            for (int j = 0; j < dArrayArray[i].length; ++j) {
                dArrayArray[i][j] = dArray[i][j];
            }
        }
        return dArrayArray;
    }

    public static int convertTimeToSample(double d, float f) {
        return (int)Math.round(d * (double)f);
    }

    public static double convertSampleToTime(int n, float f) {
        return (double)n / (double)f;
    }

    public static double[] getAutoCorrelation(double[] dArray, int n, int n2) {
        double[] dArray2 = new double[n2 - n + 1];
        for (int i = n; i <= n2; ++i) {
            int n3 = i - n;
            dArray2[n3] = 0.0;
            for (int j = 0; j < dArray.length - i; ++j) {
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + dArray[j] * dArray[j + i];
            }
        }
        return dArray2;
    }

    public static double[] getAutoCorrelationLabels(double d, int n, int n2) {
        double[] dArray = new double[n2 - n + 1];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = d / (double)(i + n);
        }
        return dArray;
    }
}

