/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.jAudioTools;

import jAudioFeatureExtractor.jAudioTools.AudioMethods;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.Date;
import java.util.Random;
import javax.sound.sampled.AudioFormat;

public class AudioMethodsSynthesis {
    private static final int SINE_WAVE = 1;
    private static final int BASIC_TONE = 2;
    private static final int STEREO_PANNING = 3;
    private static final int STEREO_PINPONG = 4;
    private static final int FM_SWEEP = 5;
    private static final int DECAY_PULSE = 6;
    private static final int WHITE_NOISE = 7;

    public static double[][] synthesizeAndWriteToBuffer(byte[] byArray, double d, AudioFormat audioFormat, int n, double d2, double d3, double d4, double d5, double d6) throws Exception {
        int n2;
        int n3;
        if (audioFormat == null) {
            throw new Exception("Null audio format provided.");
        }
        if (audioFormat.getSampleSizeInBits() != 16 && audioFormat.getSampleSizeInBits() != 8 || !audioFormat.isBigEndian() || audioFormat.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
            throw new Exception("Only 8 or 16 bit signed PCM samples with a big-endian\nbyte order can be generated currently.");
        }
        int n4 = audioFormat.getChannels();
        float f = audioFormat.getSampleRate();
        int n5 = audioFormat.getSampleSizeInBits();
        int n6 = 0;
        if (byArray != null) {
            int n7 = n5 / 8;
            n3 = byArray.length;
            n2 = n3 / n7;
            n6 = n2 / n4;
        } else {
            n6 = (int)((double)f * d);
        }
        double[][] dArray = null;
        if (n == 1) {
            dArray = AudioMethodsSynthesis.generateSamplesSineWave(d4, n4, f, d5, n6);
        } else if (n == 2) {
            dArray = AudioMethodsSynthesis.generateSamplesBasicTone(d4, n4, f, d5, n6);
        } else if (n == 3) {
            dArray = AudioMethodsSynthesis.generateSamplesStereoPanning(d4, n4, f, d5, n6);
        } else if (n == 4) {
            dArray = AudioMethodsSynthesis.generateSamplesStereoPingpong(d4, n4, f, d5, n6);
        } else if (n == 5) {
            dArray = AudioMethodsSynthesis.generateSamplesFMSweep(d4, n4, f, d5, n6);
        } else if (n == 6) {
            dArray = AudioMethodsSynthesis.generateSamplesDecayPulse(d4, n4, f, d5, n6);
        } else if (n == 7) {
            dArray = AudioMethodsSynthesis.generateWhiteNoise(n4, n6);
        } else {
            throw new Exception("Invalid synthesis type specified.");
        }
        AudioMethodsSynthesis.applyGainAndPanning(dArray, d2, d3);
        AudioMethodsSynthesis.applyClickAvoidanceAttenuationEnvelope(dArray, d6, f);
        n3 = dArray[0].length;
        for (n2 = 0; n2 < dArray.length; ++n2) {
            if (dArray[n2].length == n3) continue;
            throw new Exception("Channels do not have equal number of samples.");
        }
        if (byArray != null) {
            AudioMethodsSynthesis.writeSamplesToBuffer(dArray, n5, byArray);
            return null;
        }
        return dArray;
    }

    public static void applyGainAndPanning(double[][] dArray, double d, double d2) throws Exception {
        int n;
        if (d < 0.0 || d > 1.0) {
            throw new Exception("Gain of " + d + " specified.\n" + "This value must be between 0.0 and 1.0.");
        }
        if (d2 < -1.0 || d2 > 1.0) {
            throw new Exception("Panning of " + d2 + " specified.\n" + "This value must be between -1.0 and 1.0.");
        }
        if (dArray == null) {
            throw new Exception("Empty set of samples provided.");
        }
        for (n = 0; n < dArray.length; ++n) {
            if (dArray[n] != null) continue;
            throw new Exception("Channel " + n + " is empty.");
        }
        for (n = 0; n < dArray.length; ++n) {
            int n2 = 0;
            while (n2 < dArray[n].length) {
                double[] dArray2 = dArray[n];
                int n3 = n2++;
                dArray2[n3] = dArray2[n3] * d;
            }
        }
        if (dArray.length == 2 && d2 != 0.0) {
            int n4;
            if (d2 > 0.0) {
                double d3 = 1.0 - d2;
                n4 = 0;
                while (n4 < dArray[0].length) {
                    double[] dArray3 = dArray[0];
                    int n5 = n4++;
                    dArray3[n5] = dArray3[n5] * d3;
                }
            }
            if (d2 < 0.0) {
                double d4 = d2 + 1.0;
                n4 = 0;
                while (n4 < dArray[1].length) {
                    double[] dArray4 = dArray[1];
                    int n6 = n4++;
                    dArray4[n6] = dArray4[n6] * d4;
                }
            }
        }
    }

    public static void applyClickAvoidanceAttenuationEnvelope(double[][] dArray, double d, float f) throws Exception {
        int n;
        double d2;
        int n2;
        if (dArray == null) {
            throw new Exception("Empty set of samples provided.");
        }
        if (f <= 0.0f) {
            throw new Exception("Given sample rate is " + f + " Hz.\n" + "This value should be greater than zero.");
        }
        if (d < 0.0) {
            throw new Exception("Click avoidance envelope length is " + d + " seconds.\n" + "This value should be 0.0 seconds or higher.");
        }
        double d3 = (float)dArray[0].length / f;
        if (2.0 * d >= d3) {
            throw new Exception("Click avoidance envelope length is " + d + " seconds.\n" + "This would lead to combined envelope lengths longer than the provided audio.");
        }
        int n3 = (int)(d * (double)f);
        int n4 = 0;
        int n5 = n3 - 1;
        int n6 = dArray[0].length - 1 - n3;
        int n7 = dArray[0].length - 1;
        for (n2 = n4; n2 <= n5; ++n2) {
            d2 = (double)n2 / (double)n5;
            for (n = 0; n < dArray.length; ++n) {
                double[] dArray2 = dArray[n];
                int n8 = n2;
                dArray2[n8] = dArray2[n8] * d2;
            }
        }
        for (n2 = n6; n2 <= n7; ++n2) {
            d2 = 1.0 - (double)(n2 - n6) / (double)(n7 - n6);
            for (n = 0; n < dArray.length; ++n) {
                double[] dArray3 = dArray[n];
                int n9 = n2;
                dArray3[n9] = dArray3[n9] * d2;
            }
        }
    }

    public static void writeSamplesToBuffer(double[][] dArray, int n, byte[] byArray) throws Exception {
        block8: {
            ByteBuffer byteBuffer;
            double d;
            block7: {
                if (dArray == null) {
                    throw new Exception("Empty set of samples to write provided.");
                }
                if (n != 8 && n != 16) {
                    throw new Exception("Bit depth of " + n + " specified." + "Only bit depths of 8 or 16 currently accepted.");
                }
                if (byArray == null) {
                    throw new Exception("Null buffer for storing samples provided.");
                }
                d = AudioMethods.findMaximumSampleValue(n);
                byteBuffer = ByteBuffer.wrap(byArray);
                if (n != 8) break block7;
                for (int i = 0; i < dArray[0].length; ++i) {
                    for (int j = 0; j < dArray.length; ++j) {
                        double d2 = dArray[j][i] * d;
                        byteBuffer.put((byte)d2);
                    }
                }
                break block8;
            }
            if (n != 16) break block8;
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            for (int i = 0; i < dArray[0].length; ++i) {
                for (int j = 0; j < dArray.length; ++j) {
                    double d3 = dArray[j][i] * d;
                    shortBuffer.put((short)d3);
                }
            }
        }
    }

    public static int getSynthesisTypeCode(String string) throws Exception {
        if (string.equals("Sine Wave")) {
            return 1;
        }
        if (string.equals("Basic Tone")) {
            return 2;
        }
        if (string.equals("Stereo Panning")) {
            return 3;
        }
        if (string.equals("Stereo Pingpong")) {
            return 4;
        }
        if (string.equals("FM Sweep")) {
            return 5;
        }
        if (string.equals("Decay Pulse")) {
            return 6;
        }
        if (string.equals("White Noise")) {
            return 7;
        }
        throw new Exception("Unknown type of synthesis specified: " + string + ".\n" + "Known types of synthesis are:\n" + "   Sine Wave, Basic Tone, Stereo Panning, Stereo Pingpong\n" + "   FM Sweep, White Noise and Decay Pulse.");
    }

    public static String[] getSynthesisNames() {
        String[] stringArray = new String[]{"Sine Wave", "Basic Tone", "Stereo Panning", "Stereo Pingpong", "FM Sweep", "Decay Pulse", "White Noise"};
        return stringArray;
    }

    public static double[][] generateSamplesSineWave(double d, int n, float f, double d2, int n2) throws Exception {
        if (d2 <= 0.0) {
            throw new Exception("Invalid maximum allowable fraction of sampling rate of " + d2 + " specified.\n" + "This value must be above 0.");
        }
        if (d <= 0.0) {
            throw new Exception("Invalid fundamental frequence of " + d + " Hz specified.\n" + "Frequency must be above 0 Hz.");
        }
        if (d >= d2 * (double)f) {
            throw new Exception("Invalid fundamental frequency of " + d + " Hz specified.\n" + "Frequency must be below " + d2 * (double)f + " Hz\n" + "under current settings. This is done in order to avoid aliasing at this\n" + "sampling rate of " + f + " Hz for this type of synthesis.");
        }
        if (n < 1) {
            throw new Exception("There must be 1 or more channels. You specified " + n + ".");
        }
        if (f <= 0.0f) {
            throw new Exception("Invalid sampling rate of " + f + " Hz specified.\n" + "Must be greater than 0.");
        }
        if (n2 <= 0) {
            throw new Exception("Invalid total number of samples per channel of " + n2 + " specified.\n" + "Must be greater than 0.");
        }
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n2; ++i) {
            double d3 = (float)i / f;
            double d4 = Math.sin(Math.PI * 2 * d * d3);
            for (int j = 0; j < dArray.length; ++j) {
                dArray[j][i] = d4;
            }
        }
        return dArray;
    }

    public static double[][] generateSamplesBasicTone(double d, int n, float f, double d2, int n2) throws Exception {
        if (d2 <= 0.0) {
            throw new Exception("Invalid maximum allowable fraction of sampling rate of " + d2 + " specified.\n" + "This value must be above 0.");
        }
        if (d <= 0.0) {
            throw new Exception("Invalid fundamental frequence of " + d + " Hz specified.\n" + "Frequency must be above 0 Hz.");
        }
        if (d >= d2 * (double)f / 1.8) {
            throw new Exception("Invalid fundamental frequency of " + d + " Hz specified.\n" + "Frequency must be below " + d2 * (double)f / 1.8 + " Hz\n" + "under current settings. This is done in order to avoid aliasing at this\n" + "sampling rate of " + f + " Hz for this type of synthesis.");
        }
        if (n < 1) {
            throw new Exception("There must be 1 or more channels. You specified " + n + ".");
        }
        if (f <= 0.0f) {
            throw new Exception("Invalid sampling rate of " + f + " Hz specified.\n" + "Must be greater than 0.");
        }
        if (n2 <= 0) {
            throw new Exception("Invalid total number of samples per channel of " + n2 + " specified.\n" + "Must be greater than 0.");
        }
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n2; ++i) {
            double d3 = (float)i / f;
            double d4 = Math.sin(Math.PI * 2 * d * d3) + Math.sin(7.5398223686155035 * d * d3) + Math.sin(11.309733552923255 * d * d3);
            d4 /= 3.0;
            for (int j = 0; j < dArray.length; ++j) {
                dArray[j][i] = d4;
            }
        }
        return dArray;
    }

    public static double[][] generateSamplesStereoPanning(double d, int n, float f, double d2, int n2) throws Exception {
        if (d2 <= 0.0) {
            throw new Exception("Invalid maximum allowable fraction of sampling rate of " + d2 + " specified.\n" + "This value must be above 0.");
        }
        if (d <= 0.0) {
            throw new Exception("Invalid fundamental frequence of " + d + " Hz specified.\n" + "Frequency must be above 0 Hz.");
        }
        if (d >= d2 * (double)f / 1.8) {
            throw new Exception("Invalid fundamental frequency of " + d + " Hz specified.\n" + "Frequency must be below " + d2 * (double)f + " Hz\n" + "under current settings. This is done in order to avoid aliasing at this\n" + "sampling rate of " + f + " Hz for this type of synthesis.");
        }
        if (n != 2) {
            throw new Exception("There must be 2 channels. You specified " + n + ".");
        }
        if (f <= 0.0f) {
            throw new Exception("Invalid sampling rate of " + f + " Hz specified.\n" + "Must be greater than 0.");
        }
        if (n2 <= 0) {
            throw new Exception("Invalid total number of samples per channel of " + n2 + " specified.\n" + "Must be greater than 0.");
        }
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n2; ++i) {
            double d3 = (float)i / f;
            double d4 = (double)i / (double)n2;
            double d5 = 1.0 - d4;
            double d6 = Math.sin(Math.PI * 2 * d * d3);
            double d7 = Math.sin(Math.PI * 2 * d / 2.0 * d3);
            dArray[0][i] = d5 * d6;
            dArray[1][i] = d4 * d7;
        }
        return dArray;
    }

    public static double[][] generateSamplesStereoPingpong(double d, int n, float f, double d2, int n2) throws Exception {
        if (d2 <= 0.0) {
            throw new Exception("Invalid maximum allowable fraction of sampling rate of " + d2 + " specified.\n" + "This value must be above 0.");
        }
        if (d <= 0.0) {
            throw new Exception("Invalid fundamental frequence of " + d + " Hz specified.\n" + "Frequency must be above 0 Hz.");
        }
        if (d >= d2 * (double)f / 1.8) {
            throw new Exception("Invalid fundamental frequency of " + d + " Hz specified.\n" + "Frequency must be below " + d2 * (double)f + " Hz\n" + "under current settings. This is done in order to avoid aliasing at this\n" + "sampling rate of " + f + " Hz for this type of synthesis.");
        }
        if (n != 2) {
            throw new Exception("There must be 2 channels. You specified " + n + ".");
        }
        if (f <= 0.0f) {
            throw new Exception("Invalid sampling rate of " + f + " Hz specified.\n" + "Must be greater than 0.");
        }
        if (n2 <= 0) {
            throw new Exception("Invalid total number of samples per channel of " + n2 + " specified.\n" + "Must be greater than 0.");
        }
        double[][] dArray = new double[n][n2];
        double d3 = 4.0;
        double d4 = 1.0 / d3;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 1.0;
        for (int i = 0; i < n2; ++i) {
            double d8;
            double d9 = (float)i / f;
            if (d9 - d5 > d4) {
                d8 = d7;
                d7 = d6;
                d6 = d8;
                d5 = d9;
            }
            d8 = Math.sin(Math.PI * 2 * d * d9);
            double d10 = Math.sin(Math.PI * 2 * d * 0.8 * d9);
            dArray[0][i] = d7 * d8;
            dArray[1][i] = d6 * d10;
        }
        return dArray;
    }

    public static double[][] generateSamplesFMSweep(double d, int n, float f, double d2, int n2) throws Exception {
        if (d2 <= 0.0) {
            throw new Exception("Invalid maximum allowable fraction of sampling rate of " + d2 + " specified.\n" + "This value must be above 0.");
        }
        if (d <= 0.0) {
            throw new Exception("Invalid fundamental frequence of " + d + " Hz specified.\n" + "Frequency must be above 0 Hz.");
        }
        if (d >= d2 * (double)f) {
            throw new Exception("Invalid fundamental frequency of " + d + " Hz specified.\n" + "Frequency must be below " + d2 * (double)f + " Hz\n" + "under current settings. This is done in order to avoid aliasing at this\n" + "sampling rate of " + f + " Hz for this type of synthesis.");
        }
        if (n < 1) {
            throw new Exception("There must be 1 or more channels. You specified " + n + ".");
        }
        if (f <= 0.0f) {
            throw new Exception("Invalid sampling rate of " + f + " Hz specified.\n" + "Must be greater than 0.");
        }
        if (n2 <= 0) {
            throw new Exception("Invalid total number of samples per channel of " + n2 + " specified.\n" + "Must be greater than 0.");
        }
        double[][] dArray = new double[n][n2];
        double d3 = d;
        double d4 = d3 / 10.0;
        for (int i = 0; i < n2; ++i) {
            double d5 = (float)i / f;
            double d6 = (double)i / (double)n2;
            double d7 = d4 + (d3 - d4) * d6;
            double d8 = Math.sin(Math.PI * 2 * d7 * d5);
            for (int j = 0; j < dArray.length; ++j) {
                dArray[j][i] = d8;
            }
        }
        return dArray;
    }

    public static double[][] generateSamplesDecayPulse(double d, int n, float f, double d2, int n2) throws Exception {
        if (d2 <= 0.0) {
            throw new Exception("Invalid maximum allowable fraction of sampling rate of " + d2 + " specified.\n" + "This value must be above 0.");
        }
        if (d <= 0.0) {
            throw new Exception("Invalid fundamental frequence of " + d + " Hz specified.\n" + "Frequency must be above 0 Hz.");
        }
        if (d >= d2 * (double)f) {
            throw new Exception("Invalid fundamental frequency of " + d + " Hz specified.\n" + "Frequency must be below " + d2 * (double)f + " Hz\n" + "under current settings. This is done in order to avoid aliasing at this\n" + "sampling rate of " + f + " Hz for this type of synthesis.");
        }
        if (n < 1) {
            throw new Exception("There must be 1 or more channels. You specified " + n + ".");
        }
        if (f <= 0.0f) {
            throw new Exception("Invalid sampling rate of " + f + " Hz specified.\n" + "Must be greater than 0.");
        }
        if (n2 <= 0) {
            throw new Exception("Invalid total number of samples per channel of " + n2 + " specified.\n" + "Must be greater than 0.");
        }
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n2; ++i) {
            double d3 = (float)i / f;
            double d4 = (double)i / (double)n2;
            double d5 = 1.0 - d4;
            double d6 = d5 * Math.sin(Math.PI * 2 * d * d3);
            for (int j = 0; j < dArray.length; ++j) {
                dArray[j][i] = d6;
            }
        }
        return dArray;
    }

    public static double[][] generateWhiteNoise(int n, int n2) throws Exception {
        if (n < 1) {
            throw new Exception("There must be 1 or more channels. You specified " + n + ".");
        }
        if (n2 <= 0) {
            throw new Exception("Invalid total number of samples per channel of " + n2 + " specified.\n" + "Must be greater than 0.");
        }
        double[][] dArray = new double[n][n2];
        Random random = new Random(new Date().getTime());
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray[j][i] = 2.0 * random.nextDouble() - 1.0;
            }
        }
        return dArray;
    }
}

