/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.jAudioTools;

import jAudioFeatureExtractor.jAudioTools.AudioEventLineListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioMethods {
    public static AudioFormat getCopyOfAudioFormat(AudioFormat audioFormat) {
        return new AudioFormat(audioFormat.getEncoding(), audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), audioFormat.isBigEndian());
    }

    public static String getAudioFormatData(AudioFormat audioFormat) {
        String string = audioFormat.getEncoding().toString() + "\n";
        String string2 = audioFormat.isBigEndian() ? "big-endian\n" : "little-endian\n";
        String string3 = audioFormat.getSampleRate() / 1000.0f + " kHz\n";
        String string4 = audioFormat.getSampleSizeInBits() + " bits\n";
        String string5 = audioFormat.getChannels() == 1 ? "mono\n" : (audioFormat.getChannels() == 2 ? "stereo\n" : audioFormat.getChannels() + " channels\n");
        String string6 = 8 * audioFormat.getFrameSize() + " bits\n";
        String string7 = audioFormat.getFrameRate() + " frames per second\n";
        String string8 = audioFormat.properties() + "\n";
        String string9 = new String();
        string9 = string9 + new String("SAMPLING RATE: " + string3);
        string9 = string9 + new String("BIT DEPTH: " + string4);
        string9 = string9 + new String("CHANNELS: " + string5);
        string9 = string9 + new String("FRAME SIZE: " + string6);
        string9 = string9 + new String("FRAME RATE: " + string7);
        string9 = string9 + new String("ENCODING: " + string);
        string9 = string9 + new String("BYTE ORDER: " + string2);
        string9 = string9 + new String("PROPERTIES: " + string8);
        return string9;
    }

    public static String getAudioFileFormatData(File file) throws Exception {
        try {
            AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(file);
            String string = file.getName() + "\n";
            String string2 = audioFileFormat.getType().toString() + "\n";
            String string3 = audioFileFormat.getByteLength() / 1024 + " kilobytes\n";
            String string4 = audioFileFormat.getFrameLength() + " sample frames\n";
            String string5 = (float)audioFileFormat.getFrameLength() / audioFileFormat.getFormat().getFrameRate() + " seconds\n";
            String string6 = audioFileFormat.properties() + "\n";
            String string7 = new String();
            string7 = string7 + new String("FILE NAME: " + string);
            string7 = string7 + new String("FILE TYPE: " + string2);
            string7 = string7 + new String("FILE SIZE: " + string3);
            string7 = string7 + new String("FRAMES OF AUDIO DATA: " + string4);
            string7 = string7 + new String("TIME DURATION: " + string5);
            string7 = string7 + new String("PROPERTIES: " + string6);
            string7 = string7 + "\n" + AudioMethods.getAudioFormatData(audioFileFormat.getFormat());
            return string7;
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            throw new Exception("File " + file.getName() + " has an unsupported audio format.");
        }
        catch (IOException iOException) {
            throw new Exception("File " + file.getName() + " is not readable.");
        }
    }

    public static String[] getAvailableFileFormatTypes() {
        AudioFileFormat.Type[] typeArray = AudioSystem.getAudioFileTypes();
        String[] stringArray = new String[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            stringArray[i] = typeArray[typeArray.length - 1 - i].toString();
        }
        return stringArray;
    }

    public static AudioFileFormat.Type getAudioFileFormatType(String string) {
        if (string.equals("WAVE")) {
            return AudioFileFormat.Type.WAVE;
        }
        if (string.equals("AIFF")) {
            return AudioFileFormat.Type.AIFF;
        }
        if (string.equals("AIFC")) {
            return AudioFileFormat.Type.AIFC;
        }
        if (string.equals("AU")) {
            return AudioFileFormat.Type.AU;
        }
        if (string.equals("SND")) {
            return AudioFileFormat.Type.SND;
        }
        return null;
    }

    public static String getAvailableMixerData() {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        String string = new String();
        for (int i = 0; i < infoArray.length; ++i) {
            string = string + new String("INDEX: " + i + "\n");
            string = string + new String("NAME: " + infoArray[i].getName()) + "\n";
            string = string + new String("VERSION: " + infoArray[i].getVersion()) + "\n";
            string = string + new String("VENDOR: " + infoArray[i].getVendor()) + "\n";
            string = string + new String("DESCRIPTION: " + infoArray[i].getDescription()) + "\n";
            string = string + new String("\n");
        }
        return string;
    }

    public static Mixer getMixer(int n, AudioEventLineListener audioEventLineListener) {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        Mixer mixer = AudioSystem.getMixer(infoArray[n]);
        if (audioEventLineListener != null) {
            mixer.addLineListener(audioEventLineListener);
        }
        return mixer;
    }

    public static TargetDataLine getTargetDataLine(AudioFormat audioFormat, AudioEventLineListener audioEventLineListener) throws Exception {
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
        TargetDataLine targetDataLine = null;
        targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
        if (audioEventLineListener != null) {
            targetDataLine.addLineListener(audioEventLineListener);
        }
        targetDataLine.open(audioFormat);
        targetDataLine.start();
        return targetDataLine;
    }

    public static TargetDataLine getTargetDataLine(AudioFormat audioFormat, Mixer mixer, AudioEventLineListener audioEventLineListener) throws Exception {
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
        TargetDataLine targetDataLine = null;
        targetDataLine = (TargetDataLine)mixer.getLine(info);
        if (audioEventLineListener != null) {
            targetDataLine.addLineListener(audioEventLineListener);
        }
        targetDataLine.open(audioFormat);
        targetDataLine.start();
        return targetDataLine;
    }

    public static SourceDataLine getSourceDataLine(AudioFormat audioFormat, AudioEventLineListener audioEventLineListener) {
        SourceDataLine sourceDataLine = null;
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
            if (audioEventLineListener != null) {
                sourceDataLine.addLineListener(audioEventLineListener);
            }
            sourceDataLine.open(audioFormat);
        }
        catch (LineUnavailableException lineUnavailableException) {
            System.out.println(lineUnavailableException);
            System.exit(0);
        }
        sourceDataLine.start();
        return sourceDataLine;
    }

    public static AudioInputStream getInputStream(ByteArrayOutputStream byteArrayOutputStream, AudioFormat audioFormat) {
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        long l = byArray.length / audioFormat.getFrameSize();
        AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, audioFormat, l);
        return audioInputStream;
    }

    public static AudioInputStream getInputStream(byte[] byArray, AudioFormat audioFormat) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        long l = byArray.length / audioFormat.getFrameSize();
        AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, audioFormat, l);
        return audioInputStream;
    }

    public static AudioInputStream getInputStream(File file) throws Exception {
        AudioInputStream audioInputStream = null;
        try {
            audioInputStream = AudioSystem.getAudioInputStream(file);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            throw new Exception("File " + file.getName() + " has an unsupported audio format.");
        }
        catch (IOException iOException) {
            throw new Exception("File " + file.getName() + " is not readable.");
        }
        return audioInputStream;
    }

    public static AudioFormat getConvertedAudioFormat(AudioFormat audioFormat) {
        int n = audioFormat.getSampleSizeInBits();
        if (n != 8 && n != 16) {
            n = 16;
        }
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), n, audioFormat.getChannels(), audioFormat.getChannels() * (n / 8), audioFormat.getSampleRate(), true);
    }

    public static AudioInputStream getConvertedAudioStream(AudioInputStream audioInputStream) {
        AudioFormat audioFormat = (audioInputStream = AudioMethods.convertUnsupportedFormat(audioInputStream)).getFormat();
        AudioFormat audioFormat2 = AudioMethods.getConvertedAudioFormat(audioFormat);
        if (!audioFormat2.matches(audioFormat)) {
            audioInputStream = AudioSystem.getAudioInputStream(audioFormat2, audioInputStream);
        }
        return audioInputStream;
    }

    public static AudioInputStream convertUnsupportedFormat(AudioInputStream audioInputStream) {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioInputStream.getFormat());
        if (!AudioSystem.isLineSupported(info)) {
            AudioFormat audioFormat = audioInputStream.getFormat();
            int n = 16;
            AudioFormat audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), n, audioFormat.getChannels(), audioFormat.getChannels() * (n / 8), audioFormat.getSampleRate(), true);
            audioInputStream = AudioSystem.getAudioInputStream(audioFormat2, audioInputStream);
        }
        return audioInputStream;
    }

    public static double[][] extractSampleValues(AudioInputStream audioInputStream) throws Exception {
        double[][] dArray;
        block7: {
            ByteBuffer byteBuffer;
            double d;
            int n;
            int n2;
            int n3;
            block6: {
                byte[] byArray = AudioMethods.getBytesFromAudioInputStream(audioInputStream);
                int n4 = byArray.length;
                AudioFormat audioFormat = audioInputStream.getFormat();
                n3 = audioFormat.getChannels();
                n2 = audioFormat.getSampleSizeInBits();
                if (n2 != 16 && n2 != 8 || !audioFormat.isBigEndian() || audioFormat.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
                    throw new Exception("Only 8 or 16 bit signed PCM samples with a big-endian\nbyte order can be analyzed currently.");
                }
                int n5 = byArray.length;
                int n6 = n2 / 8;
                n = n5 / n6 / n3;
                if ((n == 2 || n6 == 2) && n5 % 2 != 0 || n == 2 && n6 == 2 && n5 % 4 != 0) {
                    throw new Exception("Uneven number of bytes for given bit depth and number of channels.");
                }
                d = AudioMethods.findMaximumSampleValue(n2) + 2.0;
                dArray = new double[n3][n];
                byteBuffer = ByteBuffer.wrap(byArray);
                if (n2 != 8) break block6;
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        dArray[j][i] = (double)byteBuffer.get() / d;
                    }
                }
                break block7;
            }
            if (n2 != 16) break block7;
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n3; ++j) {
                    dArray[j][i] = (double)shortBuffer.get() / d;
                }
            }
        }
        return dArray;
    }

    public static byte[] getBytesFromAudioInputStream(AudioInputStream audioInputStream) throws Exception {
        float f = 0.25f;
        int n = AudioMethods.getNumberBytesNeeded(f, audioInputStream.getFormat());
        byte[] byArray = new byte[n + 2];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = audioInputStream.read(byArray, 0, byArray.length);
        while (n2 > 0) {
            byteArrayOutputStream.write(byArray, 0, n2);
            n2 = audioInputStream.read(byArray, 0, byArray.length);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            System.exit(0);
        }
        return byArray2;
    }

    public static int getNumberBytesNeeded(double d, AudioFormat audioFormat) {
        int n = audioFormat.getFrameSize();
        float f = audioFormat.getFrameRate();
        return (int)((double)((float)n * f) * d);
    }

    public static int getNumberBytesNeeded(int n, AudioFormat audioFormat) {
        int n2 = audioFormat.getSampleSizeInBits() / 8;
        int n3 = audioFormat.getChannels();
        return n * n2 * n3;
    }

    public static AudioInputStream convertToAudioInputStream(double[][] dArray, AudioFormat audioFormat) throws Exception {
        int n = AudioMethods.getNumberBytesNeeded(dArray[0].length, audioFormat);
        byte[] byArray = new byte[n];
        AudioMethods.writeSamplesToBuffer(dArray, audioFormat.getSampleSizeInBits(), byArray);
        return AudioMethods.getInputStream(byArray, audioFormat);
    }

    public static void writeSamplesToBuffer(double[][] dArray, int n, byte[] byArray) throws Exception {
        block8: {
            ByteBuffer byteBuffer;
            double d;
            block7: {
                if (dArray == null) {
                    throw new Exception("Empty set of samples to write provided.");
                }
                if (n != 8 && n != 16) {
                    throw new Exception("Bit depth of " + n + " specified." + "Only bit depths of 8 or 16 currently accepted.");
                }
                if (byArray == null) {
                    throw new Exception("Null buffer for storing samples provided.");
                }
                dArray = AudioMethods.clipSamples(dArray);
                d = AudioMethods.findMaximumSampleValue(n);
                byteBuffer = ByteBuffer.wrap(byArray);
                if (n != 8) break block7;
                for (int i = 0; i < dArray[0].length; ++i) {
                    for (int j = 0; j < dArray.length; ++j) {
                        double d2 = dArray[j][i] * d;
                        byteBuffer.put((byte)d2);
                    }
                }
                break block8;
            }
            if (n != 16) break block8;
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            for (int i = 0; i < dArray[0].length; ++i) {
                for (int j = 0; j < dArray.length; ++j) {
                    double d3 = dArray[j][i] * d;
                    shortBuffer.put((short)d3);
                }
            }
        }
    }

    public static double[][] clipSamples(double[][] dArray) throws Exception {
        if (dArray == null) {
            throw new Exception("Empty set of samples to provided.");
        }
        double[][] dArrayArray = new double[dArray.length][];
        for (int i = 0; i < dArrayArray.length; ++i) {
            dArrayArray[i] = new double[dArray[i].length];
            for (int j = 0; j < dArrayArray[i].length; ++j) {
                dArrayArray[i][j] = dArray[i][j] < -1.0 ? -1.0 : (dArray[i][j] > 1.0 ? 1.0 : dArray[i][j]);
            }
        }
        return dArrayArray;
    }

    public static double findMaximumSampleValue(int n) {
        int n2 = 1;
        for (int i = 0; i < n - 1; ++i) {
            n2 *= 2;
        }
        double d = (double)(--n2) - 1.0;
        return d;
    }

    public static void saveByteArrayOutputStream(ByteArrayOutputStream byteArrayOutputStream, AudioFormat audioFormat, File file, AudioFileFormat.Type type) throws Exception {
        if (byteArrayOutputStream == null) {
            throw new Exception("No audio data provided to save.");
        }
        if (audioFormat == null) {
            throw new Exception("No audio format provided for saving.");
        }
        if (file == null) {
            throw new Exception("No file provided for saving.");
        }
        if (type == null) {
            throw new Exception("No audio file format provided for saving.");
        }
        int n = byteArrayOutputStream.size();
        int n2 = audioFormat.getFrameSize();
        long l = n / n2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, audioFormat, l);
        AudioMethods.saveToFile(audioInputStream, file, type);
    }

    public static void saveToFile(AudioInputStream audioInputStream, File file, AudioFileFormat.Type type) throws Exception {
        if (audioInputStream == null) {
            throw new Exception("No audio provided to save.");
        }
        if (file == null) {
            throw new Exception("No file provided to save to.");
        }
        if (type == null) {
            throw new Exception("No file type to save to specified.");
        }
        AudioSystem.write(audioInputStream, type, file);
    }
}

