/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.GeneralTools.StringMethods;
import jAudioFeatureExtractor.jAudioTools.AudioFormatJFrame;
import jAudioFeatureExtractor.jAudioTools.AudioMethods;
import jAudioFeatureExtractor.jAudioTools.AudioMethodsPlayback;
import jAudioFeatureExtractor.jAudioTools.AudioMethodsSynthesis;
import jAudioFeatureExtractor.jAudioTools.FileFilterAudio;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SynthesisFrame
extends JFrame
implements ActionListener {
    static final long serialVersionUID = 1L;
    private SynthesisParameters selected_components;
    private AudioMethodsPlayback.PlayThread playback_thread;
    Controller controller;
    private AudioFormatJFrame audio_format_selector;
    private JFileChooser save_file_chooser;
    private JComboBox synthesis_selection_combo_box;
    private JTextArea fund_freq_text_area;
    private JTextArea relative_amplitude_multiplier_text_area;
    private JTextArea max_fraction_of_sampling_rate_text_area;
    private JTextArea selected_components_text_area;
    private JScrollPane selected_components_scroll_pane;
    private JTextArea duration_text_area;
    private JTextArea gain_text_area;
    private JTextArea panning_text_area;
    private JTextArea click_avoid_env_length_text_area;
    private JButton choose_encoding_format_button;
    private JButton add_synthesis_component_button;
    private JButton clear_synthesis_components_button;
    private JButton play_button;
    private JButton stop_playback_button;
    private JButton save_button;
    private JButton cancel_button;
    private JComboBox choose_file_format_combo_box;

    public SynthesisFrame(Controller controller) {
        int n;
        this.setTitle("Synthesize Audio");
        this.getContentPane().setBackground(new Color(0.75f, 0.85f, 1.0f));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SynthesisFrame.this.cancel();
            }
        });
        this.selected_components = null;
        this.playback_thread = null;
        this.save_file_chooser = null;
        this.controller = controller;
        this.audio_format_selector = new AudioFormatJFrame();
        AudioFormat audioFormat = AudioFormatJFrame.getStandardMidQualityRecordAudioFormat();
        this.audio_format_selector.setAudioFormat(audioFormat);
        String[] stringArray = AudioMethodsSynthesis.getSynthesisNames();
        this.synthesis_selection_combo_box = new JComboBox<String>(stringArray);
        this.synthesis_selection_combo_box.setBackground(this.getContentPane().getBackground());
        this.fund_freq_text_area = new JTextArea("440.0");
        this.relative_amplitude_multiplier_text_area = new JTextArea("1.0");
        this.max_fraction_of_sampling_rate_text_area = new JTextArea("0.45");
        this.duration_text_area = new JTextArea("1.0");
        this.gain_text_area = new JTextArea("0.8");
        this.panning_text_area = new JTextArea("0.0");
        this.click_avoid_env_length_text_area = new JTextArea("0.05");
        this.selected_components_text_area = new JTextArea();
        this.selected_components_text_area.setEditable(false);
        this.selected_components_text_area.setLineWrap(false);
        this.selected_components_text_area.setRows(4);
        this.selected_components_scroll_pane = new JScrollPane(this.selected_components_text_area);
        this.choose_encoding_format_button = new JButton("Choose Audio Format");
        this.choose_encoding_format_button.addActionListener(this);
        this.add_synthesis_component_button = new JButton("Add Component");
        this.add_synthesis_component_button.addActionListener(this);
        this.clear_synthesis_components_button = new JButton("Clear All Components");
        this.clear_synthesis_components_button.addActionListener(this);
        this.play_button = new JButton("Play");
        this.play_button.addActionListener(this);
        this.stop_playback_button = new JButton("Stop Playback");
        this.stop_playback_button.addActionListener(this);
        this.save_button = new JButton("Save");
        this.save_button.addActionListener(this);
        this.cancel_button = new JButton("Cancel");
        this.cancel_button.addActionListener(this);
        this.choose_file_format_combo_box = new JComboBox();
        String[] stringArray2 = AudioMethods.getAvailableFileFormatTypes();
        for (n = 0; n < stringArray2.length; ++n) {
            this.choose_file_format_combo_box.addItem(stringArray2[n]);
        }
        this.choose_file_format_combo_box.setBackground(this.getContentPane().getBackground());
        n = 6;
        int n2 = 11;
        this.setLayout(new BorderLayout(n, n2));
        JPanel jPanel = new JPanel(new GridLayout(13, 2, n, n2));
        jPanel.setBackground(this.getContentPane().getBackground());
        JPanel jPanel2 = new JPanel(new BorderLayout(n, n2));
        jPanel2.setBackground(this.getContentPane().getBackground());
        JPanel jPanel3 = new JPanel(new GridLayout(4, 2, n, n2));
        jPanel3.setBackground(this.getContentPane().getBackground());
        jPanel.add(new JLabel("OVERALL SYNTHESIS:"));
        jPanel.add(new JLabel(""));
        jPanel.add(new JLabel("Synthesis Encoding Format:"));
        jPanel.add(this.choose_encoding_format_button);
        jPanel.add(new JLabel("Duration (sec):"));
        jPanel.add(this.duration_text_area);
        jPanel.add(new JLabel("Gain (0.0 to 1.0):"));
        jPanel.add(this.gain_text_area);
        jPanel.add(new JLabel("Panning (-1.0 to 1.0):"));
        jPanel.add(this.panning_text_area);
        jPanel.add(new JLabel("Click Avoidance Env. Length (sec):"));
        jPanel.add(this.click_avoid_env_length_text_area);
        jPanel.add(new JLabel(""));
        jPanel.add(new JLabel(""));
        jPanel.add(new JLabel("INDIVIDUAL COMPONENTS:"));
        jPanel.add(new JLabel(""));
        jPanel.add(new JLabel("Synthesis Type:"));
        jPanel.add(this.synthesis_selection_combo_box);
        jPanel.add(new JLabel("Fundamental Frequency (Hz):"));
        jPanel.add(this.fund_freq_text_area);
        jPanel.add(new JLabel("Relative Amplitude (0.0 to 1.0):"));
        jPanel.add(this.relative_amplitude_multiplier_text_area);
        jPanel.add(new JLabel("Max Fraction of Sampling Rate:"));
        jPanel.add(this.max_fraction_of_sampling_rate_text_area);
        jPanel.add(this.clear_synthesis_components_button);
        jPanel.add(this.add_synthesis_component_button);
        jPanel2.add(this.selected_components_scroll_pane);
        jPanel3.add(this.play_button);
        jPanel3.add(this.stop_playback_button);
        jPanel3.add(new JLabel("File Format For Saving:"));
        jPanel3.add(this.choose_file_format_combo_box);
        jPanel3.add(new JLabel(""));
        jPanel3.add(new JLabel(""));
        jPanel3.add(this.cancel_button);
        jPanel3.add(this.save_button);
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel3, "South");
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.choose_encoding_format_button)) {
            this.audio_format_selector.setVisible(true);
        } else if (actionEvent.getSource().equals(this.add_synthesis_component_button)) {
            this.addSynthesisComponent();
        } else if (actionEvent.getSource().equals(this.clear_synthesis_components_button)) {
            this.clearSynthesisComponents();
        } else if (actionEvent.getSource().equals(this.play_button)) {
            this.play();
        } else if (actionEvent.getSource().equals(this.stop_playback_button)) {
            this.stopPlayback();
        } else if (actionEvent.getSource().equals(this.save_button)) {
            this.save();
        } else if (actionEvent.getSource().equals(this.cancel_button)) {
            this.cancel();
        }
    }

    private void play() {
        try {
            if (this.playback_thread != null) {
                this.stopPlayback();
            }
            byte[] byArray = this.performAdditiveSynthesis();
            AudioFormat audioFormat = this.audio_format_selector.getAudioFormat(false);
            AudioInputStream audioInputStream = AudioMethods.getInputStream(byArray, audioFormat);
            SourceDataLine sourceDataLine = AudioMethods.getSourceDataLine(audioFormat, null);
            this.playback_thread = AudioMethodsPlayback.playAudioInputStreamInterruptible(audioInputStream, sourceDataLine);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
        }
    }

    private void stopPlayback() {
        if (this.playback_thread != null) {
            this.playback_thread.stopPlaying();
            this.playback_thread = null;
        }
    }

    private void save() {
        if (this.playback_thread != null) {
            this.stopPlayback();
        }
        try {
            int n;
            byte[] byArray = this.performAdditiveSynthesis();
            AudioFormat audioFormat = this.audio_format_selector.getAudioFormat(false);
            AudioInputStream audioInputStream = AudioMethods.getInputStream(byArray, audioFormat);
            if (this.save_file_chooser == null) {
                this.save_file_chooser = new JFileChooser();
                this.save_file_chooser.setCurrentDirectory(new File("."));
                this.save_file_chooser.setFileFilter(new FileFilterAudio());
            }
            if ((n = this.save_file_chooser.showSaveDialog(this)) == 0) {
                int n2;
                File file = this.save_file_chooser.getSelectedFile();
                boolean bl = true;
                String string = (String)this.choose_file_format_combo_box.getSelectedItem();
                AudioFileFormat.Type type = AudioMethods.getAudioFileFormatType(string);
                if ((file = this.ensureCorrectExtension(file, type)).exists() && (n2 = JOptionPane.showConfirmDialog(null, "This file already exists.\nDo you wish to overwrite it?", "WARNING", 0)) != 0) {
                    bl = false;
                }
                if (bl) {
                    try {
                        AudioMethods.saveToFile(audioInputStream, file, type);
                        File[] fileArray = new File[]{file};
                        this.controller.addRecordingsAction.addRecording(fileArray);
                        this.cancel();
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
                    }
                }
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
        }
    }

    private void cancel() {
        this.stopPlayback();
        this.setVisible(false);
    }

    private void addSynthesisComponent() {
        String string = (String)this.synthesis_selection_combo_box.getSelectedItem();
        double d = Double.parseDouble(this.fund_freq_text_area.getText());
        double d2 = Double.parseDouble(this.relative_amplitude_multiplier_text_area.getText());
        double d3 = Double.parseDouble(this.max_fraction_of_sampling_rate_text_area.getText());
        try {
            if (this.selected_components == null) {
                this.selected_components = new SynthesisParameters(string, d, d2, d3);
            } else {
                SynthesisParameters synthesisParameters = this.selected_components;
                while (synthesisParameters.next_set_of_parameters != null) {
                    synthesisParameters = synthesisParameters.next_set_of_parameters;
                }
                synthesisParameters.next_set_of_parameters = new SynthesisParameters(string, d, d2, d3);
            }
            this.selected_components_text_area.append(string + " " + d + " Hz " + d2 + " rel. amp " + d3 + " max. frac. SR\n");
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
        }
    }

    private void clearSynthesisComponents() {
        this.selected_components_text_area.setText("");
        this.selected_components = null;
    }

    private byte[] performAdditiveSynthesis() throws Exception {
        int n;
        int n2;
        AudioFormat audioFormat = this.audio_format_selector.getAudioFormat(false);
        double d = Double.parseDouble(this.gain_text_area.getText());
        double d2 = Double.parseDouble(this.panning_text_area.getText());
        double d3 = Double.parseDouble(this.duration_text_area.getText());
        double d4 = Double.parseDouble(this.click_avoid_env_length_text_area.getText());
        if (d3 > 7200.0) {
            throw new Exception("You have selected a duration of " + d3 + " seconds,\n" + "which is too long. Duration must be less than 2 hours.");
        }
        if (d3 <= 0.0) {
            throw new Exception("You have selected a duration of " + d3 + "seconds.\n" + "Duration must be over seconds.");
        }
        int n3 = 0;
        double d5 = 0.0;
        if (this.selected_components == null) {
            throw new Exception("No additive synthesis components have been added yet.");
        }
        Object object = this.selected_components;
        while (((SynthesisParameters)object).next_set_of_parameters != null) {
            ++n3;
            d5 += ((SynthesisParameters)object).relative_amplitude;
            object = ((SynthesisParameters)object).next_set_of_parameters;
        }
        d5 += ((SynthesisParameters)object).relative_amplitude;
        object = new double[++n3];
        SynthesisParameters synthesisParameters = this.selected_components;
        for (int i = 0; i < n3; ++i) {
            object[i] = synthesisParameters.relative_amplitude / d5;
            synthesisParameters = synthesisParameters.next_set_of_parameters;
        }
        double[][][] dArrayArray = new double[n3][][];
        synthesisParameters = this.selected_components;
        for (int i = 0; i < n3; ++i) {
            n2 = AudioMethodsSynthesis.getSynthesisTypeCode(synthesisParameters.synthesis_type);
            dArrayArray[i] = AudioMethodsSynthesis.synthesizeAndWriteToBuffer(null, d3, audioFormat, n2, d, d2, synthesisParameters.fundamental_frequency, synthesisParameters.max_fraction_of_sampling_rate, d4);
            synthesisParameters = synthesisParameters.next_set_of_parameters;
        }
        double[][] dArray = new double[dArrayArray[0].length][dArrayArray[0][0].length];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = 0; n < dArray[n2].length; ++n) {
                dArray[n2][n] = 0.0;
            }
        }
        for (n2 = 0; n2 < dArray[0].length; ++n2) {
            for (n = 0; n < dArrayArray.length; ++n) {
                for (int i = 0; i < dArray.length; ++i) {
                    double[] dArray2 = dArray[i];
                    int n4 = n2;
                    dArray2[n4] = dArray2[n4] + object[n] * dArrayArray[n][i][n2];
                }
            }
        }
        n2 = AudioMethods.getNumberBytesNeeded(dArray[0].length, audioFormat);
        byte[] byArray = new byte[n2];
        AudioMethodsSynthesis.writeSamplesToBuffer(dArray, audioFormat.getSampleSizeInBits(), byArray);
        return byArray;
    }

    private File ensureCorrectExtension(File file, AudioFileFormat.Type type) {
        String string = "." + type.getExtension();
        String string2 = file.getAbsolutePath();
        String string3 = StringMethods.getExtension(string2);
        if (string3 == null) {
            string2 = string2 + string;
        } else if (!string3.equals(string)) {
            string2 = StringMethods.removeExtension(string2) + string;
        } else {
            return file;
        }
        JOptionPane.showMessageDialog(null, "Incorrect file extension specified.\nChanged from " + string3 + " to " + string + ".", "WARNING", 0);
        return new File(string2);
    }

    private class SynthesisParameters {
        public String synthesis_type;
        public double fundamental_frequency;
        public double relative_amplitude;
        public double max_fraction_of_sampling_rate;
        public SynthesisParameters next_set_of_parameters;

        public SynthesisParameters(String string, double d, double d2, double d3) throws Exception {
            String[] stringArray = AudioMethodsSynthesis.getSynthesisNames();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                bl = true;
            }
            if (!bl) {
                throw new Exception("Synthesis type " + string + " is unknown.");
            }
            if (d <= 0.0) {
                throw new Exception("Fundamental frequency is " + d + ".\n" + "This value must be above zero.");
            }
            if (d2 < 0.0 || d2 > 1.0) {
                throw new Exception("Relative amplitude is " + d2 + ".\n" + "This value must be between 0 and 1.");
            }
            if (d3 <= 0.0) {
                throw new Exception("Maximum fraction of sampling rate is " + d3 + ",\n" + "This value must be above zero.");
            }
            this.synthesis_type = string;
            this.fundamental_frequency = d;
            this.relative_amplitude = d2;
            this.max_fraction_of_sampling_rate = d3;
            this.next_set_of_parameters = null;
        }
    }
}

