/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.ACE.XMLParsers.FileFilterXML;
import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.DataTypes.RecordingInfo;
import jAudioFeatureExtractor.GeneralTools.GeneralMethods;
import jAudioFeatureExtractor.GeneralTools.StringMethods;
import jAudioFeatureExtractor.MIDIFrame;
import jAudioFeatureExtractor.OuterFrame;
import jAudioFeatureExtractor.RecordingFrame;
import jAudioFeatureExtractor.RecordingsTableModel;
import jAudioFeatureExtractor.SynthesisFrame;
import jAudioFeatureExtractor.jAudioTools.AudioMethods;
import jAudioFeatureExtractor.jAudioTools.AudioMethodsPlayback;
import jAudioFeatureExtractor.jAudioTools.AudioSamples;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class RecordingSelectorPanel
extends JPanel
implements ActionListener {
    static final long serialVersionUID = 1L;
    public OuterFrame outer_frame;
    private JPanel recordings_panel;
    private JScrollPane recordings_scroll_pane;
    private JTable recordings_table;
    JButton values_save_path_button;
    JButton definitions_save_path_button;
    private JButton add_recordings_button;
    private JButton delete_recordings_button;
    private JButton view_recording_information_button;
    private JButton play_recording_directly_button;
    private JButton play_recording_samples_button;
    private JButton use_MIDI_file_button;
    private JFileChooser save_file_chooser;
    private JFileChooser load_recording_chooser;
    private JFileChooser load_feature_vector_file_chooser;
    private RecordingFrame recording_frame;
    private SynthesisFrame synthesis_frame;
    private MIDIFrame midi_frame;
    JTextArea values_save_path_text_field;
    JTextArea definitions_save_path_text_field;
    private Controller controller;

    public RecordingSelectorPanel(OuterFrame outerFrame, Controller controller) {
        this.outer_frame = outerFrame;
        this.controller = controller;
        Color color = new Color(0.75f, 0.85f, 1.0f);
        this.controller.dm_.recordingInfo = null;
        this.controller.dm_.playback_thread = null;
        this.save_file_chooser = null;
        this.load_recording_chooser = null;
        this.recording_frame = null;
        this.synthesis_frame = null;
        this.midi_frame = null;
        int n = 6;
        int n2 = 11;
        this.setLayout(new BorderLayout(n, n2));
        this.add((Component)new JLabel("RECORDINGS:"), "North");
        this.recordings_panel = null;
        this.setUpRecordingListTable();
        JPanel jPanel = new JPanel(new GridLayout(4, 2, n, n2));
        jPanel.setBackground(color);
        this.add_recordings_button = new JButton("Add Recordings");
        this.add_recordings_button.addActionListener(this.controller.addRecordingsAction);
        jPanel.add(this.add_recordings_button);
        this.delete_recordings_button = new JButton("Delete Recordings");
        this.delete_recordings_button.addActionListener(this.controller.removeRecordingsAction);
        jPanel.add(this.delete_recordings_button);
        this.values_save_path_button = new JButton("Feature Values Save Path:");
        jPanel.add(this.values_save_path_button);
        this.values_save_path_button.addActionListener(this);
        this.values_save_path_text_field = new JTextArea("feature_values_1.xml", 1, 20);
        jPanel.add(this.values_save_path_text_field);
        this.definitions_save_path_button = new JButton("Feature Definitions Save Path:");
        jPanel.add(this.definitions_save_path_button);
        this.definitions_save_path_button.addActionListener(this);
        this.definitions_save_path_text_field = new JTextArea("feature_definitions_1.xml", 1, 20);
        jPanel.add(this.definitions_save_path_text_field);
        jPanel.add(new JLabel(""));
        this.add((Component)jPanel, "South");
        this.addTableMouseListener();
        this.controller.removeRecordingsAction.setModel(this.controller, this.recordings_table);
        this.controller.playSamplesAction.setTable(this.recordings_table);
        this.controller.playNowAction.setTable(this.recordings_table);
        this.controller.editRecordingsAction.setTable(this.recordings_table, outerFrame);
        this.controller.viewFileInfoAction.setTable(this.recordings_table);
        this.controller.addBatchAction.setFilePath(this.values_save_path_text_field, this.definitions_save_path_text_field);
        this.controller.viewBatchAction.setRecordingFields(this.definitions_save_path_text_field, this.values_save_path_text_field);
    }

    public void addRecordings(File[] fileArray) {
        int n;
        int n2;
        RecordingInfo[] recordingInfoArray = new RecordingInfo[fileArray.length];
        for (n2 = 0; n2 < fileArray.length; ++n2) {
            recordingInfoArray[n2] = null;
            if (fileArray[n2].exists()) {
                try {
                    AudioSamples audioSamples = null;
                    if (this.controller.validate.isSelected()) {
                        audioSamples = new AudioSamples(fileArray[n2], fileArray[n2].getPath(), false);
                    }
                    if (this.controller.storeSamples.isSelected()) {
                        if (audioSamples == null) {
                            audioSamples = new AudioSamples(fileArray[n2], fileArray[n2].getPath(), false);
                        }
                    } else {
                        audioSamples = null;
                    }
                    recordingInfoArray[n2] = new RecordingInfo(fileArray[n2].getName(), fileArray[n2].getPath(), audioSamples, false);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
                }
                continue;
            }
            JOptionPane.showMessageDialog(null, "The selected file " + fileArray[n2].getName() + " does not exist.", "ERROR", 0);
        }
        n2 = 0;
        if (this.controller.dm_.recordingInfo != null) {
            n2 = this.controller.dm_.recordingInfo.length;
        }
        int n3 = 0;
        if (recordingInfoArray != null) {
            n3 = recordingInfoArray.length;
        }
        Object[] objectArray = new RecordingInfo[n2 + n3];
        for (n = 0; n < n2; ++n) {
            objectArray[n] = this.controller.dm_.recordingInfo[n];
        }
        for (n = 0; n < n3; ++n) {
            objectArray[n + n2] = recordingInfoArray[n];
        }
        for (n = 0; n < objectArray.length - 1; ++n) {
            if (objectArray[n] == null) continue;
            String string = ((RecordingInfo)objectArray[n]).file_path;
            for (int i = n + 1; i < objectArray.length; ++i) {
                if (objectArray[i] == null || !string.equals(((RecordingInfo)objectArray[i]).file_path)) continue;
                objectArray[i] = null;
            }
        }
        Object[] objectArray2 = GeneralMethods.removeNullEntriesFromArray(objectArray);
        if (objectArray2 != null) {
            this.controller.dm_.recordingInfo = new RecordingInfo[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                this.controller.dm_.recordingInfo[i] = (RecordingInfo)objectArray2[i];
            }
        }
        this.controller.rtm_.fillTable(this.controller.dm_.recordingInfo);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.delete_recordings_button)) {
            this.deleteRecordings();
        } else if (actionEvent.getSource().equals(this.view_recording_information_button)) {
            this.viewRecordingInformation();
        } else if (actionEvent.getSource().equals(this.values_save_path_button)) {
            this.browseFeatureValuesSavePath();
        } else if (actionEvent.getSource().equals(this.definitions_save_path_button)) {
            this.browseFeatureDefinitionsSavePath();
        }
    }

    private void deleteRecordings() {
        int[] nArray = this.recordings_table.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            this.controller.dm_.recordingInfo[nArray[i]] = null;
        }
        Object[] objectArray = GeneralMethods.removeNullEntriesFromArray(this.controller.dm_.recordingInfo);
        if (objectArray != null) {
            this.controller.dm_.recordingInfo = new RecordingInfo[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                this.controller.dm_.recordingInfo[i] = (RecordingInfo)objectArray[i];
            }
            this.controller.rtm_.fillTable(this.controller.dm_.recordingInfo);
        } else {
            this.controller.dm_.recordingInfo = null;
            this.controller.rtm_.clearTable();
        }
    }

    public void addTableMouseListener() {
        this.recordings_table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int[] nArray = new int[]{RecordingSelectorPanel.this.recordings_table.rowAtPoint(mouseEvent.getPoint())};
                    RecordingSelectorPanel.this.viewRecordingInformation();
                    System.out.println("Clicked");
                }
            }
        });
    }

    private void viewRecordingInformation() {
        int[] nArray = this.recordings_table.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            String string;
            try {
                File file = new File(this.controller.dm_.recordingInfo[nArray[i]].file_path);
                string = AudioMethods.getAudioFileFormatData(file);
                JOptionPane.showMessageDialog(null, string, "FILE INFORMATION", 1);
                continue;
            }
            catch (Exception exception) {
                string = "Could not display file information for file " + this.controller.dm_.recordingInfo[nArray[i]].file_path + "\n" + exception.getMessage();
                JOptionPane.showMessageDialog(null, string, "ERROR", 0);
            }
        }
    }

    private void playRecordingDirectly() {
        try {
            int n = this.recordings_table.getSelectedRow();
            if (n < 0) {
                throw new Exception("No file selcected for playback.");
            }
            File file = new File(this.controller.dm_.recordingInfo[n].file_path);
            try {
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file);
                audioInputStream = AudioMethods.convertUnsupportedFormat(audioInputStream);
                SourceDataLine sourceDataLine = AudioMethods.getSourceDataLine(audioInputStream.getFormat(), null);
                this.stopPlayback();
                this.controller.dm_.playback_thread = AudioMethodsPlayback.playAudioInputStreamInterruptible(audioInputStream, sourceDataLine);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                throw new Exception("File " + file.getName() + " has an unsupported audio format.");
            }
            catch (Exception exception) {
                throw new Exception("File " + file.getName() + " is not playable.\n" + exception.getMessage());
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
        }
    }

    private void playRecordingSamples() {
        try {
            int n = this.recordings_table.getSelectedRow();
            if (n < 0) {
                throw new Exception("No file selcected for playback.");
            }
            RecordingInfo recordingInfo = this.controller.dm_.recordingInfo[n];
            try {
                Object object;
                AudioInputStream audioInputStream = null;
                if (recordingInfo.samples != null) {
                    audioInputStream = recordingInfo.samples.getAudioInputStreamChannelSegregated();
                } else {
                    object = new File(recordingInfo.file_path);
                    AudioSamples audioSamples = new AudioSamples((File)object, ((File)object).getPath(), false);
                    if (this.controller.storeSamples.isSelected()) {
                        recordingInfo.samples = audioSamples;
                    }
                    audioInputStream = audioSamples.getAudioInputStreamChannelSegregated();
                }
                object = AudioMethods.getSourceDataLine(audioInputStream.getFormat(), null);
                this.stopPlayback();
                this.controller.dm_.playback_thread = AudioMethodsPlayback.playAudioInputStreamInterruptible(audioInputStream, (SourceDataLine)object);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                throw new Exception("File " + recordingInfo.file_path + " has an unsupported audio format.");
            }
            catch (Exception exception) {
                throw new Exception("File " + recordingInfo.file_path + " is not playable.\n" + exception.getMessage());
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
        }
    }

    private void stopPlayback() {
        if (this.controller.dm_.playback_thread != null) {
            this.controller.dm_.playback_thread.stopPlaying();
        }
        this.controller.dm_.playback_thread = null;
    }

    private void recordNewRecording() {
        if (this.recording_frame == null) {
            this.recording_frame = new RecordingFrame(this.controller);
        } else {
            this.recording_frame.setVisible(true);
        }
    }

    private void setUpRecordingListTable() {
        if (this.recordings_table != null) {
            this.remove(this.recordings_table);
        }
        Object[] objectArray = new Object[]{new String("Name"), new String("Path")};
        int n = 0;
        if (this.controller.dm_.recordingInfo != null) {
            n = this.controller.dm_.recordingInfo.length;
        }
        this.controller.rtm_ = new RecordingsTableModel(objectArray, n);
        this.controller.rtm_.fillTable(this.controller.dm_.recordingInfo);
        this.recordings_table = new JTable(this.controller.rtm_);
        this.recordings_scroll_pane = new JScrollPane(this.recordings_table);
        this.recordings_panel = new JPanel(new GridLayout(1, 1));
        this.recordings_panel.add(this.recordings_scroll_pane);
        this.add((Component)this.recordings_panel, "Center");
        this.controller.rtm_.fireTableDataChanged();
        this.repaint();
        this.outer_frame.repaint();
    }

    private void browseFeatureValuesSavePath() {
        String string = this.chooseSavePath();
        if (string != null) {
            this.values_save_path_text_field.setText(string);
        }
    }

    private void browseFeatureDefinitionsSavePath() {
        String string = this.chooseSavePath();
        if (string != null) {
            this.definitions_save_path_text_field.setText(string);
        }
    }

    private String chooseSavePath() {
        if (this.save_file_chooser == null) {
            this.save_file_chooser = new JFileChooser();
            this.save_file_chooser.setCurrentDirectory(new File("."));
            this.save_file_chooser.setFileFilter(new FileFilterXML());
        }
        String string = null;
        int n = this.save_file_chooser.showSaveDialog(this);
        if (n == 0) {
            int n2;
            File file = this.save_file_chooser.getSelectedFile();
            string = file.getPath();
            String string2 = StringMethods.getExtension(string);
            if (string2 == null) {
                string = string + ".xml";
                file = new File(string);
            } else if (!string2.equals(".xml")) {
                string = StringMethods.removeExtension(string) + ".xml";
                file = new File(string);
            }
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(null, "This file already exists.\nDo you wish to overwrite it?", "WARNING", 0)) != 0) {
                string = null;
            }
        }
        return string;
    }
}

