/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.DataModel;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class GlobalWindowChange
extends JFrame
implements ActionListener {
    static final long serialVersionUID = 1L;
    private DataModel fm_;
    private JButton cancel;
    private JButton save;
    private JTextArea inputBox;

    public GlobalWindowChange(DataModel dataModel) {
        this.fm_ = dataModel;
        this.setTitle("Globally change window sizes");
        Color color = new Color(0.75f, 0.85f, 1.0f);
        this.getContentPane().setBackground(color);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GlobalWindowChange.this.cancel();
            }
        });
        this.inputBox = new JTextArea();
        JLabel jLabel = new JLabel("Global Window Width");
        this.save = new JButton("save");
        this.save.addActionListener(this);
        this.cancel = new JButton("cancel");
        this.cancel.addActionListener(this);
        this.setLayout(new GridLayout(2, 2, 6, 11));
        this.add(this.inputBox);
        this.add(jLabel);
        this.add(this.save);
        this.add(this.cancel);
        this.pack();
    }

    private void cancel() {
        this.setVisible(false);
    }

    private void save() {
        try {
            int n = Integer.parseInt(this.inputBox.getText());
            for (int i = 0; i < this.fm_.features.length; ++i) {
                this.fm_.features[i].setWindow(n);
            }
            this.setVisible(false);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, this.inputBox.getText() + " is not an integer", "ERROR", 0);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.cancel)) {
            this.cancel();
        } else if (actionEvent.getSource().equals(this.save)) {
            this.save();
        }
    }
}

