/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.ACE.XMLParsers.XMLDocumentParser;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.Aggregators.AggregatorContainer;
import jAudioFeatureExtractor.AudioFeatures.Derivative;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.AudioFeatures.Mean;
import jAudioFeatureExtractor.AudioFeatures.MetaFeatureFactory;
import jAudioFeatureExtractor.AudioFeatures.StandardDeviation;
import jAudioFeatureExtractor.Cancel;
import jAudioFeatureExtractor.DataTypes.RecordingInfo;
import jAudioFeatureExtractor.ModelListener;
import jAudioFeatureExtractor.Updater;
import jAudioFeatureExtractor.jAudioTools.AudioMethodsPlayback;
import jAudioFeatureExtractor.jAudioTools.FeatureProcessor;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataModel {
    public ModelListener ml_;
    public Cancel cancel_;
    public boolean[] defaults;
    public FeatureExtractor[] features;
    public HashMap<String, Aggregator> aggregatorMap;
    public Aggregator[] aggregators;
    public AggregatorContainer container = null;
    public boolean[] is_primary;
    public FeatureDefinition[] featureDefinitions;
    public RecordingInfo[] recordingInfo;
    public AudioMethodsPlayback.PlayThread playback_thread;
    Updater updater = null;
    public OutputStream featureKey = null;
    public OutputStream featureValue = null;

    public DataModel(String string, ModelListener modelListener) {
        this.ml_ = modelListener;
        this.cancel_ = new Cancel();
        LinkedList<MetaFeatureFactory> linkedList = new LinkedList<MetaFeatureFactory>();
        linkedList.add(new Derivative());
        linkedList.add(new Mean());
        linkedList.add(new StandardDeviation());
        linkedList.add(new Derivative(new Mean()));
        linkedList.add(new Derivative(new StandardDeviation()));
        LinkedList linkedList2 = new LinkedList();
        LinkedList linkedList3 = new LinkedList();
        this.aggregatorMap = new HashMap();
        try {
            Object[] objectArray = (Object[])XMLDocumentParser.parseXMLDocument(string, "feature_list");
            linkedList2 = (LinkedList)objectArray[0];
            linkedList3 = (LinkedList)objectArray[1];
            Aggregator[] aggregatorArray = ((LinkedList)objectArray[2]).toArray(new Aggregator[0]);
            for (int i = 0; i < aggregatorArray.length; ++i) {
                this.aggregatorMap.put(aggregatorArray[i].getAggregatorDefinition().name, aggregatorArray[i]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        this.populateMetaFeatures(linkedList, linkedList2, linkedList3);
    }

    void populateMetaFeatures(LinkedList<MetaFeatureFactory> linkedList, LinkedList<FeatureExtractor> linkedList2, LinkedList<Boolean> linkedList3) {
        int n;
        Boolean[] booleanArray;
        Boolean[] booleanArray2;
        LinkedList<Object> linkedList4 = new LinkedList<Object>();
        LinkedList<Object> linkedList5 = new LinkedList<Object>();
        LinkedList<Boolean> linkedList6 = new LinkedList<Boolean>();
        Iterator iterator = linkedList2.iterator();
        Iterator iterator2 = linkedList3.iterator();
        while (iterator.hasNext()) {
            booleanArray2 = (Boolean[])iterator.next();
            booleanArray = (Boolean[])iterator2.next();
            linkedList5.add(booleanArray2);
            linkedList4.add(booleanArray);
            linkedList6.add(new Boolean(true));
            booleanArray2.setParent(this);
            if (booleanArray2.getFeatureDefinition().dimensions == 0) continue;
            for (MetaFeatureFactory metaFeatureFactory : linkedList) {
                MetaFeatureFactory metaFeatureFactory2 = metaFeatureFactory.defineFeature((FeatureExtractor)booleanArray2.clone());
                ((FeatureExtractor)metaFeatureFactory2).setParent(this);
                linkedList5.add(metaFeatureFactory2);
                linkedList4.add(new Boolean(false));
                linkedList6.add(new Boolean(false));
            }
        }
        this.features = linkedList5.toArray(new FeatureExtractor[1]);
        booleanArray2 = linkedList4.toArray(new Boolean[1]);
        booleanArray = linkedList6.toArray(new Boolean[0]);
        this.defaults = new boolean[booleanArray2.length];
        this.is_primary = new boolean[booleanArray2.length];
        for (n = 0; n < this.defaults.length; ++n) {
            this.defaults[n] = booleanArray2[n];
            this.is_primary[n] = booleanArray[n];
        }
        this.featureDefinitions = new FeatureDefinition[this.defaults.length];
        for (n = 0; n < this.featureDefinitions.length; ++n) {
            this.featureDefinitions[n] = this.features[n].getFeatureDefinition();
        }
    }

    public void updateTable() {
        if (this.ml_ != null) {
            this.ml_.updateTable();
        }
    }

    public void extract(int n, double d, double d2, boolean bl, boolean bl2, boolean bl3, RecordingInfo[] recordingInfoArray, int n2) throws Exception {
        boolean bl4 = bl2;
        boolean bl5 = bl3;
        int n3 = n;
        double d3 = d;
        double d4 = d2;
        int n4 = n2;
        RecordingInfo[] recordingInfoArray2 = recordingInfoArray;
        if (recordingInfoArray2 == null) {
            throw new Exception("No recordings available to extract features from.");
        }
        if (this.updater != null) {
            this.updater.setNumberOfFiles(recordingInfoArray2.length);
        }
        this.container = new AggregatorContainer();
        this.container.add(this.aggregators);
        FeatureProcessor featureProcessor = new FeatureProcessor(n3, d3, d4, bl, this.features, this.defaults, bl4, bl5, this.featureValue, this.featureKey, n4, this.cancel_, this.container);
        for (int i = 0; i < recordingInfoArray2.length; ++i) {
            File file = new File(recordingInfoArray2[i].file_path);
            if (this.updater != null) {
                this.updater.announceUpdate(i, 0);
            }
            featureProcessor.extractFeatures(file, this.updater);
        }
        featureProcessor.finalize();
    }

    public void setUpdater(Updater updater) {
        this.updater = updater;
    }

    public void validateFile(String string, String string2) throws Exception {
        File file = new File(string2);
        File file2 = new File(string);
        if (file.exists() && !file.canWrite()) {
            throw new Exception("Cannot write to " + string2 + ".");
        }
        if (file2.exists() && !file2.canWrite()) {
            throw new Exception("Cannot write to " + string + ".");
        }
    }
}

