/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.AudioFeatures.MetaFeatureFactory;

public class StandardDeviation
extends MetaFeatureFactory {
    int sampleWidth = 100;

    public StandardDeviation() {
    }

    public StandardDeviation(MetaFeatureFactory metaFeatureFactory) {
        this.chainMetaFeatureFactory(metaFeatureFactory);
    }

    public MetaFeatureFactory defineFeature(FeatureExtractor featureExtractor) {
        int n;
        StandardDeviation standardDeviation = new StandardDeviation();
        standardDeviation.fe_ = this.fe_ != null & this.fe_ instanceof MetaFeatureFactory ? ((MetaFeatureFactory)this.fe_).defineFeature(featureExtractor) : featureExtractor;
        String string = "Standard Deviation of " + standardDeviation.fe_.getFeatureDefinition().name;
        String string2 = "Standard Deviation of " + standardDeviation.fe_.getFeatureDefinition().name + "." + standardDeviation.fe_.getFeatureDefinition().description;
        String[] stringArray = featureExtractor.getFeatureDefinition().attributes;
        String[] stringArray2 = new String[stringArray.length + 1];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2[n] = stringArray[n];
        }
        stringArray2[stringArray2.length - 1] = "Size of Window to calculate accross";
        standardDeviation.definition = new FeatureDefinition(string, string2, true, standardDeviation.fe_.getFeatureDefinition().dimensions, stringArray2);
        standardDeviation.dependencies = new String[this.sampleWidth];
        standardDeviation.offsets = new int[this.sampleWidth];
        for (n = 0; n < this.sampleWidth; ++n) {
            standardDeviation.dependencies[n] = standardDeviation.fe_.getFeatureDefinition().name;
            standardDeviation.offsets[n] = 0 - n;
        }
        return standardDeviation;
    }

    public double[] extractFeature(double[] dArray, double d, double[][] dArray2) throws Exception {
        int n;
        double[] dArray3 = new double[dArray2[0].length];
        double[] dArray4 = new double[dArray2[0].length];
        double[] dArray5 = new double[dArray2[0].length];
        for (n = 0; n < dArray2[0].length; ++n) {
            dArray4[n] = 0.0;
            dArray5[n] = 0.0;
            for (int i = 0; i < dArray2.length; ++i) {
                int n2 = n;
                dArray4[n2] = dArray4[n2] + dArray2[i][n] * dArray2[i][n];
                int n3 = n;
                dArray5[n3] = dArray5[n3] + dArray2[i][n];
            }
        }
        for (n = 0; n < dArray2[0].length; ++n) {
            dArray3[n] = dArray5[n] * dArray5[n] - dArray4[n];
            int n4 = n;
            dArray3[n4] = dArray3[n4] / (double)(dArray2.length - 1);
            dArray3[n] = Math.sqrt(dArray3[n]);
        }
        return dArray3;
    }

    public void setWindow(int n) throws Exception {
        if (n <= 1) {
            throw new Exception("Width must be 2 or greater");
        }
        this.sampleWidth = n;
        if (this.fe_ != null) {
            String string = this.fe_.getFeatureDefinition().name;
            this.dependencies = new String[this.sampleWidth];
            this.offsets = new int[this.sampleWidth];
            for (int i = 0; i < this.sampleWidth; ++i) {
                this.dependencies[i] = string;
                this.offsets[i] = 0 - i;
            }
        } else {
            this.dependencies = null;
            this.offsets = null;
        }
    }

    public String getElement(int n) throws Exception {
        if (n >= this.definition.attributes.length || n < 0) {
            throw new Exception("INTERNAL ERROR: Request for an invalid index " + n);
        }
        if (n == this.definition.attributes.length - 1) {
            return Integer.toString(this.sampleWidth);
        }
        if (this.fe_ != null) {
            return this.fe_.getElement(n);
        }
        throw new Exception("INTERNAL ERROR: Request for child attribute in Standrad Deviation when the child is null");
    }

    public void setElement(int n, String string) throws Exception {
        if (n >= this.definition.attributes.length || n < 0) {
            throw new Exception("INTERNAL ERROR: Request for an invalid index " + n);
        }
        if (n == this.definition.attributes.length - 1) {
            try {
                int n2 = Integer.parseInt(string);
                if (n2 <= 1) {
                    throw new Exception("width of the window must be greater than 1");
                }
                this.setWindow(n2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("Width of window must be an integer");
            }
        } else if (this.fe_ != null) {
            this.fe_.setElement(n, string);
        } else {
            throw new Exception("Request to set a child in StandardDeviation attrbiute when the child is null");
        }
    }

    public Object clone() {
        if (this.fe_ == null) {
            return new StandardDeviation();
        }
        if (this.fe_ instanceof MetaFeatureFactory) {
            StandardDeviation standardDeviation = new StandardDeviation();
            standardDeviation.fe_ = (FeatureExtractor)this.fe_.clone();
            standardDeviation.definition = new FeatureDefinition(this.definition.name, this.definition.description, true, this.definition.dimensions, (String[])this.definition.attributes.clone());
            try {
                standardDeviation.setWindow(this.sampleWidth);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return standardDeviation;
        }
        StandardDeviation standardDeviation = (StandardDeviation)this.defineFeature((FeatureExtractor)this.fe_.clone());
        try {
            standardDeviation.setWindow(this.sampleWidth);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return standardDeviation;
    }

    public FeatureDefinition getFeatureDefinition() {
        String string = this.definition.name;
        String string2 = this.definition.description;
        FeatureDefinition featureDefinition = null;
        if (this.fe_ == null) {
            return this.definition;
        }
        featureDefinition = this.fe_.getFeatureDefinition();
        String[] stringArray = new String[featureDefinition.attributes.length + 1];
        for (int i = 0; i < featureDefinition.attributes.length; ++i) {
            stringArray[i] = featureDefinition.attributes[i];
        }
        stringArray[stringArray.length - 1] = "Size of Window for Standard Deviation";
        int n = featureDefinition.dimensions;
        this.definition = new FeatureDefinition(string, string2, true, n, stringArray);
        return this.definition;
    }
}

