/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.AudioFeatures.MetaFeatureFactory;

public class Mean
extends MetaFeatureFactory {
    protected int runningAverage = 100;

    public Mean() {
    }

    public Mean(MetaFeatureFactory metaFeatureFactory) {
        this.chainMetaFeatureFactory(metaFeatureFactory);
    }

    public MetaFeatureFactory defineFeature(FeatureExtractor featureExtractor) {
        int n;
        Mean mean = new Mean();
        mean.fe_ = this.fe_ != null & this.fe_ instanceof MetaFeatureFactory ? ((MetaFeatureFactory)this.fe_).defineFeature(featureExtractor) : featureExtractor;
        mean.fe_ = featureExtractor;
        String string = "Running Mean of " + featureExtractor.getFeatureDefinition().name;
        String string2 = "Running Mean of " + featureExtractor.getFeatureDefinition().name + ". " + featureExtractor.getFeatureDefinition().description;
        String[] stringArray = featureExtractor.getFeatureDefinition().attributes;
        String[] stringArray2 = new String[stringArray.length + 1];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2[n] = stringArray[n];
        }
        stringArray2[stringArray2.length - 1] = "Size of Window to Average accross";
        mean.definition = new FeatureDefinition(string, string2, true, featureExtractor.getFeatureDefinition().dimensions, stringArray2);
        mean.dependencies = new String[this.runningAverage];
        mean.offsets = new int[this.runningAverage];
        for (n = 0; n < this.runningAverage; ++n) {
            mean.dependencies[n] = featureExtractor.getFeatureDefinition().name;
            mean.offsets[n] = 0 - n;
        }
        return mean;
    }

    public double[] extractFeature(double[] dArray, double d, double[][] dArray2) throws Exception {
        double[] dArray3 = new double[dArray2[0].length];
        int n = 0;
        while (n < dArray3.length) {
            for (int i = 0; i < dArray2.length; ++i) {
                int n2 = n;
                dArray3[n2] = dArray3[n2] + dArray2[i][n];
            }
            int n3 = n++;
            dArray3[n3] = dArray3[n3] / (double)dArray2.length;
        }
        return dArray3;
    }

    public void setWindow(int n) throws Exception {
        if (n <= 1) {
            throw new Exception("new value for running average must be greater than one");
        }
        this.runningAverage = n;
        if (this.fe_ != null) {
            String string = this.fe_.getFeatureDefinition().name;
            this.dependencies = new String[this.runningAverage];
            this.offsets = new int[this.runningAverage];
            for (int i = 0; i < this.runningAverage; ++i) {
                this.dependencies[i] = string;
                this.offsets[i] = 0 - i;
            }
        } else {
            this.dependencies = null;
            this.offsets = null;
        }
        super.setWindow(n);
    }

    public String getElement(int n) throws Exception {
        if (n >= this.definition.attributes.length || n < 0) {
            throw new Exception("INTERNAL ERROR: Request for an invalid index " + n);
        }
        if (n == this.definition.attributes.length - 1) {
            return Integer.toString(this.runningAverage);
        }
        if (this.fe_ != null) {
            return this.fe_.getElement(n);
        }
        throw new Exception("INTERNAL ERROR: non-existant index for Mean:getElement - claims to have children, but child is null");
    }

    public void setElement(int n, String string) throws Exception {
        if (n >= this.definition.attributes.length || n < 0) {
            throw new Exception("INTERNAL ERROR: Request for an invalid index " + n);
        }
        if (n == this.definition.attributes.length - 1) {
            try {
                int n2 = Integer.parseInt(string);
                if (n2 <= 1) {
                    throw new Exception("width of the window must be greater than 1");
                }
                this.setWindow(n2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("Width of window must be an integer");
            }
        } else if (this.fe_ != null) {
            this.fe_.setElement(n, string);
        } else {
            throw new Exception("INTERNAL ERROR: non-existant index for Mean:getElement - claims to have children, but child is null");
        }
    }

    public Object clone() {
        if (this.fe_ == null) {
            return new Mean();
        }
        if (this.fe_ instanceof MetaFeatureFactory) {
            Mean mean = new Mean();
            mean.fe_ = (FeatureExtractor)this.fe_.clone();
            try {
                mean.setWindow(this.runningAverage);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            String string = this.definition.name;
            String string2 = this.definition.description;
            String[] stringArray = this.definition.attributes;
            int n = this.definition.dimensions;
            mean.definition = new FeatureDefinition(string, string2, true, n, stringArray);
            mean.dependencies = (String[])this.dependencies.clone();
            mean.offsets = (int[])this.offsets.clone();
            try {
                mean.setWindow(this.runningAverage);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return mean;
        }
        Mean mean = (Mean)this.defineFeature((FeatureExtractor)this.fe_.clone());
        try {
            mean.setWindow(this.runningAverage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return mean;
    }

    public FeatureDefinition getFeatureDefinition() {
        String string = this.definition.name;
        String string2 = this.definition.description;
        FeatureDefinition featureDefinition = null;
        if (this.fe_ == null) {
            return this.definition;
        }
        featureDefinition = this.fe_.getFeatureDefinition();
        String[] stringArray = new String[featureDefinition.attributes.length + 1];
        for (int i = 0; i < featureDefinition.attributes.length; ++i) {
            stringArray[i] = featureDefinition.attributes[i];
        }
        stringArray[stringArray.length - 1] = "Size of Window to Average accross";
        int n = featureDefinition.dimensions;
        this.definition = new FeatureDefinition(string, string2, true, n, stringArray);
        return this.definition;
    }
}

