/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class LPCRemoved
extends FeatureExtractor {
    private int num_dimensions = 10;

    public LPCRemoved() {
        String string = "LPC";
        String string2 = "Linear Predictive Encoding implemented from 'Numerical Recipes in C'";
        this.definition = new FeatureDefinition(string, string2, true, this.num_dimensions, new String[]{"Number of LPC Coeffecients to Calculate"});
        this.dependencies = null;
        this.offsets = null;
    }

    public double[] extractFeature(double[] dArray, double d, double[][] dArray2) throws Exception {
        int n;
        double[] dArray3 = new double[10];
        double[] dArray4 = new double[dArray.length];
        double[] dArray5 = new double[dArray.length];
        double[] dArray6 = new double[this.num_dimensions];
        dArray4[0] = dArray[0];
        dArray5[dArray.length - 2] = dArray[dArray.length - 1];
        for (n = 1; n < dArray.length - 1; ++n) {
            dArray4[n] = dArray[n];
            dArray5[n - 1] = dArray[n];
        }
        for (n = 0; n < this.num_dimensions; ++n) {
            int n2;
            double d2 = 0.0;
            double d3 = 0.0;
            for (n2 = 0; n2 < dArray.length - n; ++n2) {
                d2 += dArray4[n2] * dArray5[n2];
                d3 += dArray4[n2] * dArray4[n2] + dArray5[n2] * dArray5[n2];
            }
            dArray3[n] = 2.0 * d2 / d3;
            for (n2 = 0; n2 < n; ++n2) {
                dArray3[n2] = dArray6[n2] - dArray3[n] * dArray6[n - n2];
            }
            for (n2 = 0; n2 <= n; ++n2) {
                dArray6[n2] = dArray3[n2];
            }
            for (n2 = 0; n2 < dArray.length - n - 1; ++n2) {
                int n3 = n2;
                dArray4[n3] = dArray4[n3] - dArray6[n] * dArray5[n2];
                dArray5[n2] = dArray5[n2 + 1] - dArray6[n] * dArray4[n2 + 1];
            }
        }
        return dArray3;
    }

    public void setNumberDimensions(int n) throws Exception {
        if (n < 1) {
            throw new Exception("LPC must have at least 1 dimension");
        }
        this.definition.dimensions = this.num_dimensions = n;
        this.parent.updateTable();
    }

    public String getElement(int n) throws Exception {
        if (n != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + n + " sent to AreaMoments:getElement");
        }
        return Integer.toString(this.num_dimensions);
    }

    public void setElement(int n, String string) throws Exception {
        if (n != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + n + " sent to AreaMoments:setElement");
        }
        try {
            int n2 = Integer.parseInt(string);
            this.setNumberDimensions(n2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("Number of Coeffecients must be an integer");
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    public Object clone() {
        return new LPCRemoved();
    }
}

