/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class FractionOfLowEnergyWindows
extends FeatureExtractor {
    private int number_windows = 100;

    public FractionOfLowEnergyWindows() {
        int n;
        String string = "Fraction Of Low Energy Windows";
        String string2 = "The fraction of the last 100 windows that has an RMS less than the mean RMS in the last 100 windows. This can indicate how much of a signal is quiet relative to the rest of the signal.";
        boolean bl = true;
        int n2 = 1;
        this.definition = new FeatureDefinition(string, string2, bl, n2);
        this.dependencies = new String[this.number_windows];
        for (n = 0; n < this.dependencies.length; ++n) {
            this.dependencies[n] = "Root Mean Square";
        }
        this.offsets = new int[this.number_windows];
        for (n = 0; n < this.offsets.length; ++n) {
            this.offsets[n] = 0 - n;
        }
    }

    public double[] extractFeature(double[] dArray, double d, double[][] dArray2) throws Exception {
        int n;
        double d2 = 0.0;
        for (n = 0; n < dArray2.length; ++n) {
            d2 += dArray2[n][0];
        }
        d2 /= (double)dArray2.length;
        n = 0;
        for (int i = 0; i < dArray2.length; ++i) {
            if (!(dArray2[i][0] < d2)) continue;
            ++n;
        }
        double[] dArray3 = new double[]{(double)n / (double)dArray2.length};
        return dArray3;
    }

    public void setWindow(int n) throws Exception {
        if (n < 2) {
            throw new Exception("Fraction Of Low Energy Frames's window length must be 2 or greater");
        }
        this.number_windows = n;
        this.dependencies = new String[this.number_windows];
        this.offsets = new int[this.number_windows];
        for (int i = 0; i < this.number_windows; ++i) {
            this.dependencies[i] = "Root Mean Square";
            this.offsets[i] = 0 - i;
        }
    }

    public String getElement(int n) throws Exception {
        if (n != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + n + " sent to FractionOfLowEnergyFrames:getElement");
        }
        return Integer.toString(this.number_windows);
    }

    public void setElement(int n, String string) throws Exception {
        if (n != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + n + " sent to FractionOfLowEnergyFrames:setElement");
        }
        try {
            int n2 = Integer.parseInt(string);
            this.setWindow(n2);
        }
        catch (Exception exception) {
            throw new Exception("Length of Fraction Of Low Energy Frames's window must be an integer");
        }
    }

    public Object clone() {
        FractionOfLowEnergyWindows fractionOfLowEnergyWindows = new FractionOfLowEnergyWindows();
        fractionOfLowEnergyWindows.number_windows = this.number_windows;
        return fractionOfLowEnergyWindows;
    }
}

