/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.ActiveAggTableModel;
import jAudioFeatureExtractor.AggEditorFrame;
import jAudioFeatureExtractor.AggListTableModel;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.Aggregators.Mean;
import jAudioFeatureExtractor.Controller;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class AggregatorFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane ActiveAggList = null;
    private JTable ActiveAggTable = null;
    private JScrollPane AggList = null;
    private JTable AggListTable = null;
    private JPanel AggButtonPanel = null;
    private JButton AggAdd = null;
    private JButton AggRemove = null;
    private JButton AggEdit = null;
    private AggEditorFrame aggEditorFrame = null;
    private Controller controller;
    private JButton DoneButton = null;
    private JButton Abort = null;

    public AggregatorFrame(Controller controller) {
        this.controller = controller;
        this.initialize();
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setTitle("Aggregators");
        this.setBounds(new Rectangle(0, 22, 1000, 1000));
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getActiveAggList(), "West");
            this.jContentPane.add((Component)this.getAggList(), "East");
            this.jContentPane.add((Component)this.getAggButtonPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JScrollPane getActiveAggList() {
        if (this.ActiveAggList == null) {
            this.ActiveAggList = new JScrollPane();
            this.ActiveAggList.setViewportView(this.getActiveAggTable());
        }
        return this.ActiveAggList;
    }

    private JTable getActiveAggTable() {
        if (this.ActiveAggTable == null) {
            this.ActiveAggTable = new JTable();
            this.controller.activeAgg_ = new ActiveAggTableModel();
            this.controller.activeAgg_.init(this.controller);
            this.ActiveAggTable.setModel(this.controller.activeAgg_);
            this.ActiveAggTable.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = AggregatorFrame.this.ActiveAggTable.getSelectedRow()) >= 0) {
                        AggregatorFrame.this.aggEditorFrame = new AggEditorFrame(((AggregatorFrame)AggregatorFrame.this).controller.activeAgg_.getAggregator(n), AggregatorFrame.this.controller);
                        AggregatorFrame.this.aggEditorFrame.setVisible(true);
                        ((ActiveAggTableModel)AggregatorFrame.this.ActiveAggTable.getModel()).setAggregator(n, AggregatorFrame.this.aggEditorFrame.getAggregator(), AggregatorFrame.this.aggEditorFrame.isEdited());
                    }
                }
            });
        }
        return this.ActiveAggTable;
    }

    private JScrollPane getAggList() {
        if (this.AggList == null) {
            this.AggList = new JScrollPane();
            this.AggList.setViewportView(this.getAggListTable());
        }
        return this.AggList;
    }

    private JTable getAggListTable() {
        if (this.AggListTable == null) {
            this.AggListTable = new JTable();
            this.controller.aggList_ = new AggListTableModel();
            this.controller.aggList_.init(this.controller.dm_.aggregatorMap);
            this.AggListTable.setModel(this.controller.aggList_);
            this.AggListTable.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        int[] nArray = AggregatorFrame.this.AggListTable.getSelectedRows();
                        for (int i = 0; i < nArray.length; ++i) {
                            AggListTableModel aggListTableModel = (AggListTableModel)AggregatorFrame.this.AggListTable.getModel();
                            Aggregator aggregator = aggListTableModel.getAggregator(nArray[i]);
                            Aggregator aggregator2 = (Aggregator)aggregator.clone();
                            ((ActiveAggTableModel)AggregatorFrame.this.ActiveAggTable.getModel()).addAggregator(aggregator2);
                        }
                    }
                }
            });
        }
        return this.AggListTable;
    }

    private JPanel getAggButtonPanel() {
        if (this.AggButtonPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 3;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 0;
            this.AggButtonPanel = new JPanel();
            this.AggButtonPanel.setLayout(new GridBagLayout());
            this.AggButtonPanel.add((Component)this.getAggAdd(), gridBagConstraints5);
            this.AggButtonPanel.add((Component)this.getAggRemove(), gridBagConstraints4);
            this.AggButtonPanel.add((Component)this.getAggEdit(), gridBagConstraints3);
            this.AggButtonPanel.add((Component)this.getDoneButton(), gridBagConstraints2);
            this.AggButtonPanel.add((Component)this.getAbort(), gridBagConstraints);
        }
        return this.AggButtonPanel;
    }

    private JButton getAggAdd() {
        if (this.AggAdd == null) {
            this.AggAdd = new JButton();
            this.AggAdd.setText("Add");
            this.AggAdd.setToolTipText("Add a new Aggregator to be applied");
            this.AggAdd.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AggregatorFrame.this.AggListTable.getSelectedRow();
                    if (n != -1) {
                        AggListTableModel aggListTableModel = (AggListTableModel)AggregatorFrame.this.AggListTable.getModel();
                        Aggregator aggregator = aggListTableModel.getAggregator(n);
                        Aggregator aggregator2 = (Aggregator)aggregator.clone();
                        ((ActiveAggTableModel)AggregatorFrame.this.ActiveAggTable.getModel()).addAggregator(aggregator2);
                    }
                    System.out.println("actionPerformed()");
                }
            });
        }
        return this.AggAdd;
    }

    private JButton getAggRemove() {
        if (this.AggRemove == null) {
            this.AggRemove = new JButton();
            this.AggRemove.setText("Remove");
            this.AggRemove.setToolTipText("Remove an aggregator that has been previously defined");
            this.AggRemove.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AggregatorFrame.this.ActiveAggTable.getSelectedRow();
                    if (n >= 0) {
                        ((ActiveAggTableModel)AggregatorFrame.this.ActiveAggTable.getModel()).removeAggregator(n);
                    }
                }
            });
        }
        return this.AggRemove;
    }

    private JButton getAggEdit() {
        if (this.AggEdit == null) {
            this.AggEdit = new JButton();
            this.AggEdit.setText("Edit");
            this.AggEdit.setToolTipText("Edit the properities of the defined aggregator");
            this.AggEdit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AggregatorFrame.this.ActiveAggTable.getSelectedRow();
                    if (n != -1) {
                        AggregatorFrame.this.aggEditorFrame = new AggEditorFrame(((AggregatorFrame)AggregatorFrame.this).controller.activeAgg_.getAggregator(n), AggregatorFrame.this.controller);
                        AggregatorFrame.this.aggEditorFrame.setVisible(true);
                        ((ActiveAggTableModel)AggregatorFrame.this.ActiveAggTable.getModel()).setAggregator(n, AggregatorFrame.this.aggEditorFrame.getAggregator(), AggregatorFrame.this.aggEditorFrame.isEdited());
                    }
                }
            });
        }
        return this.AggEdit;
    }

    private JButton getDoneButton() {
        if (this.DoneButton == null) {
            this.DoneButton = new JButton();
            this.DoneButton.setText("Save");
            this.DoneButton.setToolTipText("Preserve changes to the aggregator list");
            this.DoneButton.addActionListener(this);
        }
        return this.DoneButton;
    }

    private JButton getAbort() {
        if (this.Abort == null) {
            this.Abort = new JButton();
            this.Abort.setText("Close");
            this.Abort.setToolTipText("Close the Aggregator Editor");
            this.Abort.addActionListener(this);
        }
        return this.Abort;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.DoneButton) {
            this.controller.dm_.aggregators = this.controller.activeAgg_.getAggregator() != null && this.controller.activeAgg_.getAggregator().length > 0 ? this.controller.activeAgg_.getAggregator() : new Aggregator[]{new Mean()};
        } else if (actionEvent.getSource() == this.Abort) {
            this.setVisible(false);
        }
    }
}

