/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.ACE.XMLParsers;

import jAudioFeatureExtractor.ACE.XMLParsers.FeatureListHandler;
import jAudioFeatureExtractor.ACE.XMLParsers.ParseBatchJobHandler;
import jAudioFeatureExtractor.ACE.XMLParsers.ParseClassificationsFileHandler;
import jAudioFeatureExtractor.ACE.XMLParsers.ParseDataSetFileHandler;
import jAudioFeatureExtractor.ACE.XMLParsers.ParseFeatureDefinitionsFileHandler;
import jAudioFeatureExtractor.ACE.XMLParsers.ParseFileHandler;
import jAudioFeatureExtractor.ACE.XMLParsers.ParseSaveSettings;
import jAudioFeatureExtractor.ACE.XMLParsers.ParseTaxonomyFileHandler;
import jAudioFeatureExtractor.ACE.XMLParsers.ParsingXMLErrorHandler;
import java.io.File;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLDocumentParser {
    public static Object parseXMLDocument(String string, String string2) throws Exception {
        ParseFileHandler parseFileHandler;
        File file = new File(string);
        if (!file.exists()) {
            throw new Exception("The specified path " + string + " does not refer to an existing file.");
        }
        if (file.isDirectory()) {
            throw new Exception("The specified path " + string + " refers to a directory, not to a file.");
        }
        SAXParser sAXParser = new SAXParser();
        sAXParser.setFeature("http://xml.org/sax/features/validation", true);
        sAXParser.setErrorHandler(new ParsingXMLErrorHandler());
        if (string2.equals("feature_vector_file")) {
            parseFileHandler = new ParseDataSetFileHandler();
        } else if (string2.equals("feature_key_file")) {
            parseFileHandler = new ParseFeatureDefinitionsFileHandler();
        } else if (string2.equals("taxonomy_file")) {
            parseFileHandler = new ParseTaxonomyFileHandler();
        } else if (string2.equals("classifications_file")) {
            parseFileHandler = new ParseClassificationsFileHandler();
        } else if (string2.equals("save_settings")) {
            parseFileHandler = new ParseSaveSettings();
        } else if (string2.equals("batchFile")) {
            parseFileHandler = new ParseBatchJobHandler();
        } else if (string2.equals("feature_list")) {
            parseFileHandler = new FeatureListHandler();
        } else {
            throw new Exception(new String("Invalid type of XML file specified. The XML file type " + string2 + " is not known."));
        }
        sAXParser.setContentHandler(parseFileHandler);
        try {
            sAXParser.parse(string);
        }
        catch (SAXParseException sAXParseException) {
            throw new Exception("The " + string + " file is not a valid XML file.\n\nDetails of the problem: " + sAXParseException.getMessage() + "\n\nThis error is likely in the region of line " + sAXParseException.getLineNumber() + ".");
        }
        catch (SAXException sAXException) {
            throw new Exception("The " + string + " file must be of type " + string2 + "." + sAXException.getMessage());
        }
        catch (Exception exception) {
            throw new Exception("The " + string + " file is not formatted properly.\n\nDetails of the problem: " + exception.getMessage());
        }
        return parseFileHandler.parsed_file_contents;
    }
}

