/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.ACE.XMLParsers;

import jAudioFeatureExtractor.ACE.XMLParsers.ParseFileHandler;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ParseSaveSettings
extends ParseFileHandler {
    private HashMap<String, Boolean> checkedMap_;
    private HashMap<String, String[]> attributeMap_;
    private LinkedList<String> aggregatorNames;
    private LinkedList<String[]> aggregatorFeatures;
    private LinkedList<String[]> aggregatorParameters;
    private LinkedList<String> tmpAggregatorFeature_;
    private LinkedList<String> tmpAggregatorParameters_;
    private LinkedList<String> tmpAttributes_;
    private String name;
    private String windowLength;
    private String windowOverlap;
    private double sampleRate;
    private boolean savePerWindow;
    private boolean saveOverall;
    private boolean normalise;
    private int tagType = -1;
    private boolean inFeature = false;
    private int count = 0;
    private String outputType = "";
    Pattern t = Pattern.compile(".*true.*");
    Pattern f = Pattern.compile(".*false.*");
    Matcher tm;
    Matcher fm;

    public void startDocument() throws SAXException {
        this.checkedMap_ = new HashMap();
        this.tmpAttributes_ = new LinkedList();
        this.attributeMap_ = new HashMap();
        this.aggregatorNames = new LinkedList();
        this.aggregatorFeatures = new LinkedList();
        this.aggregatorParameters = new LinkedList();
        this.tmpAggregatorFeature_ = new LinkedList();
        this.tmpAggregatorParameters_ = new LinkedList();
        this.count = 0;
        this.tagType = -1;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        string = string.substring(n, n + n2);
        switch (this.tagType) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.windowLength = string;
                break;
            }
            case 3: {
                this.windowOverlap = string;
                break;
            }
            case 4: {
                try {
                    this.sampleRate = Double.parseDouble(string);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SAXException("sampleRate must be a double");
                }
            }
            case 5: {
                this.tm = this.t.matcher(string);
                this.fm = this.f.matcher(string);
                if (this.tm.matches()) {
                    this.savePerWindow = true;
                    break;
                }
                if (this.fm.matches()) {
                    this.savePerWindow = false;
                    break;
                }
                throw new SAXException("Valid states are true or false, not " + string);
            }
            case 6: {
                this.tm = this.t.matcher(string);
                this.fm = this.f.matcher(string);
                if (this.tm.matches()) {
                    this.saveOverall = true;
                    break;
                }
                if (this.fm.matches()) {
                    this.saveOverall = false;
                    break;
                }
                throw new SAXException("Valid states are true or false, not " + string);
            }
            case 7: {
                this.tm = this.t.matcher(string);
                this.fm = this.f.matcher(string);
                if (this.tm.matches()) {
                    this.normalise = true;
                    break;
                }
                if (this.fm.matches()) {
                    this.normalise = false;
                    break;
                }
                throw new SAXException("Valid states are true or false, not " + string);
            }
            case 8: {
                this.outputType = string;
                break;
            }
            case 9: {
                this.tm = this.t.matcher(string);
                this.fm = this.f.matcher(string);
                if (this.tm.matches()) {
                    this.checkedMap_.put(this.name, true);
                    break;
                }
                if (this.fm.matches()) {
                    this.checkedMap_.put(this.name, false);
                    break;
                }
                throw new SAXException("Valid states are true or false, not " + string);
            }
            case 10: {
                this.tmpAttributes_.add(string);
                break;
            }
            case 11: {
                this.name = string;
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                this.aggregatorNames.add(string);
                break;
            }
            case 14: {
                this.tmpAggregatorFeature_.add(string);
                break;
            }
            case 15: {
                this.tmpAggregatorParameters_.add(string);
                break;
            }
            default: {
                throw new SAXException("Unknwon Tag Type " + this.tagType + "in characters");
            }
        }
    }

    public void endDocument() throws SAXException {
        this.parsed_file_contents = new Object[12];
        int n = 0;
        this.parsed_file_contents[n++] = this.windowLength;
        this.parsed_file_contents[n++] = this.windowOverlap;
        this.parsed_file_contents[n++] = new Double(this.sampleRate);
        this.parsed_file_contents[n++] = new Boolean(this.normalise);
        this.parsed_file_contents[n++] = new Boolean(this.savePerWindow);
        this.parsed_file_contents[n++] = new Boolean(this.saveOverall);
        this.parsed_file_contents[n++] = this.outputType;
        this.parsed_file_contents[n++] = this.checkedMap_;
        this.parsed_file_contents[n++] = this.attributeMap_;
        this.parsed_file_contents[n++] = this.aggregatorNames;
        this.parsed_file_contents[n++] = this.aggregatorFeatures;
        this.parsed_file_contents[n] = this.aggregatorParameters;
        this.count = -1;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string2.equals("name")) {
            this.tagType = 1;
        } else if (string2.equals("active")) {
            this.tagType = 1;
        } else if (string2.equals("attribute")) {
            this.tagType = 1;
        } else if (string2.equals("feature")) {
            this.attributeMap_.put(this.name, this.tmpAttributes_.toArray(new String[0]));
            this.tmpAttributes_.clear();
            this.tagType = 0;
        } else if (string2.equals("aggregatorName")) {
            this.tagType = 12;
        } else if (string2.equals("aggregatorFeature")) {
            this.tagType = 12;
        } else if (string2.equals("aggregatorAttribute")) {
            this.tagType = 12;
        } else if (string2.equals("aggregator")) {
            this.aggregatorFeatures.add(this.tmpAggregatorFeature_.toArray(new String[0]));
            this.aggregatorParameters.add(this.tmpAggregatorParameters_.toArray(new String[0]));
            this.tmpAggregatorFeature_.clear();
            this.tmpAggregatorParameters_.clear();
            this.tagType = 0;
        } else {
            this.tagType = 0;
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.count == 0 && !string2.equals("save_settings")) {
            throw new SAXException("\n\nIt is in reality of the type [" + string2 + "].");
        }
        ++this.count;
        if (string2.equals("feature")) {
            this.tagType = 1;
        } else if (string2.equals("windowSize")) {
            this.tagType = 2;
        } else if (string2.equals("windowOverlap")) {
            this.tagType = 3;
        } else if (string2.equals("samplingRate")) {
            this.tagType = 4;
        } else if (string2.equals("perWindowStats")) {
            this.tagType = 5;
        } else if (string2.equals("overallStats")) {
            this.tagType = 6;
        } else if (string2.equals("normalise")) {
            this.tagType = 7;
        } else if (string2.equals("outputType")) {
            this.tagType = 8;
        } else if (string2.equals("active")) {
            this.tagType = 9;
        } else if (string2.equals("attribute")) {
            this.tagType = 10;
        } else if (string2.equals("name")) {
            this.tagType = 11;
        } else if (string2.equals("aggregator")) {
            this.tagType = 12;
        } else if (string2.equals("aggregatorName")) {
            this.tagType = 13;
        } else if (string2.equals("aggregatorFeature")) {
            this.tagType = 14;
        } else if (string2.equals("aggregatorAttribute")) {
            this.tagType = 15;
        }
    }
}

