/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.ACE.DataTypes;

import jAudioFeatureExtractor.ACE.XMLParsers.XMLDocumentParser;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class FeatureDefinition
implements Serializable {
    public String name;
    public String description;
    public boolean is_sequential;
    public int dimensions;
    private static final long serialVersionUID = 2L;
    public String[] attributes;

    public FeatureDefinition() {
        this.name = "Undefined Feature";
        this.description = new String("");
        this.is_sequential = false;
        this.dimensions = 1;
        this.attributes = new String[0];
    }

    public FeatureDefinition(String string, String string2, boolean bl, int n) {
        this.name = string;
        this.description = string2;
        this.is_sequential = bl;
        this.dimensions = n;
        this.attributes = new String[0];
    }

    public FeatureDefinition(String string, String string2, boolean bl, int n, String[] stringArray) {
        this.name = string;
        this.description = string2;
        this.is_sequential = true;
        this.dimensions = n;
        this.attributes = stringArray;
    }

    public String getFeatureDescription() {
        String string = "NAME: " + this.name + "\n";
        string = string + "DESCRIPTION: " + this.description + "\n";
        string = string + "IS SEQUENTIAL: " + this.is_sequential + "\n";
        string = string + "DIMENSIONS: " + this.dimensions + "\n\n";
        return string;
    }

    public static String getFeatureDescriptions(FeatureDefinition[] featureDefinitionArray) {
        String string = new String();
        for (int i = 0; i < featureDefinitionArray.length; ++i) {
            string = string + featureDefinitionArray[i].getFeatureDescription();
        }
        return string;
    }

    public static FeatureDefinition[] parseFeatureDefinitionsFile(String string) throws Exception {
        Object[] objectArray = (Object[])XMLDocumentParser.parseXMLDocument(string, "feature_key_file");
        FeatureDefinition[] featureDefinitionArray = new FeatureDefinition[objectArray.length];
        for (int i = 0; i < featureDefinitionArray.length; ++i) {
            featureDefinitionArray[i] = (FeatureDefinition)objectArray[i];
        }
        String string2 = FeatureDefinition.verifyFeatureNameUniqueness(featureDefinitionArray);
        if (string2 != null) {
            throw new Exception("Could not parse because there are multiple\noccurences of the following feature names:\n" + string2);
        }
        return featureDefinitionArray;
    }

    public static void saveFeatureDefinitions(FeatureDefinition[] featureDefinitionArray, File file, String string) throws Exception {
        String string2 = FeatureDefinition.verifyFeatureNameUniqueness(featureDefinitionArray);
        if (string2 != null) {
            throw new Exception("Could not save because there are multiple\noccurences of the following feature names:\n" + string2);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            String string3 = new String("<?xml version=\"1.0\"?>\n<!DOCTYPE feature_key_file [\n   <!ELEMENT feature_key_file (comments, feature+)>\n   <!ELEMENT comments (#PCDATA)>\n   <!ELEMENT feature (name, description?, is_sequential, parallel_dimensions)>\n   <!ELEMENT name (#PCDATA)>\n   <!ELEMENT description (#PCDATA)>\n   <!ELEMENT is_sequential (#PCDATA)>\n   <!ELEMENT parallel_dimensions (#PCDATA)>\n]>\n\n<feature_key_file>\n\n   <comments>" + string + "</comments>\n\n");
            dataOutputStream.writeBytes(string3);
            for (int i = 0; i < featureDefinitionArray.length; ++i) {
                dataOutputStream.writeBytes("   <feature>\n");
                dataOutputStream.writeBytes("      <name>" + featureDefinitionArray[i].name + "</name>\n");
                if (!featureDefinitionArray[i].description.equals("")) {
                    dataOutputStream.writeBytes("      <description>" + featureDefinitionArray[i].description + "</description>\n");
                }
                dataOutputStream.writeBytes("      <is_sequential>" + featureDefinitionArray[i].is_sequential + "</is_sequential>\n");
                dataOutputStream.writeBytes("      <parallel_dimensions>" + featureDefinitionArray[i].dimensions + "</parallel_dimensions>\n");
                dataOutputStream.writeBytes("   </feature>\n\n");
            }
            dataOutputStream.writeBytes("</feature_key_file>");
            dataOutputStream.close();
        }
        catch (Exception exception) {
            throw new Exception("Unable to write file " + file.getName() + ".");
        }
    }

    public static String verifyFeatureNameUniqueness(FeatureDefinition[] featureDefinitionArray) {
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < featureDefinitionArray.length - 1; ++i) {
            for (int j = i + 1; j < featureDefinitionArray.length; ++j) {
                if (!featureDefinitionArray[i].name.equals(featureDefinitionArray[j].name)) continue;
                bl = true;
                vector.add(featureDefinitionArray[i].name);
                j = featureDefinitionArray.length;
            }
        }
        if (bl) {
            Object[] objectArray = vector.toArray();
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)objectArray[i];
            }
            String string = new String();
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + stringArray[i];
                if (i >= stringArray.length - 1) continue;
                string = string + ", ";
            }
            return string;
        }
        return null;
    }
}

