/* sha_long.i
 *
 * Copyright (C) 2006-2017 wolfSSL Inc.
 *
 * This file is part of wolfSSL.
 *
 * wolfSSL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * wolfSSL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1335, USA
 */


/* Rotate a 64-bit value left.
 *
 * a  The number to rotate left.
 * r  The number od bits to rotate left.
 * returns the rotated number.
 */
#define ROTL64(a, n)    (((a)<<(n))|((a)>>(64-(n))))

/* The block operation performed on the state.
 *
 * s  The state.
 */
static void BlockSha3(word64 *s)
{
    word64 b[5], t;

    /* Round 0. */
    /* Col Mix */
    b[0] = s[0] ^ s[5] ^ s[10] ^ s[15] ^ s[20];
    b[1] = s[1] ^ s[6] ^ s[11] ^ s[16] ^ s[21];
    b[2] = s[2] ^ s[7] ^ s[12] ^ s[17] ^ s[22];
    b[3] = s[3] ^ s[8] ^ s[13] ^ s[18] ^ s[23];
    b[4] = s[4] ^ s[9] ^ s[14] ^ s[19] ^ s[24];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[5]^=t; s[10]^=t; s[15]^=t; s[20]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[1]^=t; s[6]^=t; s[11]^=t; s[16]^=t; s[21]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[2]^=t; s[7]^=t; s[12]^=t; s[17]^=t; s[22]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[3]^=t; s[8]^=t; s[13]^=t; s[18]^=t; s[23]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[4]^=t; s[9]^=t; s[14]^=t; s[19]^=t; s[24]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[6], 44);
    b[2] = ROTL64(s[12], 43);
    b[3] = ROTL64(s[18], 21);
    b[4] = ROTL64(s[24], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[6] =  t12 ^ (b[2] | b[3]);
        s[12] = b[2] ^ (b[4] &  t34);
        s[18] =  t34 ^ (b[4] | b[0]);
        s[24] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[3], 28);
    b[1] = ROTL64(s[9], 20);
    b[2] = ROTL64(s[10], 3);
    b[3] = ROTL64(s[16], 45);
    b[4] = ROTL64(s[22], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[3] = b[0] ^ (b[2] &  t12);
        s[9] =  t12 ^ (b[2] | b[3]);
        s[10] = b[2] ^ (b[4] &  t34);
        s[16] =  t34 ^ (b[4] | b[0]);
        s[22] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[1], 1);
    b[1] = ROTL64(s[7], 6);
    b[2] = ROTL64(s[13], 25);
    b[3] = ROTL64(s[19], 8);
    b[4] = ROTL64(s[20], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[1] = b[0] ^ (b[2] &  t12);
        s[7] =  t12 ^ (b[2] | b[3]);
        s[13] = b[2] ^ (b[4] &  t34);
        s[19] =  t34 ^ (b[4] | b[0]);
        s[20] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[4], 27);
    b[1] = ROTL64(s[5], 36);
    b[2] = ROTL64(s[11], 10);
    b[3] = ROTL64(s[17], 15);
    b[4] = ROTL64(s[23], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[4] = b[0] ^ (b[2] &  t12);
        s[5] =  t12 ^ (b[2] | b[3]);
        s[11] = b[2] ^ (b[4] &  t34);
        s[17] =  t34 ^ (b[4] | b[0]);
        s[23] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[2], 62);
    b[1] = ROTL64(s[8], 55);
    b[2] = ROTL64(s[14], 39);
    b[3] = ROTL64(s[15], 41);
    b[4] = ROTL64(s[21], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[2] = b[0] ^ (b[2] &  t12);
        s[8] =  t12 ^ (b[2] | b[3]);
        s[14] = b[2] ^ (b[4] &  t34);
        s[15] =  t34 ^ (b[4] | b[0]);
        s[21] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x1UL;

    /* Round 1. */
    /* Col Mix */
    b[0] = s[0] ^ s[1] ^ s[2] ^ s[3] ^ s[4];
    b[1] = s[5] ^ s[6] ^ s[7] ^ s[8] ^ s[9];
    b[2] = s[10] ^ s[11] ^ s[12] ^ s[13] ^ s[14];
    b[3] = s[15] ^ s[16] ^ s[17] ^ s[18] ^ s[19];
    b[4] = s[20] ^ s[21] ^ s[22] ^ s[23] ^ s[24];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[1]^=t; s[2]^=t; s[3]^=t; s[4]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[5]^=t; s[6]^=t; s[7]^=t; s[8]^=t; s[9]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[10]^=t; s[11]^=t; s[12]^=t; s[13]^=t; s[14]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[15]^=t; s[16]^=t; s[17]^=t; s[18]^=t; s[19]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[20]^=t; s[21]^=t; s[22]^=t; s[23]^=t; s[24]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[9], 44);
    b[2] = ROTL64(s[13], 43);
    b[3] = ROTL64(s[17], 21);
    b[4] = ROTL64(s[21], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[9] =  t12 ^ (b[2] | b[3]);
        s[13] = b[2] ^ (b[4] &  t34);
        s[17] =  t34 ^ (b[4] | b[0]);
        s[21] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[18], 28);
    b[1] = ROTL64(s[22], 20);
    b[2] = ROTL64(s[1], 3);
    b[3] = ROTL64(s[5], 45);
    b[4] = ROTL64(s[14], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[18] = b[0] ^ (b[2] &  t12);
        s[22] =  t12 ^ (b[2] | b[3]);
        s[1] = b[2] ^ (b[4] &  t34);
        s[5] =  t34 ^ (b[4] | b[0]);
        s[14] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[6], 1);
    b[1] = ROTL64(s[10], 6);
    b[2] = ROTL64(s[19], 25);
    b[3] = ROTL64(s[23], 8);
    b[4] = ROTL64(s[2], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[6] = b[0] ^ (b[2] &  t12);
        s[10] =  t12 ^ (b[2] | b[3]);
        s[19] = b[2] ^ (b[4] &  t34);
        s[23] =  t34 ^ (b[4] | b[0]);
        s[2] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[24], 27);
    b[1] = ROTL64(s[3], 36);
    b[2] = ROTL64(s[7], 10);
    b[3] = ROTL64(s[11], 15);
    b[4] = ROTL64(s[15], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[24] = b[0] ^ (b[2] &  t12);
        s[3] =  t12 ^ (b[2] | b[3]);
        s[7] = b[2] ^ (b[4] &  t34);
        s[11] =  t34 ^ (b[4] | b[0]);
        s[15] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[12], 62);
    b[1] = ROTL64(s[16], 55);
    b[2] = ROTL64(s[20], 39);
    b[3] = ROTL64(s[4], 41);
    b[4] = ROTL64(s[8], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[12] = b[0] ^ (b[2] &  t12);
        s[16] =  t12 ^ (b[2] | b[3]);
        s[20] = b[2] ^ (b[4] &  t34);
        s[4] =  t34 ^ (b[4] | b[0]);
        s[8] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x8082UL;

    /* Round 2. */
    /* Col Mix */
    b[0] = s[0] ^ s[6] ^ s[12] ^ s[18] ^ s[24];
    b[1] = s[3] ^ s[9] ^ s[10] ^ s[16] ^ s[22];
    b[2] = s[1] ^ s[7] ^ s[13] ^ s[19] ^ s[20];
    b[3] = s[4] ^ s[5] ^ s[11] ^ s[17] ^ s[23];
    b[4] = s[2] ^ s[8] ^ s[14] ^ s[15] ^ s[21];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[6]^=t; s[12]^=t; s[18]^=t; s[24]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[3]^=t; s[9]^=t; s[10]^=t; s[16]^=t; s[22]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[1]^=t; s[7]^=t; s[13]^=t; s[19]^=t; s[20]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[4]^=t; s[5]^=t; s[11]^=t; s[17]^=t; s[23]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[2]^=t; s[8]^=t; s[14]^=t; s[15]^=t; s[21]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[22], 44);
    b[2] = ROTL64(s[19], 43);
    b[3] = ROTL64(s[11], 21);
    b[4] = ROTL64(s[8], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[22] =  t12 ^ (b[2] | b[3]);
        s[19] = b[2] ^ (b[4] &  t34);
        s[11] =  t34 ^ (b[4] | b[0]);
        s[8] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[17], 28);
    b[1] = ROTL64(s[14], 20);
    b[2] = ROTL64(s[6], 3);
    b[3] = ROTL64(s[3], 45);
    b[4] = ROTL64(s[20], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[17] = b[0] ^ (b[2] &  t12);
        s[14] =  t12 ^ (b[2] | b[3]);
        s[6] = b[2] ^ (b[4] &  t34);
        s[3] =  t34 ^ (b[4] | b[0]);
        s[20] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[9], 1);
    b[1] = ROTL64(s[1], 6);
    b[2] = ROTL64(s[23], 25);
    b[3] = ROTL64(s[15], 8);
    b[4] = ROTL64(s[12], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[9] = b[0] ^ (b[2] &  t12);
        s[1] =  t12 ^ (b[2] | b[3]);
        s[23] = b[2] ^ (b[4] &  t34);
        s[15] =  t34 ^ (b[4] | b[0]);
        s[12] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[21], 27);
    b[1] = ROTL64(s[18], 36);
    b[2] = ROTL64(s[10], 10);
    b[3] = ROTL64(s[7], 15);
    b[4] = ROTL64(s[4], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[21] = b[0] ^ (b[2] &  t12);
        s[18] =  t12 ^ (b[2] | b[3]);
        s[10] = b[2] ^ (b[4] &  t34);
        s[7] =  t34 ^ (b[4] | b[0]);
        s[4] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[13], 62);
    b[1] = ROTL64(s[5], 55);
    b[2] = ROTL64(s[2], 39);
    b[3] = ROTL64(s[24], 41);
    b[4] = ROTL64(s[16], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[13] = b[0] ^ (b[2] &  t12);
        s[5] =  t12 ^ (b[2] | b[3]);
        s[2] = b[2] ^ (b[4] &  t34);
        s[24] =  t34 ^ (b[4] | b[0]);
        s[16] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x800000000000808aUL;

    /* Round 3. */
    /* Col Mix */
    b[0] = s[0] ^ s[9] ^ s[13] ^ s[17] ^ s[21];
    b[1] = s[1] ^ s[5] ^ s[14] ^ s[18] ^ s[22];
    b[2] = s[2] ^ s[6] ^ s[10] ^ s[19] ^ s[23];
    b[3] = s[3] ^ s[7] ^ s[11] ^ s[15] ^ s[24];
    b[4] = s[4] ^ s[8] ^ s[12] ^ s[16] ^ s[20];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[9]^=t; s[13]^=t; s[17]^=t; s[21]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[1]^=t; s[5]^=t; s[14]^=t; s[18]^=t; s[22]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[2]^=t; s[6]^=t; s[10]^=t; s[19]^=t; s[23]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[3]^=t; s[7]^=t; s[11]^=t; s[15]^=t; s[24]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[4]^=t; s[8]^=t; s[12]^=t; s[16]^=t; s[20]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[14], 44);
    b[2] = ROTL64(s[23], 43);
    b[3] = ROTL64(s[7], 21);
    b[4] = ROTL64(s[16], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[14] =  t12 ^ (b[2] | b[3]);
        s[23] = b[2] ^ (b[4] &  t34);
        s[7] =  t34 ^ (b[4] | b[0]);
        s[16] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[11], 28);
    b[1] = ROTL64(s[20], 20);
    b[2] = ROTL64(s[9], 3);
    b[3] = ROTL64(s[18], 45);
    b[4] = ROTL64(s[2], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[11] = b[0] ^ (b[2] &  t12);
        s[20] =  t12 ^ (b[2] | b[3]);
        s[9] = b[2] ^ (b[4] &  t34);
        s[18] =  t34 ^ (b[4] | b[0]);
        s[2] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[22], 1);
    b[1] = ROTL64(s[6], 6);
    b[2] = ROTL64(s[15], 25);
    b[3] = ROTL64(s[4], 8);
    b[4] = ROTL64(s[13], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[22] = b[0] ^ (b[2] &  t12);
        s[6] =  t12 ^ (b[2] | b[3]);
        s[15] = b[2] ^ (b[4] &  t34);
        s[4] =  t34 ^ (b[4] | b[0]);
        s[13] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[8], 27);
    b[1] = ROTL64(s[17], 36);
    b[2] = ROTL64(s[1], 10);
    b[3] = ROTL64(s[10], 15);
    b[4] = ROTL64(s[24], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[8] = b[0] ^ (b[2] &  t12);
        s[17] =  t12 ^ (b[2] | b[3]);
        s[1] = b[2] ^ (b[4] &  t34);
        s[10] =  t34 ^ (b[4] | b[0]);
        s[24] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[19], 62);
    b[1] = ROTL64(s[3], 55);
    b[2] = ROTL64(s[12], 39);
    b[3] = ROTL64(s[21], 41);
    b[4] = ROTL64(s[5], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[19] = b[0] ^ (b[2] &  t12);
        s[3] =  t12 ^ (b[2] | b[3]);
        s[12] = b[2] ^ (b[4] &  t34);
        s[21] =  t34 ^ (b[4] | b[0]);
        s[5] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x8000000080008000UL;

    /* Round 4. */
    /* Col Mix */
    b[0] = s[0] ^ s[8] ^ s[11] ^ s[19] ^ s[22];
    b[1] = s[3] ^ s[6] ^ s[14] ^ s[17] ^ s[20];
    b[2] = s[1] ^ s[9] ^ s[12] ^ s[15] ^ s[23];
    b[3] = s[4] ^ s[7] ^ s[10] ^ s[18] ^ s[21];
    b[4] = s[2] ^ s[5] ^ s[13] ^ s[16] ^ s[24];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[8]^=t; s[11]^=t; s[19]^=t; s[22]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[3]^=t; s[6]^=t; s[14]^=t; s[17]^=t; s[20]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[1]^=t; s[9]^=t; s[12]^=t; s[15]^=t; s[23]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[4]^=t; s[7]^=t; s[10]^=t; s[18]^=t; s[21]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[2]^=t; s[5]^=t; s[13]^=t; s[16]^=t; s[24]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[20], 44);
    b[2] = ROTL64(s[15], 43);
    b[3] = ROTL64(s[10], 21);
    b[4] = ROTL64(s[5], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[20] =  t12 ^ (b[2] | b[3]);
        s[15] = b[2] ^ (b[4] &  t34);
        s[10] =  t34 ^ (b[4] | b[0]);
        s[5] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[7], 28);
    b[1] = ROTL64(s[2], 20);
    b[2] = ROTL64(s[22], 3);
    b[3] = ROTL64(s[17], 45);
    b[4] = ROTL64(s[12], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[7] = b[0] ^ (b[2] &  t12);
        s[2] =  t12 ^ (b[2] | b[3]);
        s[22] = b[2] ^ (b[4] &  t34);
        s[17] =  t34 ^ (b[4] | b[0]);
        s[12] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[14], 1);
    b[1] = ROTL64(s[9], 6);
    b[2] = ROTL64(s[4], 25);
    b[3] = ROTL64(s[24], 8);
    b[4] = ROTL64(s[19], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[14] = b[0] ^ (b[2] &  t12);
        s[9] =  t12 ^ (b[2] | b[3]);
        s[4] = b[2] ^ (b[4] &  t34);
        s[24] =  t34 ^ (b[4] | b[0]);
        s[19] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[16], 27);
    b[1] = ROTL64(s[11], 36);
    b[2] = ROTL64(s[6], 10);
    b[3] = ROTL64(s[1], 15);
    b[4] = ROTL64(s[21], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[16] = b[0] ^ (b[2] &  t12);
        s[11] =  t12 ^ (b[2] | b[3]);
        s[6] = b[2] ^ (b[4] &  t34);
        s[1] =  t34 ^ (b[4] | b[0]);
        s[21] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[23], 62);
    b[1] = ROTL64(s[18], 55);
    b[2] = ROTL64(s[13], 39);
    b[3] = ROTL64(s[8], 41);
    b[4] = ROTL64(s[3], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[23] = b[0] ^ (b[2] &  t12);
        s[18] =  t12 ^ (b[2] | b[3]);
        s[13] = b[2] ^ (b[4] &  t34);
        s[8] =  t34 ^ (b[4] | b[0]);
        s[3] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x808bUL;

    /* Round 5. */
    /* Col Mix */
    b[0] = s[0] ^ s[7] ^ s[14] ^ s[16] ^ s[23];
    b[1] = s[2] ^ s[9] ^ s[11] ^ s[18] ^ s[20];
    b[2] = s[4] ^ s[6] ^ s[13] ^ s[15] ^ s[22];
    b[3] = s[1] ^ s[8] ^ s[10] ^ s[17] ^ s[24];
    b[4] = s[3] ^ s[5] ^ s[12] ^ s[19] ^ s[21];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[7]^=t; s[14]^=t; s[16]^=t; s[23]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[2]^=t; s[9]^=t; s[11]^=t; s[18]^=t; s[20]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[4]^=t; s[6]^=t; s[13]^=t; s[15]^=t; s[22]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[1]^=t; s[8]^=t; s[10]^=t; s[17]^=t; s[24]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[3]^=t; s[5]^=t; s[12]^=t; s[19]^=t; s[21]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[2], 44);
    b[2] = ROTL64(s[4], 43);
    b[3] = ROTL64(s[1], 21);
    b[4] = ROTL64(s[3], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[2] =  t12 ^ (b[2] | b[3]);
        s[4] = b[2] ^ (b[4] &  t34);
        s[1] =  t34 ^ (b[4] | b[0]);
        s[3] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[10], 28);
    b[1] = ROTL64(s[12], 20);
    b[2] = ROTL64(s[14], 3);
    b[3] = ROTL64(s[11], 45);
    b[4] = ROTL64(s[13], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[10] = b[0] ^ (b[2] &  t12);
        s[12] =  t12 ^ (b[2] | b[3]);
        s[14] = b[2] ^ (b[4] &  t34);
        s[11] =  t34 ^ (b[4] | b[0]);
        s[13] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[20], 1);
    b[1] = ROTL64(s[22], 6);
    b[2] = ROTL64(s[24], 25);
    b[3] = ROTL64(s[21], 8);
    b[4] = ROTL64(s[23], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[20] = b[0] ^ (b[2] &  t12);
        s[22] =  t12 ^ (b[2] | b[3]);
        s[24] = b[2] ^ (b[4] &  t34);
        s[21] =  t34 ^ (b[4] | b[0]);
        s[23] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[5], 27);
    b[1] = ROTL64(s[7], 36);
    b[2] = ROTL64(s[9], 10);
    b[3] = ROTL64(s[6], 15);
    b[4] = ROTL64(s[8], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[5] = b[0] ^ (b[2] &  t12);
        s[7] =  t12 ^ (b[2] | b[3]);
        s[9] = b[2] ^ (b[4] &  t34);
        s[6] =  t34 ^ (b[4] | b[0]);
        s[8] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[15], 62);
    b[1] = ROTL64(s[17], 55);
    b[2] = ROTL64(s[19], 39);
    b[3] = ROTL64(s[16], 41);
    b[4] = ROTL64(s[18], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[15] = b[0] ^ (b[2] &  t12);
        s[17] =  t12 ^ (b[2] | b[3]);
        s[19] = b[2] ^ (b[4] &  t34);
        s[16] =  t34 ^ (b[4] | b[0]);
        s[18] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x80000001UL;

    /* Round 6. */
    /* Col Mix */
    b[0] = s[0] ^ s[5] ^ s[10] ^ s[15] ^ s[20];
    b[1] = s[2] ^ s[7] ^ s[12] ^ s[17] ^ s[22];
    b[2] = s[4] ^ s[9] ^ s[14] ^ s[19] ^ s[24];
    b[3] = s[1] ^ s[6] ^ s[11] ^ s[16] ^ s[21];
    b[4] = s[3] ^ s[8] ^ s[13] ^ s[18] ^ s[23];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[5]^=t; s[10]^=t; s[15]^=t; s[20]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[2]^=t; s[7]^=t; s[12]^=t; s[17]^=t; s[22]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[4]^=t; s[9]^=t; s[14]^=t; s[19]^=t; s[24]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[1]^=t; s[6]^=t; s[11]^=t; s[16]^=t; s[21]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[3]^=t; s[8]^=t; s[13]^=t; s[18]^=t; s[23]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[12], 44);
    b[2] = ROTL64(s[24], 43);
    b[3] = ROTL64(s[6], 21);
    b[4] = ROTL64(s[18], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[12] =  t12 ^ (b[2] | b[3]);
        s[24] = b[2] ^ (b[4] &  t34);
        s[6] =  t34 ^ (b[4] | b[0]);
        s[18] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[1], 28);
    b[1] = ROTL64(s[13], 20);
    b[2] = ROTL64(s[20], 3);
    b[3] = ROTL64(s[7], 45);
    b[4] = ROTL64(s[19], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[1] = b[0] ^ (b[2] &  t12);
        s[13] =  t12 ^ (b[2] | b[3]);
        s[20] = b[2] ^ (b[4] &  t34);
        s[7] =  t34 ^ (b[4] | b[0]);
        s[19] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[2], 1);
    b[1] = ROTL64(s[14], 6);
    b[2] = ROTL64(s[21], 25);
    b[3] = ROTL64(s[8], 8);
    b[4] = ROTL64(s[15], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[2] = b[0] ^ (b[2] &  t12);
        s[14] =  t12 ^ (b[2] | b[3]);
        s[21] = b[2] ^ (b[4] &  t34);
        s[8] =  t34 ^ (b[4] | b[0]);
        s[15] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[3], 27);
    b[1] = ROTL64(s[10], 36);
    b[2] = ROTL64(s[22], 10);
    b[3] = ROTL64(s[9], 15);
    b[4] = ROTL64(s[16], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[3] = b[0] ^ (b[2] &  t12);
        s[10] =  t12 ^ (b[2] | b[3]);
        s[22] = b[2] ^ (b[4] &  t34);
        s[9] =  t34 ^ (b[4] | b[0]);
        s[16] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[4], 62);
    b[1] = ROTL64(s[11], 55);
    b[2] = ROTL64(s[23], 39);
    b[3] = ROTL64(s[5], 41);
    b[4] = ROTL64(s[17], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[4] = b[0] ^ (b[2] &  t12);
        s[11] =  t12 ^ (b[2] | b[3]);
        s[23] = b[2] ^ (b[4] &  t34);
        s[5] =  t34 ^ (b[4] | b[0]);
        s[17] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x8000000080008081UL;

    /* Round 7. */
    /* Col Mix */
    b[0] = s[0] ^ s[1] ^ s[2] ^ s[3] ^ s[4];
    b[1] = s[10] ^ s[11] ^ s[12] ^ s[13] ^ s[14];
    b[2] = s[20] ^ s[21] ^ s[22] ^ s[23] ^ s[24];
    b[3] = s[5] ^ s[6] ^ s[7] ^ s[8] ^ s[9];
    b[4] = s[15] ^ s[16] ^ s[17] ^ s[18] ^ s[19];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[1]^=t; s[2]^=t; s[3]^=t; s[4]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[10]^=t; s[11]^=t; s[12]^=t; s[13]^=t; s[14]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[20]^=t; s[21]^=t; s[22]^=t; s[23]^=t; s[24]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[5]^=t; s[6]^=t; s[7]^=t; s[8]^=t; s[9]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[15]^=t; s[16]^=t; s[17]^=t; s[18]^=t; s[19]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[13], 44);
    b[2] = ROTL64(s[21], 43);
    b[3] = ROTL64(s[9], 21);
    b[4] = ROTL64(s[17], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[13] =  t12 ^ (b[2] | b[3]);
        s[21] = b[2] ^ (b[4] &  t34);
        s[9] =  t34 ^ (b[4] | b[0]);
        s[17] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[6], 28);
    b[1] = ROTL64(s[19], 20);
    b[2] = ROTL64(s[2], 3);
    b[3] = ROTL64(s[10], 45);
    b[4] = ROTL64(s[23], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[6] = b[0] ^ (b[2] &  t12);
        s[19] =  t12 ^ (b[2] | b[3]);
        s[2] = b[2] ^ (b[4] &  t34);
        s[10] =  t34 ^ (b[4] | b[0]);
        s[23] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[12], 1);
    b[1] = ROTL64(s[20], 6);
    b[2] = ROTL64(s[8], 25);
    b[3] = ROTL64(s[16], 8);
    b[4] = ROTL64(s[4], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[12] = b[0] ^ (b[2] &  t12);
        s[20] =  t12 ^ (b[2] | b[3]);
        s[8] = b[2] ^ (b[4] &  t34);
        s[16] =  t34 ^ (b[4] | b[0]);
        s[4] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[18], 27);
    b[1] = ROTL64(s[1], 36);
    b[2] = ROTL64(s[14], 10);
    b[3] = ROTL64(s[22], 15);
    b[4] = ROTL64(s[5], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[18] = b[0] ^ (b[2] &  t12);
        s[1] =  t12 ^ (b[2] | b[3]);
        s[14] = b[2] ^ (b[4] &  t34);
        s[22] =  t34 ^ (b[4] | b[0]);
        s[5] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[24], 62);
    b[1] = ROTL64(s[7], 55);
    b[2] = ROTL64(s[15], 39);
    b[3] = ROTL64(s[3], 41);
    b[4] = ROTL64(s[11], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[24] = b[0] ^ (b[2] &  t12);
        s[7] =  t12 ^ (b[2] | b[3]);
        s[15] = b[2] ^ (b[4] &  t34);
        s[3] =  t34 ^ (b[4] | b[0]);
        s[11] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x8000000000008009UL;

    /* Round 8. */
    /* Col Mix */
    b[0] = s[0] ^ s[6] ^ s[12] ^ s[18] ^ s[24];
    b[1] = s[1] ^ s[7] ^ s[13] ^ s[19] ^ s[20];
    b[2] = s[2] ^ s[8] ^ s[14] ^ s[15] ^ s[21];
    b[3] = s[3] ^ s[9] ^ s[10] ^ s[16] ^ s[22];
    b[4] = s[4] ^ s[5] ^ s[11] ^ s[17] ^ s[23];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[6]^=t; s[12]^=t; s[18]^=t; s[24]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[1]^=t; s[7]^=t; s[13]^=t; s[19]^=t; s[20]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[2]^=t; s[8]^=t; s[14]^=t; s[15]^=t; s[21]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[3]^=t; s[9]^=t; s[10]^=t; s[16]^=t; s[22]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[4]^=t; s[5]^=t; s[11]^=t; s[17]^=t; s[23]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[19], 44);
    b[2] = ROTL64(s[8], 43);
    b[3] = ROTL64(s[22], 21);
    b[4] = ROTL64(s[11], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[19] =  t12 ^ (b[2] | b[3]);
        s[8] = b[2] ^ (b[4] &  t34);
        s[22] =  t34 ^ (b[4] | b[0]);
        s[11] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[9], 28);
    b[1] = ROTL64(s[23], 20);
    b[2] = ROTL64(s[12], 3);
    b[3] = ROTL64(s[1], 45);
    b[4] = ROTL64(s[15], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[9] = b[0] ^ (b[2] &  t12);
        s[23] =  t12 ^ (b[2] | b[3]);
        s[12] = b[2] ^ (b[4] &  t34);
        s[1] =  t34 ^ (b[4] | b[0]);
        s[15] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[13], 1);
    b[1] = ROTL64(s[2], 6);
    b[2] = ROTL64(s[16], 25);
    b[3] = ROTL64(s[5], 8);
    b[4] = ROTL64(s[24], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[13] = b[0] ^ (b[2] &  t12);
        s[2] =  t12 ^ (b[2] | b[3]);
        s[16] = b[2] ^ (b[4] &  t34);
        s[5] =  t34 ^ (b[4] | b[0]);
        s[24] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[17], 27);
    b[1] = ROTL64(s[6], 36);
    b[2] = ROTL64(s[20], 10);
    b[3] = ROTL64(s[14], 15);
    b[4] = ROTL64(s[3], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[17] = b[0] ^ (b[2] &  t12);
        s[6] =  t12 ^ (b[2] | b[3]);
        s[20] = b[2] ^ (b[4] &  t34);
        s[14] =  t34 ^ (b[4] | b[0]);
        s[3] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[21], 62);
    b[1] = ROTL64(s[10], 55);
    b[2] = ROTL64(s[4], 39);
    b[3] = ROTL64(s[18], 41);
    b[4] = ROTL64(s[7], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[21] = b[0] ^ (b[2] &  t12);
        s[10] =  t12 ^ (b[2] | b[3]);
        s[4] = b[2] ^ (b[4] &  t34);
        s[18] =  t34 ^ (b[4] | b[0]);
        s[7] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x8aUL;

    /* Round 9. */
    /* Col Mix */
    b[0] = s[0] ^ s[9] ^ s[13] ^ s[17] ^ s[21];
    b[1] = s[2] ^ s[6] ^ s[10] ^ s[19] ^ s[23];
    b[2] = s[4] ^ s[8] ^ s[12] ^ s[16] ^ s[20];
    b[3] = s[1] ^ s[5] ^ s[14] ^ s[18] ^ s[22];
    b[4] = s[3] ^ s[7] ^ s[11] ^ s[15] ^ s[24];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[9]^=t; s[13]^=t; s[17]^=t; s[21]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[2]^=t; s[6]^=t; s[10]^=t; s[19]^=t; s[23]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[4]^=t; s[8]^=t; s[12]^=t; s[16]^=t; s[20]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[1]^=t; s[5]^=t; s[14]^=t; s[18]^=t; s[22]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[3]^=t; s[7]^=t; s[11]^=t; s[15]^=t; s[24]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[23], 44);
    b[2] = ROTL64(s[16], 43);
    b[3] = ROTL64(s[14], 21);
    b[4] = ROTL64(s[7], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[23] =  t12 ^ (b[2] | b[3]);
        s[16] = b[2] ^ (b[4] &  t34);
        s[14] =  t34 ^ (b[4] | b[0]);
        s[7] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[22], 28);
    b[1] = ROTL64(s[15], 20);
    b[2] = ROTL64(s[13], 3);
    b[3] = ROTL64(s[6], 45);
    b[4] = ROTL64(s[4], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[22] = b[0] ^ (b[2] &  t12);
        s[15] =  t12 ^ (b[2] | b[3]);
        s[13] = b[2] ^ (b[4] &  t34);
        s[6] =  t34 ^ (b[4] | b[0]);
        s[4] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[19], 1);
    b[1] = ROTL64(s[12], 6);
    b[2] = ROTL64(s[5], 25);
    b[3] = ROTL64(s[3], 8);
    b[4] = ROTL64(s[21], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[19] = b[0] ^ (b[2] &  t12);
        s[12] =  t12 ^ (b[2] | b[3]);
        s[5] = b[2] ^ (b[4] &  t34);
        s[3] =  t34 ^ (b[4] | b[0]);
        s[21] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[11], 27);
    b[1] = ROTL64(s[9], 36);
    b[2] = ROTL64(s[2], 10);
    b[3] = ROTL64(s[20], 15);
    b[4] = ROTL64(s[18], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[11] = b[0] ^ (b[2] &  t12);
        s[9] =  t12 ^ (b[2] | b[3]);
        s[2] = b[2] ^ (b[4] &  t34);
        s[20] =  t34 ^ (b[4] | b[0]);
        s[18] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[8], 62);
    b[1] = ROTL64(s[1], 55);
    b[2] = ROTL64(s[24], 39);
    b[3] = ROTL64(s[17], 41);
    b[4] = ROTL64(s[10], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[8] = b[0] ^ (b[2] &  t12);
        s[1] =  t12 ^ (b[2] | b[3]);
        s[24] = b[2] ^ (b[4] &  t34);
        s[17] =  t34 ^ (b[4] | b[0]);
        s[10] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x88UL;

    /* Round 10. */
    /* Col Mix */
    b[0] = s[0] ^ s[8] ^ s[11] ^ s[19] ^ s[22];
    b[1] = s[1] ^ s[9] ^ s[12] ^ s[15] ^ s[23];
    b[2] = s[2] ^ s[5] ^ s[13] ^ s[16] ^ s[24];
    b[3] = s[3] ^ s[6] ^ s[14] ^ s[17] ^ s[20];
    b[4] = s[4] ^ s[7] ^ s[10] ^ s[18] ^ s[21];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[8]^=t; s[11]^=t; s[19]^=t; s[22]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[1]^=t; s[9]^=t; s[12]^=t; s[15]^=t; s[23]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[2]^=t; s[5]^=t; s[13]^=t; s[16]^=t; s[24]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[3]^=t; s[6]^=t; s[14]^=t; s[17]^=t; s[20]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[4]^=t; s[7]^=t; s[10]^=t; s[18]^=t; s[21]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[15], 44);
    b[2] = ROTL64(s[5], 43);
    b[3] = ROTL64(s[20], 21);
    b[4] = ROTL64(s[10], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[15] =  t12 ^ (b[2] | b[3]);
        s[5] = b[2] ^ (b[4] &  t34);
        s[20] =  t34 ^ (b[4] | b[0]);
        s[10] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[14], 28);
    b[1] = ROTL64(s[4], 20);
    b[2] = ROTL64(s[19], 3);
    b[3] = ROTL64(s[9], 45);
    b[4] = ROTL64(s[24], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[14] = b[0] ^ (b[2] &  t12);
        s[4] =  t12 ^ (b[2] | b[3]);
        s[19] = b[2] ^ (b[4] &  t34);
        s[9] =  t34 ^ (b[4] | b[0]);
        s[24] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[23], 1);
    b[1] = ROTL64(s[13], 6);
    b[2] = ROTL64(s[3], 25);
    b[3] = ROTL64(s[18], 8);
    b[4] = ROTL64(s[8], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[23] = b[0] ^ (b[2] &  t12);
        s[13] =  t12 ^ (b[2] | b[3]);
        s[3] = b[2] ^ (b[4] &  t34);
        s[18] =  t34 ^ (b[4] | b[0]);
        s[8] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[7], 27);
    b[1] = ROTL64(s[22], 36);
    b[2] = ROTL64(s[12], 10);
    b[3] = ROTL64(s[2], 15);
    b[4] = ROTL64(s[17], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[7] = b[0] ^ (b[2] &  t12);
        s[22] =  t12 ^ (b[2] | b[3]);
        s[12] = b[2] ^ (b[4] &  t34);
        s[2] =  t34 ^ (b[4] | b[0]);
        s[17] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[16], 62);
    b[1] = ROTL64(s[6], 55);
    b[2] = ROTL64(s[21], 39);
    b[3] = ROTL64(s[11], 41);
    b[4] = ROTL64(s[1], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[16] = b[0] ^ (b[2] &  t12);
        s[6] =  t12 ^ (b[2] | b[3]);
        s[21] = b[2] ^ (b[4] &  t34);
        s[11] =  t34 ^ (b[4] | b[0]);
        s[1] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x80008009UL;

    /* Round 11. */
    /* Col Mix */
    b[0] = s[0] ^ s[7] ^ s[14] ^ s[16] ^ s[23];
    b[1] = s[4] ^ s[6] ^ s[13] ^ s[15] ^ s[22];
    b[2] = s[3] ^ s[5] ^ s[12] ^ s[19] ^ s[21];
    b[3] = s[2] ^ s[9] ^ s[11] ^ s[18] ^ s[20];
    b[4] = s[1] ^ s[8] ^ s[10] ^ s[17] ^ s[24];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[7]^=t; s[14]^=t; s[16]^=t; s[23]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[4]^=t; s[6]^=t; s[13]^=t; s[15]^=t; s[22]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[3]^=t; s[5]^=t; s[12]^=t; s[19]^=t; s[21]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[2]^=t; s[9]^=t; s[11]^=t; s[18]^=t; s[20]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[1]^=t; s[8]^=t; s[10]^=t; s[17]^=t; s[24]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[4], 44);
    b[2] = ROTL64(s[3], 43);
    b[3] = ROTL64(s[2], 21);
    b[4] = ROTL64(s[1], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[4] =  t12 ^ (b[2] | b[3]);
        s[3] = b[2] ^ (b[4] &  t34);
        s[2] =  t34 ^ (b[4] | b[0]);
        s[1] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[20], 28);
    b[1] = ROTL64(s[24], 20);
    b[2] = ROTL64(s[23], 3);
    b[3] = ROTL64(s[22], 45);
    b[4] = ROTL64(s[21], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[20] = b[0] ^ (b[2] &  t12);
        s[24] =  t12 ^ (b[2] | b[3]);
        s[23] = b[2] ^ (b[4] &  t34);
        s[22] =  t34 ^ (b[4] | b[0]);
        s[21] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[15], 1);
    b[1] = ROTL64(s[19], 6);
    b[2] = ROTL64(s[18], 25);
    b[3] = ROTL64(s[17], 8);
    b[4] = ROTL64(s[16], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[15] = b[0] ^ (b[2] &  t12);
        s[19] =  t12 ^ (b[2] | b[3]);
        s[18] = b[2] ^ (b[4] &  t34);
        s[17] =  t34 ^ (b[4] | b[0]);
        s[16] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[10], 27);
    b[1] = ROTL64(s[14], 36);
    b[2] = ROTL64(s[13], 10);
    b[3] = ROTL64(s[12], 15);
    b[4] = ROTL64(s[11], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[10] = b[0] ^ (b[2] &  t12);
        s[14] =  t12 ^ (b[2] | b[3]);
        s[13] = b[2] ^ (b[4] &  t34);
        s[12] =  t34 ^ (b[4] | b[0]);
        s[11] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[5], 62);
    b[1] = ROTL64(s[9], 55);
    b[2] = ROTL64(s[8], 39);
    b[3] = ROTL64(s[7], 41);
    b[4] = ROTL64(s[6], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[5] = b[0] ^ (b[2] &  t12);
        s[9] =  t12 ^ (b[2] | b[3]);
        s[8] = b[2] ^ (b[4] &  t34);
        s[7] =  t34 ^ (b[4] | b[0]);
        s[6] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x8000000aUL;

    /* Round 12. */
    /* Col Mix */
    b[0] = s[0] ^ s[5] ^ s[10] ^ s[15] ^ s[20];
    b[1] = s[4] ^ s[9] ^ s[14] ^ s[19] ^ s[24];
    b[2] = s[3] ^ s[8] ^ s[13] ^ s[18] ^ s[23];
    b[3] = s[2] ^ s[7] ^ s[12] ^ s[17] ^ s[22];
    b[4] = s[1] ^ s[6] ^ s[11] ^ s[16] ^ s[21];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[5]^=t; s[10]^=t; s[15]^=t; s[20]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[4]^=t; s[9]^=t; s[14]^=t; s[19]^=t; s[24]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[3]^=t; s[8]^=t; s[13]^=t; s[18]^=t; s[23]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[2]^=t; s[7]^=t; s[12]^=t; s[17]^=t; s[22]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[1]^=t; s[6]^=t; s[11]^=t; s[16]^=t; s[21]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[24], 44);
    b[2] = ROTL64(s[18], 43);
    b[3] = ROTL64(s[12], 21);
    b[4] = ROTL64(s[6], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[24] =  t12 ^ (b[2] | b[3]);
        s[18] = b[2] ^ (b[4] &  t34);
        s[12] =  t34 ^ (b[4] | b[0]);
        s[6] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[2], 28);
    b[1] = ROTL64(s[21], 20);
    b[2] = ROTL64(s[15], 3);
    b[3] = ROTL64(s[14], 45);
    b[4] = ROTL64(s[8], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[2] = b[0] ^ (b[2] &  t12);
        s[21] =  t12 ^ (b[2] | b[3]);
        s[15] = b[2] ^ (b[4] &  t34);
        s[14] =  t34 ^ (b[4] | b[0]);
        s[8] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[4], 1);
    b[1] = ROTL64(s[23], 6);
    b[2] = ROTL64(s[17], 25);
    b[3] = ROTL64(s[11], 8);
    b[4] = ROTL64(s[5], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[4] = b[0] ^ (b[2] &  t12);
        s[23] =  t12 ^ (b[2] | b[3]);
        s[17] = b[2] ^ (b[4] &  t34);
        s[11] =  t34 ^ (b[4] | b[0]);
        s[5] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[1], 27);
    b[1] = ROTL64(s[20], 36);
    b[2] = ROTL64(s[19], 10);
    b[3] = ROTL64(s[13], 15);
    b[4] = ROTL64(s[7], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[1] = b[0] ^ (b[2] &  t12);
        s[20] =  t12 ^ (b[2] | b[3]);
        s[19] = b[2] ^ (b[4] &  t34);
        s[13] =  t34 ^ (b[4] | b[0]);
        s[7] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[3], 62);
    b[1] = ROTL64(s[22], 55);
    b[2] = ROTL64(s[16], 39);
    b[3] = ROTL64(s[10], 41);
    b[4] = ROTL64(s[9], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[3] = b[0] ^ (b[2] &  t12);
        s[22] =  t12 ^ (b[2] | b[3]);
        s[16] = b[2] ^ (b[4] &  t34);
        s[10] =  t34 ^ (b[4] | b[0]);
        s[9] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x8000808bUL;

    /* Round 13. */
    /* Col Mix */
    b[0] = s[0] ^ s[1] ^ s[2] ^ s[3] ^ s[4];
    b[1] = s[20] ^ s[21] ^ s[22] ^ s[23] ^ s[24];
    b[2] = s[15] ^ s[16] ^ s[17] ^ s[18] ^ s[19];
    b[3] = s[10] ^ s[11] ^ s[12] ^ s[13] ^ s[14];
    b[4] = s[5] ^ s[6] ^ s[7] ^ s[8] ^ s[9];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[1]^=t; s[2]^=t; s[3]^=t; s[4]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[20]^=t; s[21]^=t; s[22]^=t; s[23]^=t; s[24]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[15]^=t; s[16]^=t; s[17]^=t; s[18]^=t; s[19]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[10]^=t; s[11]^=t; s[12]^=t; s[13]^=t; s[14]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[5]^=t; s[6]^=t; s[7]^=t; s[8]^=t; s[9]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[21], 44);
    b[2] = ROTL64(s[17], 43);
    b[3] = ROTL64(s[13], 21);
    b[4] = ROTL64(s[9], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[21] =  t12 ^ (b[2] | b[3]);
        s[17] = b[2] ^ (b[4] &  t34);
        s[13] =  t34 ^ (b[4] | b[0]);
        s[9] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[12], 28);
    b[1] = ROTL64(s[8], 20);
    b[2] = ROTL64(s[4], 3);
    b[3] = ROTL64(s[20], 45);
    b[4] = ROTL64(s[16], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[12] = b[0] ^ (b[2] &  t12);
        s[8] =  t12 ^ (b[2] | b[3]);
        s[4] = b[2] ^ (b[4] &  t34);
        s[20] =  t34 ^ (b[4] | b[0]);
        s[16] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[24], 1);
    b[1] = ROTL64(s[15], 6);
    b[2] = ROTL64(s[11], 25);
    b[3] = ROTL64(s[7], 8);
    b[4] = ROTL64(s[3], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[24] = b[0] ^ (b[2] &  t12);
        s[15] =  t12 ^ (b[2] | b[3]);
        s[11] = b[2] ^ (b[4] &  t34);
        s[7] =  t34 ^ (b[4] | b[0]);
        s[3] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[6], 27);
    b[1] = ROTL64(s[2], 36);
    b[2] = ROTL64(s[23], 10);
    b[3] = ROTL64(s[19], 15);
    b[4] = ROTL64(s[10], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[6] = b[0] ^ (b[2] &  t12);
        s[2] =  t12 ^ (b[2] | b[3]);
        s[23] = b[2] ^ (b[4] &  t34);
        s[19] =  t34 ^ (b[4] | b[0]);
        s[10] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[18], 62);
    b[1] = ROTL64(s[14], 55);
    b[2] = ROTL64(s[5], 39);
    b[3] = ROTL64(s[1], 41);
    b[4] = ROTL64(s[22], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[18] = b[0] ^ (b[2] &  t12);
        s[14] =  t12 ^ (b[2] | b[3]);
        s[5] = b[2] ^ (b[4] &  t34);
        s[1] =  t34 ^ (b[4] | b[0]);
        s[22] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x800000000000008bUL;

    /* Round 14. */
    /* Col Mix */
    b[0] = s[0] ^ s[6] ^ s[12] ^ s[18] ^ s[24];
    b[1] = s[2] ^ s[8] ^ s[14] ^ s[15] ^ s[21];
    b[2] = s[4] ^ s[5] ^ s[11] ^ s[17] ^ s[23];
    b[3] = s[1] ^ s[7] ^ s[13] ^ s[19] ^ s[20];
    b[4] = s[3] ^ s[9] ^ s[10] ^ s[16] ^ s[22];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[6]^=t; s[12]^=t; s[18]^=t; s[24]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[2]^=t; s[8]^=t; s[14]^=t; s[15]^=t; s[21]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[4]^=t; s[5]^=t; s[11]^=t; s[17]^=t; s[23]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[1]^=t; s[7]^=t; s[13]^=t; s[19]^=t; s[20]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[3]^=t; s[9]^=t; s[10]^=t; s[16]^=t; s[22]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[8], 44);
    b[2] = ROTL64(s[11], 43);
    b[3] = ROTL64(s[19], 21);
    b[4] = ROTL64(s[22], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[8] =  t12 ^ (b[2] | b[3]);
        s[11] = b[2] ^ (b[4] &  t34);
        s[19] =  t34 ^ (b[4] | b[0]);
        s[22] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[13], 28);
    b[1] = ROTL64(s[16], 20);
    b[2] = ROTL64(s[24], 3);
    b[3] = ROTL64(s[2], 45);
    b[4] = ROTL64(s[5], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[13] = b[0] ^ (b[2] &  t12);
        s[16] =  t12 ^ (b[2] | b[3]);
        s[24] = b[2] ^ (b[4] &  t34);
        s[2] =  t34 ^ (b[4] | b[0]);
        s[5] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[21], 1);
    b[1] = ROTL64(s[4], 6);
    b[2] = ROTL64(s[7], 25);
    b[3] = ROTL64(s[10], 8);
    b[4] = ROTL64(s[18], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[21] = b[0] ^ (b[2] &  t12);
        s[4] =  t12 ^ (b[2] | b[3]);
        s[7] = b[2] ^ (b[4] &  t34);
        s[10] =  t34 ^ (b[4] | b[0]);
        s[18] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[9], 27);
    b[1] = ROTL64(s[12], 36);
    b[2] = ROTL64(s[15], 10);
    b[3] = ROTL64(s[23], 15);
    b[4] = ROTL64(s[1], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[9] = b[0] ^ (b[2] &  t12);
        s[12] =  t12 ^ (b[2] | b[3]);
        s[15] = b[2] ^ (b[4] &  t34);
        s[23] =  t34 ^ (b[4] | b[0]);
        s[1] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[17], 62);
    b[1] = ROTL64(s[20], 55);
    b[2] = ROTL64(s[3], 39);
    b[3] = ROTL64(s[6], 41);
    b[4] = ROTL64(s[14], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[17] = b[0] ^ (b[2] &  t12);
        s[20] =  t12 ^ (b[2] | b[3]);
        s[3] = b[2] ^ (b[4] &  t34);
        s[6] =  t34 ^ (b[4] | b[0]);
        s[14] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x8000000000008089UL;

    /* Round 15. */
    /* Col Mix */
    b[0] = s[0] ^ s[9] ^ s[13] ^ s[17] ^ s[21];
    b[1] = s[4] ^ s[8] ^ s[12] ^ s[16] ^ s[20];
    b[2] = s[3] ^ s[7] ^ s[11] ^ s[15] ^ s[24];
    b[3] = s[2] ^ s[6] ^ s[10] ^ s[19] ^ s[23];
    b[4] = s[1] ^ s[5] ^ s[14] ^ s[18] ^ s[22];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[9]^=t; s[13]^=t; s[17]^=t; s[21]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[4]^=t; s[8]^=t; s[12]^=t; s[16]^=t; s[20]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[3]^=t; s[7]^=t; s[11]^=t; s[15]^=t; s[24]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[2]^=t; s[6]^=t; s[10]^=t; s[19]^=t; s[23]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[1]^=t; s[5]^=t; s[14]^=t; s[18]^=t; s[22]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[16], 44);
    b[2] = ROTL64(s[7], 43);
    b[3] = ROTL64(s[23], 21);
    b[4] = ROTL64(s[14], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[16] =  t12 ^ (b[2] | b[3]);
        s[7] = b[2] ^ (b[4] &  t34);
        s[23] =  t34 ^ (b[4] | b[0]);
        s[14] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[19], 28);
    b[1] = ROTL64(s[5], 20);
    b[2] = ROTL64(s[21], 3);
    b[3] = ROTL64(s[12], 45);
    b[4] = ROTL64(s[3], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[19] = b[0] ^ (b[2] &  t12);
        s[5] =  t12 ^ (b[2] | b[3]);
        s[21] = b[2] ^ (b[4] &  t34);
        s[12] =  t34 ^ (b[4] | b[0]);
        s[3] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[8], 1);
    b[1] = ROTL64(s[24], 6);
    b[2] = ROTL64(s[10], 25);
    b[3] = ROTL64(s[1], 8);
    b[4] = ROTL64(s[17], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[8] = b[0] ^ (b[2] &  t12);
        s[24] =  t12 ^ (b[2] | b[3]);
        s[10] = b[2] ^ (b[4] &  t34);
        s[1] =  t34 ^ (b[4] | b[0]);
        s[17] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[22], 27);
    b[1] = ROTL64(s[13], 36);
    b[2] = ROTL64(s[4], 10);
    b[3] = ROTL64(s[15], 15);
    b[4] = ROTL64(s[6], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[22] = b[0] ^ (b[2] &  t12);
        s[13] =  t12 ^ (b[2] | b[3]);
        s[4] = b[2] ^ (b[4] &  t34);
        s[15] =  t34 ^ (b[4] | b[0]);
        s[6] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[11], 62);
    b[1] = ROTL64(s[2], 55);
    b[2] = ROTL64(s[18], 39);
    b[3] = ROTL64(s[9], 41);
    b[4] = ROTL64(s[20], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[11] = b[0] ^ (b[2] &  t12);
        s[2] =  t12 ^ (b[2] | b[3]);
        s[18] = b[2] ^ (b[4] &  t34);
        s[9] =  t34 ^ (b[4] | b[0]);
        s[20] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x8000000000008003UL;

    /* Round 16. */
    /* Col Mix */
    b[0] = s[0] ^ s[8] ^ s[11] ^ s[19] ^ s[22];
    b[1] = s[2] ^ s[5] ^ s[13] ^ s[16] ^ s[24];
    b[2] = s[4] ^ s[7] ^ s[10] ^ s[18] ^ s[21];
    b[3] = s[1] ^ s[9] ^ s[12] ^ s[15] ^ s[23];
    b[4] = s[3] ^ s[6] ^ s[14] ^ s[17] ^ s[20];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[8]^=t; s[11]^=t; s[19]^=t; s[22]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[2]^=t; s[5]^=t; s[13]^=t; s[16]^=t; s[24]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[4]^=t; s[7]^=t; s[10]^=t; s[18]^=t; s[21]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[1]^=t; s[9]^=t; s[12]^=t; s[15]^=t; s[23]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[3]^=t; s[6]^=t; s[14]^=t; s[17]^=t; s[20]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[5], 44);
    b[2] = ROTL64(s[10], 43);
    b[3] = ROTL64(s[15], 21);
    b[4] = ROTL64(s[20], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[5] =  t12 ^ (b[2] | b[3]);
        s[10] = b[2] ^ (b[4] &  t34);
        s[15] =  t34 ^ (b[4] | b[0]);
        s[20] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[23], 28);
    b[1] = ROTL64(s[3], 20);
    b[2] = ROTL64(s[8], 3);
    b[3] = ROTL64(s[13], 45);
    b[4] = ROTL64(s[18], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[23] = b[0] ^ (b[2] &  t12);
        s[3] =  t12 ^ (b[2] | b[3]);
        s[8] = b[2] ^ (b[4] &  t34);
        s[13] =  t34 ^ (b[4] | b[0]);
        s[18] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[16], 1);
    b[1] = ROTL64(s[21], 6);
    b[2] = ROTL64(s[1], 25);
    b[3] = ROTL64(s[6], 8);
    b[4] = ROTL64(s[11], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[16] = b[0] ^ (b[2] &  t12);
        s[21] =  t12 ^ (b[2] | b[3]);
        s[1] = b[2] ^ (b[4] &  t34);
        s[6] =  t34 ^ (b[4] | b[0]);
        s[11] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[14], 27);
    b[1] = ROTL64(s[19], 36);
    b[2] = ROTL64(s[24], 10);
    b[3] = ROTL64(s[4], 15);
    b[4] = ROTL64(s[9], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[14] = b[0] ^ (b[2] &  t12);
        s[19] =  t12 ^ (b[2] | b[3]);
        s[24] = b[2] ^ (b[4] &  t34);
        s[4] =  t34 ^ (b[4] | b[0]);
        s[9] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[7], 62);
    b[1] = ROTL64(s[12], 55);
    b[2] = ROTL64(s[17], 39);
    b[3] = ROTL64(s[22], 41);
    b[4] = ROTL64(s[2], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[7] = b[0] ^ (b[2] &  t12);
        s[12] =  t12 ^ (b[2] | b[3]);
        s[17] = b[2] ^ (b[4] &  t34);
        s[22] =  t34 ^ (b[4] | b[0]);
        s[2] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x8000000000008002UL;

    /* Round 17. */
    /* Col Mix */
    b[0] = s[0] ^ s[7] ^ s[14] ^ s[16] ^ s[23];
    b[1] = s[3] ^ s[5] ^ s[12] ^ s[19] ^ s[21];
    b[2] = s[1] ^ s[8] ^ s[10] ^ s[17] ^ s[24];
    b[3] = s[4] ^ s[6] ^ s[13] ^ s[15] ^ s[22];
    b[4] = s[2] ^ s[9] ^ s[11] ^ s[18] ^ s[20];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[7]^=t; s[14]^=t; s[16]^=t; s[23]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[3]^=t; s[5]^=t; s[12]^=t; s[19]^=t; s[21]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[1]^=t; s[8]^=t; s[10]^=t; s[17]^=t; s[24]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[4]^=t; s[6]^=t; s[13]^=t; s[15]^=t; s[22]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[2]^=t; s[9]^=t; s[11]^=t; s[18]^=t; s[20]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[3], 44);
    b[2] = ROTL64(s[1], 43);
    b[3] = ROTL64(s[4], 21);
    b[4] = ROTL64(s[2], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[3] =  t12 ^ (b[2] | b[3]);
        s[1] = b[2] ^ (b[4] &  t34);
        s[4] =  t34 ^ (b[4] | b[0]);
        s[2] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[15], 28);
    b[1] = ROTL64(s[18], 20);
    b[2] = ROTL64(s[16], 3);
    b[3] = ROTL64(s[19], 45);
    b[4] = ROTL64(s[17], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[15] = b[0] ^ (b[2] &  t12);
        s[18] =  t12 ^ (b[2] | b[3]);
        s[16] = b[2] ^ (b[4] &  t34);
        s[19] =  t34 ^ (b[4] | b[0]);
        s[17] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[5], 1);
    b[1] = ROTL64(s[8], 6);
    b[2] = ROTL64(s[6], 25);
    b[3] = ROTL64(s[9], 8);
    b[4] = ROTL64(s[7], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[5] = b[0] ^ (b[2] &  t12);
        s[8] =  t12 ^ (b[2] | b[3]);
        s[6] = b[2] ^ (b[4] &  t34);
        s[9] =  t34 ^ (b[4] | b[0]);
        s[7] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[20], 27);
    b[1] = ROTL64(s[23], 36);
    b[2] = ROTL64(s[21], 10);
    b[3] = ROTL64(s[24], 15);
    b[4] = ROTL64(s[22], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[20] = b[0] ^ (b[2] &  t12);
        s[23] =  t12 ^ (b[2] | b[3]);
        s[21] = b[2] ^ (b[4] &  t34);
        s[24] =  t34 ^ (b[4] | b[0]);
        s[22] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[10], 62);
    b[1] = ROTL64(s[13], 55);
    b[2] = ROTL64(s[11], 39);
    b[3] = ROTL64(s[14], 41);
    b[4] = ROTL64(s[12], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[10] = b[0] ^ (b[2] &  t12);
        s[13] =  t12 ^ (b[2] | b[3]);
        s[11] = b[2] ^ (b[4] &  t34);
        s[14] =  t34 ^ (b[4] | b[0]);
        s[12] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x8000000000000080UL;

    /* Round 18. */
    /* Col Mix */
    b[0] = s[0] ^ s[5] ^ s[10] ^ s[15] ^ s[20];
    b[1] = s[3] ^ s[8] ^ s[13] ^ s[18] ^ s[23];
    b[2] = s[1] ^ s[6] ^ s[11] ^ s[16] ^ s[21];
    b[3] = s[4] ^ s[9] ^ s[14] ^ s[19] ^ s[24];
    b[4] = s[2] ^ s[7] ^ s[12] ^ s[17] ^ s[22];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[5]^=t; s[10]^=t; s[15]^=t; s[20]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[3]^=t; s[8]^=t; s[13]^=t; s[18]^=t; s[23]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[1]^=t; s[6]^=t; s[11]^=t; s[16]^=t; s[21]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[4]^=t; s[9]^=t; s[14]^=t; s[19]^=t; s[24]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[2]^=t; s[7]^=t; s[12]^=t; s[17]^=t; s[22]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[18], 44);
    b[2] = ROTL64(s[6], 43);
    b[3] = ROTL64(s[24], 21);
    b[4] = ROTL64(s[12], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[18] =  t12 ^ (b[2] | b[3]);
        s[6] = b[2] ^ (b[4] &  t34);
        s[24] =  t34 ^ (b[4] | b[0]);
        s[12] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[4], 28);
    b[1] = ROTL64(s[17], 20);
    b[2] = ROTL64(s[5], 3);
    b[3] = ROTL64(s[23], 45);
    b[4] = ROTL64(s[11], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[4] = b[0] ^ (b[2] &  t12);
        s[17] =  t12 ^ (b[2] | b[3]);
        s[5] = b[2] ^ (b[4] &  t34);
        s[23] =  t34 ^ (b[4] | b[0]);
        s[11] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[3], 1);
    b[1] = ROTL64(s[16], 6);
    b[2] = ROTL64(s[9], 25);
    b[3] = ROTL64(s[22], 8);
    b[4] = ROTL64(s[10], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[3] = b[0] ^ (b[2] &  t12);
        s[16] =  t12 ^ (b[2] | b[3]);
        s[9] = b[2] ^ (b[4] &  t34);
        s[22] =  t34 ^ (b[4] | b[0]);
        s[10] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[2], 27);
    b[1] = ROTL64(s[15], 36);
    b[2] = ROTL64(s[8], 10);
    b[3] = ROTL64(s[21], 15);
    b[4] = ROTL64(s[14], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[2] = b[0] ^ (b[2] &  t12);
        s[15] =  t12 ^ (b[2] | b[3]);
        s[8] = b[2] ^ (b[4] &  t34);
        s[21] =  t34 ^ (b[4] | b[0]);
        s[14] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[1], 62);
    b[1] = ROTL64(s[19], 55);
    b[2] = ROTL64(s[7], 39);
    b[3] = ROTL64(s[20], 41);
    b[4] = ROTL64(s[13], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[1] = b[0] ^ (b[2] &  t12);
        s[19] =  t12 ^ (b[2] | b[3]);
        s[7] = b[2] ^ (b[4] &  t34);
        s[20] =  t34 ^ (b[4] | b[0]);
        s[13] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x800aUL;

    /* Round 19. */
    /* Col Mix */
    b[0] = s[0] ^ s[1] ^ s[2] ^ s[3] ^ s[4];
    b[1] = s[15] ^ s[16] ^ s[17] ^ s[18] ^ s[19];
    b[2] = s[5] ^ s[6] ^ s[7] ^ s[8] ^ s[9];
    b[3] = s[20] ^ s[21] ^ s[22] ^ s[23] ^ s[24];
    b[4] = s[10] ^ s[11] ^ s[12] ^ s[13] ^ s[14];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[1]^=t; s[2]^=t; s[3]^=t; s[4]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[15]^=t; s[16]^=t; s[17]^=t; s[18]^=t; s[19]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[5]^=t; s[6]^=t; s[7]^=t; s[8]^=t; s[9]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[20]^=t; s[21]^=t; s[22]^=t; s[23]^=t; s[24]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[10]^=t; s[11]^=t; s[12]^=t; s[13]^=t; s[14]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[17], 44);
    b[2] = ROTL64(s[9], 43);
    b[3] = ROTL64(s[21], 21);
    b[4] = ROTL64(s[13], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[17] =  t12 ^ (b[2] | b[3]);
        s[9] = b[2] ^ (b[4] &  t34);
        s[21] =  t34 ^ (b[4] | b[0]);
        s[13] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[24], 28);
    b[1] = ROTL64(s[11], 20);
    b[2] = ROTL64(s[3], 3);
    b[3] = ROTL64(s[15], 45);
    b[4] = ROTL64(s[7], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[24] = b[0] ^ (b[2] &  t12);
        s[11] =  t12 ^ (b[2] | b[3]);
        s[3] = b[2] ^ (b[4] &  t34);
        s[15] =  t34 ^ (b[4] | b[0]);
        s[7] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[18], 1);
    b[1] = ROTL64(s[5], 6);
    b[2] = ROTL64(s[22], 25);
    b[3] = ROTL64(s[14], 8);
    b[4] = ROTL64(s[1], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[18] = b[0] ^ (b[2] &  t12);
        s[5] =  t12 ^ (b[2] | b[3]);
        s[22] = b[2] ^ (b[4] &  t34);
        s[14] =  t34 ^ (b[4] | b[0]);
        s[1] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[12], 27);
    b[1] = ROTL64(s[4], 36);
    b[2] = ROTL64(s[16], 10);
    b[3] = ROTL64(s[8], 15);
    b[4] = ROTL64(s[20], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[12] = b[0] ^ (b[2] &  t12);
        s[4] =  t12 ^ (b[2] | b[3]);
        s[16] = b[2] ^ (b[4] &  t34);
        s[8] =  t34 ^ (b[4] | b[0]);
        s[20] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[6], 62);
    b[1] = ROTL64(s[23], 55);
    b[2] = ROTL64(s[10], 39);
    b[3] = ROTL64(s[2], 41);
    b[4] = ROTL64(s[19], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[6] = b[0] ^ (b[2] &  t12);
        s[23] =  t12 ^ (b[2] | b[3]);
        s[10] = b[2] ^ (b[4] &  t34);
        s[2] =  t34 ^ (b[4] | b[0]);
        s[19] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x800000008000000aUL;

    /* Round 20. */
    /* Col Mix */
    b[0] = s[0] ^ s[6] ^ s[12] ^ s[18] ^ s[24];
    b[1] = s[4] ^ s[5] ^ s[11] ^ s[17] ^ s[23];
    b[2] = s[3] ^ s[9] ^ s[10] ^ s[16] ^ s[22];
    b[3] = s[2] ^ s[8] ^ s[14] ^ s[15] ^ s[21];
    b[4] = s[1] ^ s[7] ^ s[13] ^ s[19] ^ s[20];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[6]^=t; s[12]^=t; s[18]^=t; s[24]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[4]^=t; s[5]^=t; s[11]^=t; s[17]^=t; s[23]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[3]^=t; s[9]^=t; s[10]^=t; s[16]^=t; s[22]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[2]^=t; s[8]^=t; s[14]^=t; s[15]^=t; s[21]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[1]^=t; s[7]^=t; s[13]^=t; s[19]^=t; s[20]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[11], 44);
    b[2] = ROTL64(s[22], 43);
    b[3] = ROTL64(s[8], 21);
    b[4] = ROTL64(s[19], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[11] =  t12 ^ (b[2] | b[3]);
        s[22] = b[2] ^ (b[4] &  t34);
        s[8] =  t34 ^ (b[4] | b[0]);
        s[19] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[21], 28);
    b[1] = ROTL64(s[7], 20);
    b[2] = ROTL64(s[18], 3);
    b[3] = ROTL64(s[4], 45);
    b[4] = ROTL64(s[10], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[21] = b[0] ^ (b[2] &  t12);
        s[7] =  t12 ^ (b[2] | b[3]);
        s[18] = b[2] ^ (b[4] &  t34);
        s[4] =  t34 ^ (b[4] | b[0]);
        s[10] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[17], 1);
    b[1] = ROTL64(s[3], 6);
    b[2] = ROTL64(s[14], 25);
    b[3] = ROTL64(s[20], 8);
    b[4] = ROTL64(s[6], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[17] = b[0] ^ (b[2] &  t12);
        s[3] =  t12 ^ (b[2] | b[3]);
        s[14] = b[2] ^ (b[4] &  t34);
        s[20] =  t34 ^ (b[4] | b[0]);
        s[6] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[13], 27);
    b[1] = ROTL64(s[24], 36);
    b[2] = ROTL64(s[5], 10);
    b[3] = ROTL64(s[16], 15);
    b[4] = ROTL64(s[2], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[13] = b[0] ^ (b[2] &  t12);
        s[24] =  t12 ^ (b[2] | b[3]);
        s[5] = b[2] ^ (b[4] &  t34);
        s[16] =  t34 ^ (b[4] | b[0]);
        s[2] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[9], 62);
    b[1] = ROTL64(s[15], 55);
    b[2] = ROTL64(s[1], 39);
    b[3] = ROTL64(s[12], 41);
    b[4] = ROTL64(s[23], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[9] = b[0] ^ (b[2] &  t12);
        s[15] =  t12 ^ (b[2] | b[3]);
        s[1] = b[2] ^ (b[4] &  t34);
        s[12] =  t34 ^ (b[4] | b[0]);
        s[23] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x8000000080008081UL;

    /* Round 21. */
    /* Col Mix */
    b[0] = s[0] ^ s[9] ^ s[13] ^ s[17] ^ s[21];
    b[1] = s[3] ^ s[7] ^ s[11] ^ s[15] ^ s[24];
    b[2] = s[1] ^ s[5] ^ s[14] ^ s[18] ^ s[22];
    b[3] = s[4] ^ s[8] ^ s[12] ^ s[16] ^ s[20];
    b[4] = s[2] ^ s[6] ^ s[10] ^ s[19] ^ s[23];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[9]^=t; s[13]^=t; s[17]^=t; s[21]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[3]^=t; s[7]^=t; s[11]^=t; s[15]^=t; s[24]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[1]^=t; s[5]^=t; s[14]^=t; s[18]^=t; s[22]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[4]^=t; s[8]^=t; s[12]^=t; s[16]^=t; s[20]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[2]^=t; s[6]^=t; s[10]^=t; s[19]^=t; s[23]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[7], 44);
    b[2] = ROTL64(s[14], 43);
    b[3] = ROTL64(s[16], 21);
    b[4] = ROTL64(s[23], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[7] =  t12 ^ (b[2] | b[3]);
        s[14] = b[2] ^ (b[4] &  t34);
        s[16] =  t34 ^ (b[4] | b[0]);
        s[23] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[8], 28);
    b[1] = ROTL64(s[10], 20);
    b[2] = ROTL64(s[17], 3);
    b[3] = ROTL64(s[24], 45);
    b[4] = ROTL64(s[1], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[8] = b[0] ^ (b[2] &  t12);
        s[10] =  t12 ^ (b[2] | b[3]);
        s[17] = b[2] ^ (b[4] &  t34);
        s[24] =  t34 ^ (b[4] | b[0]);
        s[1] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[11], 1);
    b[1] = ROTL64(s[18], 6);
    b[2] = ROTL64(s[20], 25);
    b[3] = ROTL64(s[2], 8);
    b[4] = ROTL64(s[9], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[11] = b[0] ^ (b[2] &  t12);
        s[18] =  t12 ^ (b[2] | b[3]);
        s[20] = b[2] ^ (b[4] &  t34);
        s[2] =  t34 ^ (b[4] | b[0]);
        s[9] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[19], 27);
    b[1] = ROTL64(s[21], 36);
    b[2] = ROTL64(s[3], 10);
    b[3] = ROTL64(s[5], 15);
    b[4] = ROTL64(s[12], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[19] = b[0] ^ (b[2] &  t12);
        s[21] =  t12 ^ (b[2] | b[3]);
        s[3] = b[2] ^ (b[4] &  t34);
        s[5] =  t34 ^ (b[4] | b[0]);
        s[12] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[22], 62);
    b[1] = ROTL64(s[4], 55);
    b[2] = ROTL64(s[6], 39);
    b[3] = ROTL64(s[13], 41);
    b[4] = ROTL64(s[15], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[22] = b[0] ^ (b[2] &  t12);
        s[4] =  t12 ^ (b[2] | b[3]);
        s[6] = b[2] ^ (b[4] &  t34);
        s[13] =  t34 ^ (b[4] | b[0]);
        s[15] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x8000000000008080UL;

    /* Round 22. */
    /* Col Mix */
    b[0] = s[0] ^ s[8] ^ s[11] ^ s[19] ^ s[22];
    b[1] = s[4] ^ s[7] ^ s[10] ^ s[18] ^ s[21];
    b[2] = s[3] ^ s[6] ^ s[14] ^ s[17] ^ s[20];
    b[3] = s[2] ^ s[5] ^ s[13] ^ s[16] ^ s[24];
    b[4] = s[1] ^ s[9] ^ s[12] ^ s[15] ^ s[23];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[8]^=t; s[11]^=t; s[19]^=t; s[22]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[4]^=t; s[7]^=t; s[10]^=t; s[18]^=t; s[21]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[3]^=t; s[6]^=t; s[14]^=t; s[17]^=t; s[20]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[2]^=t; s[5]^=t; s[13]^=t; s[16]^=t; s[24]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[1]^=t; s[9]^=t; s[12]^=t; s[15]^=t; s[23]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[10], 44);
    b[2] = ROTL64(s[20], 43);
    b[3] = ROTL64(s[5], 21);
    b[4] = ROTL64(s[15], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[10] =  t12 ^ (b[2] | b[3]);
        s[20] = b[2] ^ (b[4] &  t34);
        s[5] =  t34 ^ (b[4] | b[0]);
        s[15] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[16], 28);
    b[1] = ROTL64(s[1], 20);
    b[2] = ROTL64(s[11], 3);
    b[3] = ROTL64(s[21], 45);
    b[4] = ROTL64(s[6], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[16] = b[0] ^ (b[2] &  t12);
        s[1] =  t12 ^ (b[2] | b[3]);
        s[11] = b[2] ^ (b[4] &  t34);
        s[21] =  t34 ^ (b[4] | b[0]);
        s[6] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[7], 1);
    b[1] = ROTL64(s[17], 6);
    b[2] = ROTL64(s[2], 25);
    b[3] = ROTL64(s[12], 8);
    b[4] = ROTL64(s[22], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[7] = b[0] ^ (b[2] &  t12);
        s[17] =  t12 ^ (b[2] | b[3]);
        s[2] = b[2] ^ (b[4] &  t34);
        s[12] =  t34 ^ (b[4] | b[0]);
        s[22] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[23], 27);
    b[1] = ROTL64(s[8], 36);
    b[2] = ROTL64(s[18], 10);
    b[3] = ROTL64(s[3], 15);
    b[4] = ROTL64(s[13], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[23] = b[0] ^ (b[2] &  t12);
        s[8] =  t12 ^ (b[2] | b[3]);
        s[18] = b[2] ^ (b[4] &  t34);
        s[3] =  t34 ^ (b[4] | b[0]);
        s[13] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[14], 62);
    b[1] = ROTL64(s[24], 55);
    b[2] = ROTL64(s[9], 39);
    b[3] = ROTL64(s[19], 41);
    b[4] = ROTL64(s[4], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[14] = b[0] ^ (b[2] &  t12);
        s[24] =  t12 ^ (b[2] | b[3]);
        s[9] = b[2] ^ (b[4] &  t34);
        s[19] =  t34 ^ (b[4] | b[0]);
        s[4] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x80000001UL;

    /* Round 23. */
    /* Col Mix */
    b[0] = s[0] ^ s[7] ^ s[14] ^ s[16] ^ s[23];
    b[1] = s[1] ^ s[8] ^ s[10] ^ s[17] ^ s[24];
    b[2] = s[2] ^ s[9] ^ s[11] ^ s[18] ^ s[20];
    b[3] = s[3] ^ s[5] ^ s[12] ^ s[19] ^ s[21];
    b[4] = s[4] ^ s[6] ^ s[13] ^ s[15] ^ s[22];
    t = b[4] ^ ROTL64(b[1], 1);
    s[0]^=t; s[7]^=t; s[14]^=t; s[16]^=t; s[23]^=t;
    t = b[0] ^ ROTL64(b[2], 1);
    s[1]^=t; s[8]^=t; s[10]^=t; s[17]^=t; s[24]^=t;
    t = b[1] ^ ROTL64(b[3], 1);
    s[2]^=t; s[9]^=t; s[11]^=t; s[18]^=t; s[20]^=t;
    t = b[2] ^ ROTL64(b[4], 1);
    s[3]^=t; s[5]^=t; s[12]^=t; s[19]^=t; s[21]^=t;
    t = b[3] ^ ROTL64(b[0], 1);
    s[4]^=t; s[6]^=t; s[13]^=t; s[15]^=t; s[22]^=t;
    /* Row Mix */
    b[0] = s[0];
    b[1] = ROTL64(s[1], 44);
    b[2] = ROTL64(s[2], 43);
    b[3] = ROTL64(s[3], 21);
    b[4] = ROTL64(s[4], 14);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[0] = b[0] ^ (b[2] &  t12);
        s[1] =  t12 ^ (b[2] | b[3]);
        s[2] = b[2] ^ (b[4] &  t34);
        s[3] =  t34 ^ (b[4] | b[0]);
        s[4] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[5], 28);
    b[1] = ROTL64(s[6], 20);
    b[2] = ROTL64(s[7], 3);
    b[3] = ROTL64(s[8], 45);
    b[4] = ROTL64(s[9], 61);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[5] = b[0] ^ (b[2] &  t12);
        s[6] =  t12 ^ (b[2] | b[3]);
        s[7] = b[2] ^ (b[4] &  t34);
        s[8] =  t34 ^ (b[4] | b[0]);
        s[9] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[10], 1);
    b[1] = ROTL64(s[11], 6);
    b[2] = ROTL64(s[12], 25);
    b[3] = ROTL64(s[13], 8);
    b[4] = ROTL64(s[14], 18);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[10] = b[0] ^ (b[2] &  t12);
        s[11] =  t12 ^ (b[2] | b[3]);
        s[12] = b[2] ^ (b[4] &  t34);
        s[13] =  t34 ^ (b[4] | b[0]);
        s[14] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[15], 27);
    b[1] = ROTL64(s[16], 36);
    b[2] = ROTL64(s[17], 10);
    b[3] = ROTL64(s[18], 15);
    b[4] = ROTL64(s[19], 56);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[15] = b[0] ^ (b[2] &  t12);
        s[16] =  t12 ^ (b[2] | b[3]);
        s[17] = b[2] ^ (b[4] &  t34);
        s[18] =  t34 ^ (b[4] | b[0]);
        s[19] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    b[0] = ROTL64(s[20], 62);
    b[1] = ROTL64(s[21], 55);
    b[2] = ROTL64(s[22], 39);
    b[3] = ROTL64(s[23], 41);
    b[4] = ROTL64(s[24], 2);
    {
        word64 t12, t34;

        t12 = (b[1] ^ b[2]); t34 = (b[3] ^ b[4]);
        s[20] = b[0] ^ (b[2] &  t12);
        s[21] =  t12 ^ (b[2] | b[3]);
        s[22] = b[2] ^ (b[4] &  t34);
        s[23] =  t34 ^ (b[4] | b[0]);
        s[24] = b[4] ^ (b[1] & (b[0] ^ b[1]));
    }
    /* XOR in constant. */
    s[0] ^= 0x8000000080008008UL;
}

