/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JEnumType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.elementparsers.HtmlInterpreter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.user.client.ui.StackLayoutPanel;

public class StackLayoutPanelParser
implements ElementParser {
    private static final String CUSTOM = "customHeader";
    private static final String HEADER = "header";
    private static final String STACK = "stack";

    public void parse(XMLElement panelElem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        JEnumType unitEnumType = writer.getOracle().findType(Style.Unit.class.getCanonicalName()).isEnum();
        String unit = panelElem.consumeAttributeWithDefault("unit", String.format("%s.%s", unitEnumType.getQualifiedSourceName(), "PX"), (JType)unitEnumType);
        writer.setFieldInitializerAsConstructor(fieldName, writer.getOracle().findType(StackLayoutPanel.class.getName()), new String[]{unit});
        for (XMLElement stackElem : panelElem.consumeChildElements()) {
            String size;
            if (!this.isElementType(panelElem, stackElem, STACK)) {
                writer.die("In %s, only <%s:%s> children are allowed.", new Object[]{panelElem, panelElem.getPrefix(), STACK});
            }
            Children children = this.findChildren(stackElem, writer);
            if (children.body == null) {
                writer.die("In %s, %s must have a child widget", new Object[]{panelElem, stackElem});
            }
            if (!writer.isWidgetElement(children.body)) {
                writer.die("In %s, %s must be a widget", new Object[]{stackElem, children.body});
            }
            String childFieldName = writer.parseElementToField(children.body);
            if (children.header != null) {
                HtmlInterpreter htmlInt = HtmlInterpreter.newInterpreterForUiObject(writer, fieldName);
                size = children.header.consumeRequiredDoubleAttribute("size");
                String html = children.header.consumeInnerHtml((XMLElement.Interpreter)htmlInt);
                writer.addStatement("%s.add(%s, new com.google.gwt.user.client.ui.HTML(\"%s\"), %s);", new Object[]{fieldName, childFieldName, html, size});
                continue;
            }
            if (children.customHeader != null) {
                XMLElement headerElement = children.customHeader.consumeSingleChildElement();
                size = children.customHeader.consumeRequiredDoubleAttribute("size");
                if (!writer.isWidgetElement(headerElement)) {
                    writer.die("In %s of %s, %s is not a widget", new Object[]{children.customHeader, stackElem, headerElement});
                }
                String headerField = writer.parseElementToField(headerElement);
                writer.addStatement("%s.add(%s, %s, %s);", new Object[]{fieldName, childFieldName, headerField, size});
                continue;
            }
            writer.die("In %1$s, %2$s requires either a <%3$s:%4$s> or <%3$s:%5$s>", new Object[]{panelElem, stackElem, stackElem.getPrefix(), HEADER, CUSTOM});
        }
    }

    private Children findChildren(final XMLElement elem, final UiBinderWriter writer) throws UnableToCompleteException {
        final Children children = new Children();
        elem.consumeChildElements((XMLElement.Interpreter)new XMLElement.Interpreter<Boolean>(){

            public Boolean interpretElement(XMLElement child) throws UnableToCompleteException {
                if (this.hasTag(child, StackLayoutPanelParser.HEADER)) {
                    this.assertFirstHeader();
                    children.header = child;
                    return true;
                }
                if (this.hasTag(child, StackLayoutPanelParser.CUSTOM)) {
                    this.assertFirstHeader();
                    children.customHeader = child;
                    return true;
                }
                if (null != children.body) {
                    writer.die("In %s, may have only one body element", new Object[]{elem});
                }
                children.body = child;
                return true;
            }

            void assertFirstHeader() throws UnableToCompleteException {
                if (null != children.header && null != children.customHeader) {
                    writer.die("In %1$s, may have only one %2$s:header or %2$s:customHeader", new Object[]{elem, elem.getPrefix()});
                }
            }

            private boolean hasTag(XMLElement child, String attribute) {
                return this.rightNamespace(child) && child.getLocalName().equals(attribute);
            }

            private boolean rightNamespace(XMLElement child) {
                return child.getNamespaceUri().equals(elem.getNamespaceUri());
            }
        });
        return children;
    }

    private boolean isElementType(XMLElement parent, XMLElement child, String type) {
        return parent.getNamespaceUri().equals(child.getNamespaceUri()) && type.equals(child.getLocalName());
    }

    private static class Children {
        XMLElement body;
        XMLElement header;
        XMLElement customHeader;

        private Children() {
        }
    }
}

