/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.rpc.server;

import com.google.gwt.rpc.client.impl.RemoteException;
import com.google.gwt.rpc.server.ClientOracle;
import com.google.gwt.rpc.server.HostedModeClientOracle;
import com.google.gwt.rpc.server.RPC;
import com.google.gwt.rpc.server.WebModeClientOracle;
import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.AbstractRemoteServiceServlet;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.RPCServletUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RpcServlet
extends AbstractRemoteServiceServlet {
    protected static final String CLIENT_ORACLE_EXTENSION = ".gwt.rpc";
    private static final boolean DUMP_PAYLOAD = Boolean.getBoolean("gwt.rpc.dumpPayload");
    private final Map<String, SoftReference<ClientOracle>> clientOracleCache = new HashMap<String, SoftReference<ClientOracle>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientOracle getClientOracle() throws SerializationException {
        ClientOracle toReturn;
        String permutationStrongName = this.getPermutationStrongName();
        if (permutationStrongName == null) {
            throw new SecurityException("Blocked request without GWT permutation header (XSRF attack?)");
        }
        String basePath = this.getRequestModuleBasePath();
        if (basePath == null) {
            throw new SecurityException("Blocked request without GWT base path header (XSRF attack?)");
        }
        Map<String, SoftReference<ClientOracle>> map = this.clientOracleCache;
        synchronized (map) {
            if (this.clientOracleCache.containsKey(permutationStrongName) && (toReturn = this.clientOracleCache.get(permutationStrongName).get()) != null) {
                return toReturn;
            }
            if ("HostedMode".equals(permutationStrongName)) {
                if (!this.allowHostedModeConnections()) {
                    throw new SecurityException("Blocked hosted mode request");
                }
                toReturn = new HostedModeClientOracle();
            } else {
                InputStream in = this.findClientOracleData(basePath, permutationStrongName);
                try {
                    toReturn = WebModeClientOracle.load(in);
                }
                catch (IOException e) {
                    throw new SerializationException("Could not load serialization policy for permutation " + permutationStrongName, e);
                }
            }
            this.clientOracleCache.put(permutationStrongName, new SoftReference<ClientOracle>(toReturn));
        }
        return toReturn;
    }

    public void processCall(ClientOracle clientOracle, String payload, OutputStream stream) throws SerializationException {
        assert (clientOracle != null) : "clientOracle";
        assert (payload != null) : "payload";
        assert (stream != null) : "stream";
        try {
            RPCRequest rpcRequest = RPC.decodeRequest(payload, ((Object)((Object)this)).getClass(), clientOracle);
            this.onAfterRequestDeserialized(rpcRequest);
            RPC.invokeAndStreamResponse((Object)this, rpcRequest.getMethod(), rpcRequest.getParameters(), clientOracle, stream);
        }
        catch (RemoteException ex) {
            throw new SerializationException("An exception was sent from the client", ex.getCause());
        }
        catch (IncompatibleRemoteServiceException ex) {
            this.log("An IncompatibleRemoteServiceException was thrown while processing this call.", ex);
            RPC.streamResponseForFailure(clientOracle, stream, ex);
        }
    }

    public final void processPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SerializationException {
        OutputStream out;
        ClientOracle clientOracle = this.getClientOracle();
        String requestPayload = this.readContent(request);
        if (DUMP_PAYLOAD) {
            System.out.println(requestPayload);
        }
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        if (DUMP_PAYLOAD) {
            out = new ByteArrayOutputStream();
        } else if (RPCServletUtils.acceptsGzipEncoding(request) && this.shouldCompressResponse(request, response)) {
            RPCServletUtils.setGzipEncodingHeader(response);
            out = new GZIPOutputStream((OutputStream)response.getOutputStream());
        } else {
            out = response.getOutputStream();
        }
        this.processCall(clientOracle, requestPayload, out);
        ((OutputStream)out).close();
        if (DUMP_PAYLOAD) {
            byte[] bytes = out.toByteArray();
            System.out.println(new String(bytes, "UTF-8"));
            response.getOutputStream().write(bytes);
        }
    }

    protected boolean allowHostedModeConnections() {
        return this.isRequestFromLocalAddress();
    }

    protected InputStream findClientOracleData(String requestModuleBasePath, String permutationStrongName) throws SerializationException {
        String resourcePath = requestModuleBasePath + permutationStrongName + CLIENT_ORACLE_EXTENSION;
        InputStream in = this.getServletContext().getResourceAsStream(resourcePath);
        if (in == null) {
            throw new SerializationException("Could not find ClientOracle data for permutation " + permutationStrongName);
        }
        return in;
    }

    protected final String getRequestModuleBasePath() {
        try {
            String header = this.getThreadLocalRequest().getHeader("X-GWT-Module-Base");
            if (header == null) {
                return null;
            }
            return new URL(header).getPath();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    protected boolean shouldCompressResponse(HttpServletRequest request, HttpServletResponse response) {
        return !this.isRequestFromLocalAddress();
    }

    private boolean isRequestFromLocalAddress() {
        try {
            InetAddress addr = InetAddress.getByName(this.getThreadLocalRequest().getRemoteAddr());
            return InetAddress.getLocalHost().equals(addr) || addr.isLoopbackAddress() || addr.isSiteLocalAddress() || addr.isLinkLocalAddress();
        }
        catch (UnknownHostException e) {
            return false;
        }
    }
}

