/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.jsonp.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.ScriptElement;
import com.google.gwt.jsonp.client.TimeoutException;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonpRequest<T> {
    private static int callbackCounter = 0;
    private static final String CALLBACKS_NAME = "__gwt_jsonp__";
    private static final JavaScriptObject CALLBACKS = JsonpRequest.createCallbacksObject("__gwt_jsonp__");
    private final String callbackId = JsonpRequest.nextCallbackId();
    private final int timeout;
    private final AsyncCallback<T> callback;
    private final boolean expectInteger;
    private final String callbackParam;
    private final String failureCallbackParam;
    private Timer timer;

    private static native JavaScriptObject createCallbacksObject(String var0);

    private static Node getHeadElement() {
        return Document.get().getElementsByTagName("head").getItem(0);
    }

    private static String nextCallbackId() {
        return "I" + callbackCounter++;
    }

    JsonpRequest(AsyncCallback<T> callback, int timeout, boolean expectInteger, String callbackParam, String failureCallbackParam) {
        this.callback = callback;
        this.timeout = timeout;
        this.expectInteger = expectInteger;
        this.callbackParam = callbackParam;
        this.failureCallbackParam = failureCallbackParam;
    }

    public void cancel() {
        this.timer.cancel();
        this.unload();
    }

    public AsyncCallback<T> getCallback() {
        return this.callback;
    }

    public int getTimeout() {
        return this.timeout;
    }

    void send(final String baseUri) {
        this.registerCallbacks(CALLBACKS);
        StringBuffer uri = new StringBuffer(baseUri);
        uri.append(baseUri.contains("?") ? "&" : "?");
        String prefix = "__gwt_jsonp__." + this.callbackId;
        uri.append(this.callbackParam).append("=").append(prefix).append(".onSuccess");
        if (this.failureCallbackParam != null) {
            uri.append("&");
            uri.append(this.failureCallbackParam).append("=").append(prefix).append(".onFailure");
        }
        ScriptElement script = Document.get().createScriptElement();
        script.setType("text/javascript");
        script.setId(this.callbackId);
        script.setSrc(uri.toString());
        this.timer = new Timer(){

            public void run() {
                JsonpRequest.this.onFailure(new TimeoutException("Timeout while calling " + baseUri));
            }
        };
        this.timer.schedule(this.timeout);
        JsonpRequest.getHeadElement().appendChild(script);
    }

    private void onFailure(String message) {
        this.onFailure(new Exception(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFailure(Throwable ex) {
        this.timer.cancel();
        try {
            if (this.callback != null) {
                this.callback.onFailure(ex);
            }
        }
        finally {
            this.unload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSuccess(T data) {
        this.timer.cancel();
        try {
            if (this.callback != null) {
                this.callback.onSuccess(data);
            }
        }
        finally {
            this.unload();
        }
    }

    private native void registerCallbacks(JavaScriptObject var1);

    private void unload() {
        DeferredCommand.addCommand(new Command(){

            public void execute() {
                JsonpRequest.this.unregisterCallbacks(CALLBACKS);
                Element script = Document.get().getElementById(JsonpRequest.this.callbackId);
                if (script != null) {
                    JsonpRequest.getHeadElement().removeChild(script);
                }
            }
        });
    }

    private native void unregisterCallbacks(JavaScriptObject var1);
}

