/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.appengine.tools.appstats.MemcacheWriter;
import com.google.appengine.tools.appstats.Recorder;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppstatsFilter
implements Filter {
    private static Recorder.RecordWriter writer = null;
    private static ApiProxy.Delegate<?> delegate;
    private String logMessage;

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filters) throws IOException, ServletException {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        writer.begin(delegate, environment, (HttpServletRequest)request);
        final HttpServletResponse innerResponse = (HttpServletResponse)response;
        final Integer[] responseCode = new Integer[]{null};
        HttpServletResponse outerResponse = (HttpServletResponse)Proxy.newProxyInstance(AppstatsFilter.class.getClassLoader(), new Class[]{HttpServletResponse.class}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("sendError") || method.getName().equals("setStatus")) {
                    responseCode[0] = ((Number)args[0]).intValue();
                } else if (method.getName().equals("sendRedirect")) {
                    responseCode[0] = 307;
                }
                return method.invoke((Object)innerResponse, args);
            }
        });
        try {
            filters.doFilter(request, (ServletResponse)outerResponse);
        }
        finally {
            Long id = writer.commit(delegate, environment, responseCode[0]);
            if (this.logMessage != null && id != null) {
                this.log(environment, this.logMessage.replace("{ID}", "" + id));
            }
        }
    }

    public synchronized void init(FilterConfig config) {
        if (writer == null) {
            MemcacheWriter newWriter = new MemcacheWriter(new Recorder.Clock(), MemcacheServiceFactory.getMemcacheService(), null);
            delegate = ApiProxy.getDelegate();
            ApiProxy.setDelegate(AppstatsFilter.wrapPartially(delegate, new Recorder(delegate, newWriter)));
            writer = newWriter;
            this.logMessage = config.getInitParameter("logMessage");
        }
    }

    private void log(ApiProxy.Environment env, String message) {
        ApiProxy.LogRecord record = new ApiProxy.LogRecord(ApiProxy.LogRecord.Level.info, System.currentTimeMillis(), message);
        delegate.log(env, record);
    }

    static <S, T extends S> S wrapPartially(final S original, final T wrapper) {
        if (!original.getClass().getName().contains("Local")) {
            return wrapper;
        }
        Class<?>[] interfaces = original.getClass().getInterfaces();
        InvocationHandler handler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Method wrapperMethod = null;
                try {
                    wrapperMethod = wrapper.getClass().getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    return AppstatsFilter.call(method, original, args);
                }
                return AppstatsFilter.call(wrapperMethod, wrapper, args);
            }
        };
        return (S)Proxy.newProxyInstance(original.getClass().getClassLoader(), interfaces, handler);
    }

    private static Object call(Method m, Object o, Object[] args) throws Throwable {
        try {
            return m.invoke(o, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

