/*
 *  Breeze  --  An application launcher with command-line style
 *  Copyright (C) 2005, 2006 Hironao Komatsu
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef BREEZE_H_INCLUDED
#define BREEZE_H_INCLUDED

int popup_mainwin(void);
int popup_registwin(const gchar *keyword);
int popup_editorwin(void);
const gchar *select_file(const gchar *title);

int initialize_commands(void);
void finalize_commands(void);
gconstpointer lookup_preset_commands(const gchar *keyword);
gconstpointer lookup_user_commands(const gchar *keyword);
int insert_user_commands(gchar *keyword, gchar *command);
void commands_table_foreach(GHFunc func, gpointer user_data);
void user_commands_table_foreach(GHFunc func, gpointer user_data);

gchar *strip(gchar *str, gboolean *is_empty);

#endif
