begin
  require 'redcloth'

  class TextileStyle < BloggerPost::Style
    def self.style_name
      'textile'
    end

    def self.extname
      '.txt'
    end

    def entry_to_html(entry)
      html = RedCloth.new(entry.body).to_html
      html = wrap_html_first_h1(html)
      html
    end
  end

  BloggerPost.register_style(TextileStyle)
rescue LoadError
  # do nothing
end
