/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.log.logging;

import java.util.logging.Handler;
import java.util.logging.LogRecord;

import blanco.log.resourcebundle.BlancoLogProgramMessage;

/**
 * java.util.logging ̏o͂ Apache log4j Ƀ_CNg邽߂̃nhNXB
 * 
 * <P>
 * blanco.log.logging.BlancoLogLog4jHandler NX𗘗pƁA<A href="http://java.sun.com/javase/ja/6/docs/ja/api/java/util/logging/package-summary.html"
 * >java.util.logging</A> ̏o͂ <A href="http://logging.apache.org/log4j/">Apache
 * log4j</A> Ƀ_CNg邱Ƃł܂BɂAW Java API ݂̂𗘗p Apache log4j
 * ւ̃Oo͂邱Ƃo悤ɂȂ܂B
 * </P>
 * <p>
 * ݁A̕X̓MÕC^tF[XƂ <A href="http://commons.apache.org/logging/">Apache
 * Commons Logging</A> 𗘗pĂ̂̂Ǝv܂BłAApache Commons Logging 𗘗pƁAJava
 * \[XR[h org.apache.commons.logging.* 
 * importKvɂȂĂ܂܂BuMO͂Ă̂ǂAJava import W Java
 * APIȊÔ͍̂̂D܂Ȃ
 * vƂW}𑽂͊̕Ă邱Ƃł傤BAblanco.log.logging.BlancoLogLog4jHandler
 * ͖邱Ƃo܂B
 * </p>
 * <p>
 * blanco.log.logging.BlancoLogLog4jHandler
 * NX̎dg݂͂ƂĂVvȂ̂łBjava.util.logging ̃OnhNXł
 * java.util.logging.Handler pāȀo͂ Apache log4j NXւƈnĂ邾łB<br>
 * 2007.11.23_ł 悻 105s̃\[XR[hɂĎĂ܂B
 * </p>
 * <p>
 * <font color="#ff00ff">p@</font>
 * </p>
 * <p>
 * L̂悤Ȏ菇ŗp邱Ƃo܂B
 * </p>
 * <ul>
 * <li>NXpXɈȉ̃t@Czu܂B<br>
 * Javas jre\lib\ext fBNgɔzuƂ@܂B
 * <ul>
 * <li>blancolog-?.?.?.jar: blancoLogjart@C
 * 
 * </li>
 * <li>log4j-1.2.??.jar : Apache log4jjart@C<br>
 * Apache log4j ɃNXpXɂꍇɂ́AVɔzu邱Ƃ͕svłB</li>
 * </ul>
 * 
 * 
 * </li>
 * <li>java.util.logging ̐ݒύX܂B<br>
 * łPȕύX@́AJavas jre\lib fBNg logging.properties
 * ύX@łBȂAύXO<STRONG>IWĩt@CobNAbv</STRONG>邱Ƃ𐄏܂B
 * <ul>
 * <li>Javas jre\lib fBNg  logging.properties t@CAȉ̂QsɕύX܂B<br>
 * &lt;logging.properties&gt;<br>
 * <table border="1">
 * <tbody>
 * <tr>
 * <td>handlers=blanco.log.logging.BlancoLogLog4jHandler<br>
 * .level= ALL</td>
 * </tr>
 * </tbody>
 * </table>
 * </li>
 * <li>java.util.logging ́AȊOɂ̐ݒύX@񋟂Ă܂B</li>
 * </ul>
 * </li>
 * <li>Apache log4j ̂߂̐ݒt@C &lt;log4j.properties&gt; ݒ肵܂B
 * <ul>
 * <li>NXpX ǂp҂̓s̗ǂfBNg log4j.properties ƂÕt@C쐬܂BȂA󋵂ɂĂ
 * ̃t@C͊ɑ݂Ăꍇ܂B</li>
 * <li>&lt;log4j.properties&gt; ̒PȋLqe<br>
 * <table border="1">
 * <tbody>
 * <tr>
 * <td>log4j.rootLogger=DEBUG, A1<br>
 * log4j.appender.A1=org.apache.log4j.ConsoleAppender<br>
 * log4j.appender.A1.layout=org.apache.log4j.PatternLayout<br>
 * log4j.appender.A1.layout.ConversionPattern=%d [%t] %-5p %c - %m%n</td>
 * </tr>
 * </tbody>
 * </table>
 * 
 * 
 * </li>
 * </ul>
 * 
 * </li>
 * </ul>
 * <p>
 * <font color="#ff00ff">java.util.logging  Apache log4j ւ̃Ox}bsO</font>
 * </p>
 * <p>
 * java.util.logging  Apache log4j
 * Ƃł̓OxقȂ܂B邽߂ɁAL̂悤ȃOx̃}bsOsĂ܂B
 * </p>
 * <blockquote>
 * <table border="1">
 * <tbody>
 * <tr>
 * <td bgcolor="#ffff00"><strong>java.util.logging ̃Ox</strong></td>
 * <td bgcolor="#ffff00"><strong>Apache log4j ̃Ox</strong></td>
 * <td bgcolor="#ffff00"><strong>l</strong></td>
 * </tr>
 * <tr>
 * <td>java.util.logging.Level.FINEST</td>
 * <td>org.apache.log4j.Level.TRACE</td>
 * <td>uڍ׃x()vB</td>
 * </tr>
 * <tr>
 * <td>java.util.logging.Level.FINER</td>
 * <td>org.apache.log4j.Level.TRACE</td>
 * <td>uڍ׃x()vB</td>
 * </tr>
 * <tr>
 * <td>java.util.logging.Level.FINE</td>
 * <td>org.apache.log4j.Level.DEBUG</td>
 * <td>uڍ׃x()vB</td>
 * </tr>
 * <tr>
 * <td>java.util.logging.Level.CONFIG</td>
 * <td>org.apache.log4j.Level.DEBUG</td>
 * <td>uݒvBObZ[W uconfig: vvtBNXt^܂B</td>
 * </tr>
 * <tr>
 * <td>java.util.logging.Level.INFO</td>
 * <td>org.apache.log4j.Level.INFO</td>
 * <td>uvB</td>
 * </tr>
 * <tr>
 * <td>java.util.logging.Level.WARNING</td>
 * <td>org.apache.log4j.Level.WARN</td>
 * <td>uxvB</td>
 * </tr>
 * <tr>
 * <td>java.util.logging.Level.SEVERE</td>
 * <td>org.apache.log4j.Level.ERROR<br>
 * org.apache.log4j.Level.FATAL (*1)</td>
 * <td>uvIvB<br>
 * (*1)bZ[Wfataln܂̂̂ FATAL Ƀ}bv܂B</td>
 * </tr>
 * </tbody>
 * </table>
 * </blockquote>
 * <P>
 * <FONT color="#ff00ff">java.util.logging ̉\</FONT>
 * </P>
 * <P>
 *  java.util.logging ̗pƂ͂̂ǂAjava.util.logging
 * ̃Onh̔͂ŗpfOl͑̂ł͂ł傤BOnh Apache log4j
 * ̂ق̒A܂@\ł̂͊mȂƂłBŁAjava.util.logging  Apache Commons Logging
 * ̑ɗpāAMO Apache log4j
 * gĂ܂ƂAblanco.log.logging.BlancoLogLog4jHandler NX ̗pĂ܂B ̋@
 * blanco.log.logging.BlancoLogLog4jHandler NX p <A href="http://java.sun.com/javase/ja/6/docs/ja/api/java/util/logging/package-summary.html"
 * >java.util.logging</A>̗p邱Ƃ߂܂B
 * </P>
 * 
 * @author IGA Tosiki
 */
public class BlancoLogLog4jHandler extends Handler {
    /**
     * bZ[WNXB
     * 
     * ̃CX^X̓bNIuWFNg̖ړIłp܂B
     */
    protected final BlancoLogProgramMessage fMsg = new BlancoLogProgramMessage();

    /**
     * ۂ̏sOnhNXB
     * 
     * NX[hsmł悤ɂ邽߁ÃNX ObjectŋL܂B
     */
    protected Object fInternalHandler = null;

    /**
     * RXgN^B
     * 
     * ̃^C~O Apache log4j ̑݃`FbN{܂B
     * 
     * @throws IllegalArgumentException
     *             Apache log4jNXȂꍇB
     */
    public BlancoLogLog4jHandler() throws IllegalArgumentException {
        synchronized (fMsg) {
            try {
                fInternalHandler = new BlancoLogLog4jHandlerInternal();
                ((BlancoLogLog4jHandlerInternal) fInternalHandler).init();
            } catch (NoClassDefFoundError e) {
                throw new IllegalArgumentException(fMsg.getMblglg01(e
                        .toString()));
            }
        }
    }

    /**
     * ^ꂽOR[hMO܂B
     * 
     * @param argLogRecord
     *            OR[hB
     */
    public void publish(final LogRecord argLogRecord) {
        synchronized (fMsg) {
            ((BlancoLogLog4jHandlerInternal) fInternalHandler)
                    .publish(argLogRecord);
        }
    }

    /**
     * K[tbV܂B
     */
    public void flush() {
        synchronized (fMsg) {
            ((BlancoLogLog4jHandlerInternal) fInternalHandler).flush();
        }
    }

    /**
     * K[N[Y܂B
     * 
     * @throws SecurityException
     *             ZLeBOꍇB
     */
    public void close() throws SecurityException {
        synchronized (fMsg) {
            ((BlancoLogLog4jHandlerInternal) fInternalHandler).close();
        }
    }
}
