/*
 * blanco Framework
 * Copyright (C) 2004-2010 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.log.custom;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

import blanco.log.logging.BlancoLogLoggingConstants;
import blanco.log.resourcebundle.BlancoLogProgramMessage;

/**
 * java.util.logging ̃Oo͌` Log4J ̏o͌`ɉHړĨJX^EOtH[}b^[B
 * 
 * @author IGA Tosiki
 */
public class BlancoLogFormatter extends Formatter {
    /**
     * blancoLogbZ[WNXB
     */
    protected final BlancoLogProgramMessage fMsg = new BlancoLogProgramMessage();

    /**
     * X^bNg[XOo͂邩ǂB WuĎ\tgŊĎꍇz肵AftHg false
     * ƂĂ܂B(̃OĎ\tǵAÕX^bNg[XƑz)
     */
    public static final boolean IS_OUTPUT_THROWN = false;

    /**
     * O̓t`B~b́u.vŋ؂܂B
     */
    final SimpleDateFormat sdFormat = new SimpleDateFormat(
            "yyyy-MM-dd HH:mm:ss.SSS");

    /**
     * zXgBMOŗpB
     */
    String fLocalHostName = null;

    /**
     * {@inheritDoc}
     */
    public String format(final LogRecord argLogRecord) {
        final StringBuffer buf = new StringBuffer(1024);

        try {
            logRecordMessage2Buffer(argLogRecord, buf);
        } catch (ThreadDeath ex) {
            return fMsg.getMblgcf01();
        }

        if (IS_OUTPUT_THROWN) {
            if (argLogRecord.getThrown() != null) {
                // OIuWFNgOt@CɏóB
                logRecordThrown2Buffer(argLogRecord.getThrown(), buf);
            }
        }

        return buf.toString();
    }

    /**
     * ObZ[W𕶎񉻂܂B
     * 
     * @param argLogRecord
     * @param argBuf
     */
    void logRecordMessage2Buffer(final LogRecord argLogRecord,
            final StringBuffer argBuf) {
        final Date now = new Date(argLogRecord.getMillis());
        synchronized (sdFormat) {
            argBuf.append(sdFormat.format(now));
        }

        // Log4j ̃Oo͂s܂B
        argBuf.append(" [");
        switch (argLogRecord.getLevel().intValue()) {
        case BlancoLogLoggingConstants.FINEST:
        case BlancoLogLoggingConstants.FINER:
            argBuf.append("TRACE");
            break;
        case BlancoLogLoggingConstants.FINE:
            argBuf.append("DEBUG");
            break;
        case BlancoLogLoggingConstants.CONFIG:
            argBuf.append("CONF ");
            break;
        case BlancoLogLoggingConstants.INFO:
            argBuf.append("INFO ");
            break;
        case BlancoLogLoggingConstants.WARNING:
            argBuf.append("WARN ");
            break;
        case BlancoLogLoggingConstants.SEVERE:
            boolean isFatal = false;
            if (argLogRecord.getMessage().length() >= 5) {
                final String head = argLogRecord.getMessage().substring(0, 5);
                if ("fatal".equals(head.toLowerCase())) {
                    // bZ[W fatal ܂ FATAL ŊJnꍇɂ̂ fatal Ƀ}bsOB
                    isFatal = true;
                }
            }
            if (isFatal) {
                argBuf.append("FATAL");
            } else {
                argBuf.append("ERROR");
            }
            break;
        default:
            argBuf.append(Integer.toString(argLogRecord.getLevel().intValue()));
            argBuf.append("  ");
            break;
        }
        argBuf.append("] ");

        if (fLocalHostName == null) {
            try {
                fLocalHostName = InetAddress.getLocalHost().getHostName();
            } catch (UnknownHostException e) {
                fLocalHostName = "noname(" + e.toString() + ")";
            }
        }
        argBuf.append(fLocalHostName);
        argBuf.append(" ");

        argBuf.append(getMessaegWithBundle(argLogRecord));
        // s͕t^܂B
        // argBuf.append("\n");
    }

    /**
     * ÕohKpł͓̂Kp̃bZ[W擾܂B
     * 
     * {邱ƂɂAohΉObZ[WɂāAohɓn ID ۂ̃bZ[Wǂݑւ܂B
     * 
     * @param argLogRecord
     * @return
     */
    String getMessaegWithBundle(final LogRecord argLogRecord) {
        final StringBuilder result = new StringBuilder();

        final ResourceBundle resourceBundle = argLogRecord.getResourceBundle();
        final String origMesssage = argLogRecord.getMessage();
        String message = null;
        if (origMesssage != null && resourceBundle != null) {
            try {
                if (argLogRecord.getParameters() == null) {
                    message = resourceBundle.getString(origMesssage);
                } else {
                    final MessageFormat messageFormat = new MessageFormat(
                            resourceBundle.getString(origMesssage));
                    final StringBuffer strbuf = new StringBuffer();
                    // ^ꂽɒuu܂B
                    messageFormat.format(argLogRecord.getParameters(), strbuf,
                            null);
                    message = strbuf.toString();
                }
            } catch (Exception ex) {
                // \[Xo^ȂBȂɂł܂B
            }
        }
        if (message == null) {
            // [JCYs\ȏꍇɂ́AƂ̂̂̂܂ܗp܂B
            message = origMesssage;
        }
        if (message == null) {
            message = "";
        }
        // sR[h͋󔒂ɕϊ܂B
        result.append(message.replace('\n', ' ').replace('\r', ' '));

        return result.toString();
    }

    /**
     * OIuWFNgbZ[W܂B
     * 
     * @param argEx
     * @param argBuf
     */
    void logRecordThrown2Buffer(final Throwable argEx, final StringBuffer argBuf) {
        final StringWriter writerResult = new StringWriter(1024);
        final PrintWriter writer = new PrintWriter(writerResult);
        argEx.printStackTrace(writer);
        writer.close();

        argBuf.append(writerResult.toString());
        // X^bNg[X̍Ōɂ͉sŏtĂ܂B̂߁AXȂst^͕svłB
    }
}
