/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.eclipseplugingen.expand;

import java.io.File;
import java.util.List;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoXmlUtil;

public class BlancoEclipsePluginGenExpandEditor {
    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    public final void expand(final Element elementCommon,
            final NodeList listList, final File directoryTarget) {
        final String pluginName = BlancoXmlUtil.getTextContent(elementCommon,
                "name");
        final String packageName = BlancoXmlUtil.getTextContent(elementCommon,
                "packageName");
        final String description = BlancoXmlUtil.getTextContent(elementCommon,
                "description");

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(directoryTarget.getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(packageName + ".editors",
                "̃\[XR[h blanco FrameworkɂĎĂ܂B");
        fCgSourceFile.setEncoding(fEncoding);
        fCgSourceFile.getLangDoc().getDescriptionList().add(
                "EclipsevOC [" + pluginName + "]̒ۃGfB^NX");

        fCgClass = fCgFactory.createClass("Abstract"
                + BlancoNameAdjuster.toClassName(pluginName) + "Editor",
                "EclipsevOC [" + pluginName + "]̒ۃGfB^NXB");
        fCgSourceFile.getClassList().add(fCgClass);

        fCgClass.setAbstract(true);

        fCgSourceFile.getImportList().add("java.io.ByteArrayInputStream");

        fCgSourceFile.getImportList().add("java.io.ByteArrayOutputStream");
        fCgSourceFile.getImportList().add("java.io.IOException");
        fCgSourceFile.getImportList().add(
                "java.io.UnsupportedEncodingException");
        fCgSourceFile.getImportList().add("javax.xml.transform.dom.DOMResult");
        fCgSourceFile.getImportList().add("org.w3c.dom.Document");
        fCgSourceFile.getImportList().add("org.eclipse.swt.events.FocusEvent");
        fCgSourceFile.getImportList().add(
                "org.eclipse.swt.events.FocusListener");
        fCgSourceFile.getImportList().add("blanco.commons.util.BlancoXmlUtil");

        fCgClass
                .getExtendClassList()
                .add(
                        fCgFactory
                                .createType("org.eclipse.ui.editors.text.TextEditor"));

        if (description != null) {
            fCgClass.getLangDoc().getDescriptionList().add(
                    BlancoJavaSourceUtil.escapeStringAsJavaDoc(description)
                            + "<br>");
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod("Abstract"
                    + BlancoNameAdjuster.toClassName(pluginName) + "Editor",
                    "GfB^NX̃RXgN^łB");
            fCgClass.getMethodList().add(method);
            method.setConstructor(true);

            final List<java.lang.String> listLine = method.getLineList();

            listLine.add("// ̃GR[fBOēo͂邽߂ɃvoC_ZbgĂ܂B");
            listLine.add("setDocumentProvider(new " + pluginName
                    + "DocumentProvider());");
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod("setFocus",
                    "tH[JXZbgꂽꍇɌĂяo܂B");
            fCgClass.getMethodList().add(method);
            method.setFinal(true);
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod(
                    "isSaveAsAllowed", "OtĕۑĂ邩ǂB");
            fCgClass.getMethodList().add(method);
            method.setFinal(true);
            method.setReturn(fCgFactory
                    .createReturn("boolean", "false߂܂B"));

            final List<java.lang.String> listLine = method.getLineList();
            listLine.add("return false;");
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod(
                    "isSaveOnCloseNeeded", "GfB^ۂɕۑKvǂ߂܂B");
            fCgClass.getMethodList().add(method);
            method.setFinal(true);
            method
                    .setReturn(fCgFactory.createReturn("boolean",
                            "true߂܂B"));

            final List<java.lang.String> listLine = method.getLineList();
            listLine.add("return true;");
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod(
                    "setFocusLostHandler", "");
            fCgClass.getMethodList().add(method);
            method.setFinal(true);
            method.setAccess("protected");
            method.getParameterList().add(
                    fCgFactory.createParameter("target",
                            "org.eclipse.swt.widgets.Control", ""));

            final List<java.lang.String> listLine = method.getLineList();
            listLine.add("target.addFocusListener(new FocusListener() {");
            listLine.add("public void focusGained(FocusEvent e) {");
            listLine.add("}");
            listLine.add("");
            listLine.add("public void focusLost(FocusEvent e) {");
            listLine.add("saveToTextEditor();");
            listLine.add("}");
            listLine.add("}");
            listLine.add(");");
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod(
                    "loadFromTextEditor", "eLXgGfB^f[^[hۂɌĂяo܂B");
            fCgClass.getMethodList().add(method);
            method.getLangDoc().getDescriptionList().add(
                    "̃\bh blancoœƎɋK肷̂łB");
            method.setFinal(true);
            method.setAccess("protected");

            final List<java.lang.String> listLine = method.getLineList();

            listLine
                    .add("final String editorText = getDocumentProvider().getDocument(getEditorInput()).get();");
            listLine.add("");
            listLine.add("final DOMResult result;");
            listLine.add("try {");
            listLine
                    .add("result = BlancoXmlUtil.transformStream2Dom(new ByteArrayInputStream(editorText.getBytes(\"UTF-8\")));");
            listLine.add("} catch (UnsupportedEncodingException e) {");
            listLine.add("e.printStackTrace();");
            listLine.add("return;");
            listLine.add("}");
            listLine.add("");
            listLine.add("loadFromTextEditorInternal(result);");
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod(
                    "loadFromTextEditorInternal", "ۂɃf[^[h鏈eLq܂B");
            fCgClass.getMethodList().add(method);
            method.setAccess("protected");
            method.setAbstract(true);
            method.getParameterList().add(
                    fCgFactory.createParameter("argResult",
                            "javax.xml.transform.dom.DOMResult", ""));
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod(
                    "saveToTextEditor", "eLXgGfB^f[^Z[uۂɌĂяo܂B");
            fCgClass.getMethodList().add(method);
            method.setFinal(true);
            method.setAccess("protected");
            method.getLangDoc().getDescriptionList().add(
                    "̃\bh blancoœƎɋK肷̂łB");

            final List<java.lang.String> listLine = method.getLineList();

            listLine.add("Document document = saveToTextEditorInternal();");
            listLine.add("if (document == null) {");
            listLine.add("return;");
            listLine.add("}");
            listLine.add("");
            listLine
                    .add("final ByteArrayOutputStream outStream = new ByteArrayOutputStream();");
            listLine
                    .add("BlancoXmlUtil.transformDom2Stream(document, outStream);");
            listLine.add("try {");
            listLine.add("outStream.flush();");
            listLine
                    .add("final String result = new String(outStream.toByteArray(), \"UTF-8\");");
            listLine
                    .add("final String pastEditorText = getDocumentProvider().getDocument(getEditorInput()).get();");
            listLine.add("if (pastEditorText.equals(result) == false) {");
            listLine.add("// eقȂꍇɂ̂ݏ݂s܂B");
            listLine
                    .add("getDocumentProvider().getDocument(getEditorInput()).set(result);");
            listLine.add("}");
            listLine.add("} catch (UnsupportedEncodingException e) {");
            listLine.add("e.printStackTrace();");
            listLine.add("return;");
            listLine.add("} catch (IOException e) {");
            listLine.add("e.printStackTrace();");
            listLine.add("return;");
            listLine.add("}");
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod(
                    "saveToTextEditorInternal", "ۂɃf[^Z[u鏈eLq܂B");
            fCgClass.getMethodList().add(method);
            method.setAccess("protected");
            method.setAbstract(true);
            method.setReturn(fCgFactory
                    .createReturn("org.w3c.dom.Document", ""));
        }

        // \[XR[hۂɐ܂B
        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }
}
