/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.jsf.message;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * bZ[W`[BlancoJsf]Iɗp郊\[XohNXB
 *
 * \[Xoh`: [BlancoJsfMessage]B<BR>
 * ̃NX̓\[Xoh`玩ꂽ\[XohNXłB<BR>
 */
class BlancoJsfMessageResourceBundle {
    /**
     * \[XohIuWFNgB
     *
     * IɎۂɓ͂s\[XohL܂B
     */
    private ResourceBundle fResourceBundle;

    /**
     * BlancoJsfMessageResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoJsfMessage]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B
     */
    public BlancoJsfMessageResourceBundle() {
        try {
            fResourceBundle = ResourceBundle.getBundle("blanco/jsf/message/BlancoJsfMessage");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BlancoJsfMessageResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoJsfMessage]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     */
    public BlancoJsfMessageResourceBundle(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("blanco/jsf/message/BlancoJsfMessage", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BlancoJsfMessageResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoJsfMessage]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     * @param loader NX[_̎w
     */
    public BlancoJsfMessageResourceBundle(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("blanco/jsf/message/BlancoJsfMessage", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * IɕێĂ郊\[XohIuWFNg擾܂B
     *
     * @return IɕێĂ郊\[XohIuWFNgB
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BlancoJsfMessage], key[MBJFI001]
     *
     * [JSFID[{0}]A\bh[{0}]̃pbP[Ww肳Ă܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[MBJFI001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMbjfi001(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "JSFID[{0}]A\bh[{0}]̃pbP[Ww肳Ă܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MBJFI001");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoJsfMessage], key[MBJFI002]
     *
     * [JSFID[{0}]̃\bhw肳Ă܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[MBJFI002]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMbjfi002(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "JSFID[{0}]̃\bhw肳Ă܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MBJFI002");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoJsfMessage], key[MBJFI003]
     *
     * [JSFID[{0}]̃\bhɎw肳ꂽ 'initialize' ͗\łBwł܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[MBJFI003]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMbjfi003(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "JSFID[{0}]̃\bhɎw肳ꂽ 'initialize' ͗\łBwł܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MBJFI003");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoJsfMessage], key[MBJFI004]
     *
     * [JSFID[{0}]̃\bhɎw肳ꂽ 'view' ͗\łBwł܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[MBJFI004]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMbjfi004(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "JSFID[{0}]̃\bhɎw肳ꂽ 'view' ͗\łBwł܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MBJFI004");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoJsfMessage], key[MBJFA001]
     *
     * [^fBNg[{0}]݂܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[MBJFA001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMbjfa001(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "^fBNg[{0}]݂܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MBJFA001");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoJsfMessage], key[MBJFG001]
     *
     * [JSF` [{0}]A[{1}]  SQL`ID [{2}] ܂B̌ۂ́AblancoDb \[XR[hsΉꍇ܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @return key[MBJFG001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMbjfg001(final String arg0, final String arg1, final String arg2) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "JSF` [{0}]A[{1}]  SQL`ID [{2}] ܂B̌ۂ́AblancoDb \[XR[hsΉꍇ܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MBJFG001");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2}, strbuf, null);
        return strbuf.toString();
    }
}
