/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.jsf;

import java.io.File;
import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgInterface;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.jsf.task.valueobject.BlancoJsfProcessInput;
import blanco.jsf.valueobject.BlancoJsfProcessBeanItemStructure;
import blanco.jsf.valueobject.BlancoJsfProcessStructure;
import blanco.jsf.valueobject.BlancoJsfStructure;

/**
 * (blancoJsf)̂߂̃CNXB
 * 
 * C^tF[XWJ܂B
 */
class BlancoJsfExpandLogic {
    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgInterface fCgInterface = null;

    private BlancoJsfProcessInput fInput = null;

    /**
     * WꂽɁA\[XR[h܂B
     * 
     * @param processStructure
     *            ^t@CWł\f[^B
     * @param argRuntimePackage
     *            ^CpbP[WBnullђ0̏̕ꍇ͒`ƂɃ^CNX𐶐B
     * @param argTargetLang
     *            o͑ΏۃvO~OB
     * @param argDirectoryTarget
     *            \[XR[h̏o͐tH_B
     */
    public void expandSourceFile(final BlancoJsfStructure structure,
            final List<BlancoJsfStructure> listJsfStructure,
            final BlancoJsfProcessStructure processStructure,
            final List<String> sqlClassNameList,
            final BlancoJsfProcessInput input) {
        fInput = input;

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(new File(input.getTargetdir())
                .getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(structure.getPackage(),
                null);
        fCgSourceFile.setEncoding(input.getEncoding());
        fCgInterface = fCgFactory.createInterface(getProcessInterfaceName(
                structure, processStructure), BlancoStringUtil
                .null2Blank(processStructure.getDescription()));
        fCgSourceFile.getInterfaceList().add(fCgInterface);

        fCgInterface.setDescription(" ["
                + getProcessInterfaceName(structure, processStructure)
                + "]C^tF[XB");
        fCgInterface.getLangDoc().getDescriptionList().add(
                "̃C^tF[X [" + structure.getPackage() + "]pbP[W["
                        + getProcessInterfaceName(structure, processStructure)
                        + "Impl]NX쐬Ďۂ̏ĂB");
        fCgInterface.getLangDoc().getDescriptionList().add("");

        expandMethodExecute(structure, listJsfStructure, processStructure,
                sqlClassNameList);

        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }

    /**
     * execute \bhWJ܂B
     * 
     * @param processStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodExecute(final BlancoJsfStructure structure,
            final List<BlancoJsfStructure> listJsfStructure,
            final BlancoJsfProcessStructure processStructure,
            final List<String> sqlClassNameList) {
        final BlancoCgMethod method = fCgFactory.createMethod("execute",
                "NXCX^Xďsۂ̃Gg|CgłB");
        fCgInterface.getMethodList().add(method);
        method.setFinal(true);

        if (BlancoStringUtil.null2Blank(structure.getBean()).length() > 0) {
            addBeanParameter(fCgFactory, method, structure.getBean(),
                    "C Managed BeanB");
        }

        for (BlancoJsfProcessBeanItemStructure bean : processStructure
                .getBeanList()) {
            String managedBeanClassName = null;

            // ܂͊ǗBeanĂ̂ƉB
            final BlancoJsfStructure jsfStructure = BlancoJsfExpandLogicProxy
                    .getJsfStructureByManagedBeanName(bean.getName(),
                            listJsfStructure);
            if (jsfStructure == null) {
                // blancoJsf `ɂ͌܂łB
                // ̏ꍇ́ANX̂܂܂łB
                managedBeanClassName = bean.getName();
            } else {
                // blancoJsf `Ɍ܂B
                managedBeanClassName = jsfStructure.getBean();
            }

            addBeanParameter(fCgFactory, method, managedBeanClassName,
                    "session 擾 Managed BeanB");
        }

        if ("pfAutoComplete".equals(processStructure.getType())) {
            method.getParameterList().add(
                    fCgFactory.createParameter("argPfAutoCompleteInput",
                            "java.lang.String",
                            "PrimeFaces  AutoComplete NGXgB"));
            method.getParameterList().add(
                    fCgFactory.createParameter("argPfAutoCompleteOutput",
                            "java.util.List<java.lang.String>",
                            "PrimeFaces  AutoComplete X|XB"));
        }

        for (String sqlClassName : sqlClassNameList) {
            addSqlParameter(fCgFactory, method, sqlClassName);
        }

        if (sqlClassNameList.size() > 0) {
            method.getParameterList().add(
                    fCgFactory.createParameter("conn", "java.sql.Connection",
                            "f[^x[XڑB{IɁÃp[^͗pȂłB"));
        }

        if (processStructure.getForward()) {
            // ߂lȂ String
            method.setReturn(fCgFactory.createReturn("java.lang.String",
                    "̎sʁBsuccess, error Ȃǂ̑JڐɊւ镶ԋpB"));
        }

        if (processStructure.getActionEvent()) {
            method.getParameterList().add(
                    fCgFactory.createParameter("actionEvent",
                            "javax.faces.event.ActionEvent",
                            "JSF  ActionEventB"));
        }

        if (processStructure.getFacesMessage()) {
            method
                    .getParameterList()
                    .add(
                            fCgFactory
                                    .createParameter(
                                            "facesMessageList",
                                            "java.util.List<javax.faces.application.FacesMessage>",
                                            "FacesMessage ̃XgBJSF  <h:messages /> ƋLq邱Ƃŗp\"));
        }

        if (processStructure.getFacesContext()) {
            method.getParameterList().add(
                    fCgFactory.createParameter("ctx",
                            "javax.faces.context.FacesContext",
                            "Faces ŗp邱ƂłReLXgB̈́AȂׂpȂłB"));
        }

        if ("download".equals(processStructure.getType())) {
            String runtimePackage = structure.getPackage();
            if (BlancoStringUtil.null2Blank(fInput.getRuntimepackage())
                    .length() > 0) {
                runtimePackage = fInput.getRuntimepackage();
            }
            method.getParameterList().add(
                    fCgFactory.createParameter("downloadInfo", runtimePackage
                            + ".BlancoJsfDownloadInfo", "_E[hB"));

            method.getParameterList().add(
                    fCgFactory.createParameter("outStream",
                            "java.io.OutputStream", "_E[h̏o̓Xg[B"));
        }

        method.getThrowList()
                .add(
                        fCgFactory.createException("java.lang.Exception",
                                "OꍇB"));
    }

    private String getProcessInterfaceName(final BlancoJsfStructure structure,
            final BlancoJsfProcessStructure processStructure) {
        return BlancoNameAdjuster.toClassName(processStructure.getName())
                + BlancoNameAdjuster.toClassName(processStructure.getMethod())
                + structure.getSuffix();
    }

    static void addBeanParameter(final BlancoCgObjectFactory cgFactory,
            final BlancoCgMethod method, final String managedBeanClassName,
            final String description) {
        final String name = "arg"
                + BlancoNameAdjuster.toClassName(BlancoNameUtil
                        .trimJavaPackage(managedBeanClassName));
        method.getParameterList().add(
                cgFactory.createParameter(name, managedBeanClassName,
                        description));
    }

    static void addSqlParameter(final BlancoCgObjectFactory cgFactory,
            final BlancoCgMethod method, final String sqlClassName) {
        final String name = BlancoNameUtil.trimJavaPackage(sqlClassName);
        method.getParameterList().add(
                cgFactory.createParameter("arg" + name, sqlClassName,
                        "SQL`玩ꂽf[^x[XEANZT[B"));
    }
}
